/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.mechanical;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.mechanical.TorqueUnit;
import com.synerset.unitility.unitsystem.mechanical.TorqueUnits;
import java.util.Objects;

public class Torque
implements CalculableQuantity<TorqueUnit, Torque> {
    public static final Torque PHYSICAL_MIN_LIMIT = Torque.ofNewtonMeters(0.0);
    private final double value;
    private final double baseValue;
    private final TorqueUnit unitType;

    public Torque(double value, TorqueUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = TorqueUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static Torque of(double value, TorqueUnit unit) {
        return new Torque(value, unit);
    }

    public static Torque of(double value, String unitSymbol) {
        TorqueUnit resolvedUnit = TorqueUnits.fromSymbol(unitSymbol);
        return new Torque(value, resolvedUnit);
    }

    public static Torque ofNewtonMeters(double value) {
        return new Torque(value, TorqueUnits.NEWTON_METER);
    }

    public static Torque ofMillinewtonMeters(double value) {
        return new Torque(value, TorqueUnits.MILLINEWTON_METER);
    }

    public static Torque ofKilopondMeters(double value) {
        return new Torque(value, TorqueUnits.KILOPOND_METER);
    }

    public static Torque ofFootPounds(double value) {
        return new Torque(value, TorqueUnits.FOOT_POUND);
    }

    public static Torque ofInchPounds(double value) {
        return new Torque(value, TorqueUnits.INCH_POUND);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public TorqueUnit getUnitType() {
        return this.unitType;
    }

    public Torque toBaseUnit() {
        double valueInNewtonMeters = this.unitType.toValueInBaseUnit(this.value);
        return Torque.of(valueInNewtonMeters, TorqueUnits.NEWTON_METER);
    }

    public Torque toUnit(TorqueUnit targetUnit) {
        double valueInNewtonMeters = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInNewtonMeters);
        return Torque.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public Torque withValue(double value) {
        return Torque.of(value, this.unitType);
    }

    public Torque toNewtonMeters() {
        return this.toUnit(TorqueUnits.NEWTON_METER);
    }

    public Torque toMillinewtonMeters() {
        return this.toUnit(TorqueUnits.MILLINEWTON_METER);
    }

    public Torque toKilopondMeters() {
        return this.toUnit(TorqueUnits.KILOPOND_METER);
    }

    public Torque toPoundFeet() {
        return this.toUnit(TorqueUnits.FOOT_POUND);
    }

    public Torque toInchPounds() {
        return this.toUnit(TorqueUnits.INCH_POUND);
    }

    public double getInNewtonMeters() {
        return this.getInUnit(TorqueUnits.NEWTON_METER);
    }

    public double getInMillinewtonMeters() {
        return this.getInUnit(TorqueUnits.MILLINEWTON_METER);
    }

    public double getInKilopondMeters() {
        return this.getInUnit(TorqueUnits.KILOPOND_METER);
    }

    public double getInPoundFeet() {
        return this.getInUnit(TorqueUnits.FOOT_POUND);
    }

    public double getInInchPounds() {
        return this.getInUnit(TorqueUnits.INCH_POUND);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Torque inputQuantity = (Torque)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "Torque{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

