/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.thermodynamic;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.thermodynamic.DynamicViscosityUnit;
import com.synerset.unitility.unitsystem.thermodynamic.DynamicViscosityUnits;
import java.util.Objects;

public class DynamicViscosity
implements CalculableQuantity<DynamicViscosityUnit, DynamicViscosity> {
    private final double value;
    private final double baseValue;
    private final DynamicViscosityUnit unitType;

    public DynamicViscosity(double value, DynamicViscosityUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = DynamicViscosityUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static DynamicViscosity of(double value, DynamicViscosityUnit unit) {
        return new DynamicViscosity(value, unit);
    }

    public static DynamicViscosity of(double value, String unitSymbol) {
        DynamicViscosityUnit resolvedUnit = DynamicViscosityUnits.fromSymbol(unitSymbol);
        return new DynamicViscosity(value, resolvedUnit);
    }

    public static DynamicViscosity ofKiloGramPerMeterSecond(double value) {
        return new DynamicViscosity(value, DynamicViscosityUnits.KILOGRAM_PER_METER_SECOND);
    }

    public static DynamicViscosity ofPascalSecond(double value) {
        return new DynamicViscosity(value, DynamicViscosityUnits.PASCAL_SECOND);
    }

    public static DynamicViscosity ofPoise(double value) {
        return new DynamicViscosity(value, DynamicViscosityUnits.POISE);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public DynamicViscosityUnit getUnitType() {
        return this.unitType;
    }

    public DynamicViscosity toBaseUnit() {
        double valueInPascalSecond = this.unitType.toValueInBaseUnit(this.value);
        return DynamicViscosity.of(valueInPascalSecond, DynamicViscosityUnits.PASCAL_SECOND);
    }

    public DynamicViscosity toUnit(DynamicViscosityUnit targetUnit) {
        double valueInPascalSecond = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInPascalSecond);
        return DynamicViscosity.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public DynamicViscosity withValue(double value) {
        return DynamicViscosity.of(value, this.unitType);
    }

    public DynamicViscosity toKiloGramPerMeterSecond() {
        return this.toUnit(DynamicViscosityUnits.KILOGRAM_PER_METER_SECOND);
    }

    public DynamicViscosity toPascalSecond() {
        return this.toUnit(DynamicViscosityUnits.PASCAL_SECOND);
    }

    public DynamicViscosity toPoise() {
        return this.toUnit(DynamicViscosityUnits.POISE);
    }

    public double getInKiloGramPerMeterSecond() {
        return this.getInUnit(DynamicViscosityUnits.KILOGRAM_PER_METER_SECOND);
    }

    public double getInPascalsSecond() {
        return this.getInUnit(DynamicViscosityUnits.PASCAL_SECOND);
    }

    public double getInPoise() {
        return this.getInUnit(DynamicViscosityUnits.POISE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicViscosity inputQuantity = (DynamicViscosity)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "DynamicViscosity{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

