/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.thermodynamic;

import com.synerset.unitility.unitsystem.exceptions.UnitSystemParseException;
import com.synerset.unitility.unitsystem.thermodynamic.DynamicViscosityUnit;
import com.synerset.unitility.unitsystem.util.StringTransformer;
import java.util.function.DoubleUnaryOperator;

public enum DynamicViscosityUnits implements DynamicViscosityUnit
{
    KILOGRAM_PER_METER_SECOND("kg/(m\u00b7s)", val -> val, val -> val),
    PASCAL_SECOND("Pa\u00b7s", val -> val, val -> val),
    POISE("P", val -> val * 0.1, val -> val / 0.1);

    private final String symbol;
    private final DoubleUnaryOperator toBaseConverter;
    private final DoubleUnaryOperator fromBaseToUnitConverter;

    private DynamicViscosityUnits(String symbol, DoubleUnaryOperator toBaseConverter, DoubleUnaryOperator fromBaseToUnitConverter) {
        this.symbol = symbol;
        this.toBaseConverter = toBaseConverter;
        this.fromBaseToUnitConverter = fromBaseToUnitConverter;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public DynamicViscosityUnit getBaseUnit() {
        return KILOGRAM_PER_METER_SECOND;
    }

    @Override
    public double toValueInBaseUnit(double valueInThisUnit) {
        return this.toBaseConverter.applyAsDouble(valueInThisUnit);
    }

    @Override
    public double fromValueInBaseUnit(double valueInBaseUnit) {
        return this.fromBaseToUnitConverter.applyAsDouble(valueInBaseUnit);
    }

    public static DynamicViscosityUnit fromSymbol(String rawSymbol) {
        if (rawSymbol == null || rawSymbol.isBlank()) {
            return DynamicViscosityUnits.getDefaultUnit();
        }
        String requestedSymbol = DynamicViscosityUnits.unifySymbol(rawSymbol);
        for (DynamicViscosityUnits unit : DynamicViscosityUnits.values()) {
            String currentSymbol = DynamicViscosityUnits.unifySymbol(unit.getSymbol());
            if (!currentSymbol.equalsIgnoreCase(requestedSymbol)) continue;
            return unit;
        }
        throw new UnitSystemParseException("Unsupported unit symbol: {" + rawSymbol + "}. Target class: " + DynamicViscosityUnits.class.getSimpleName());
    }

    private static String unifySymbol(String inputString) {
        return StringTransformer.of(inputString).trimLowerAndClean().unifyMultiAndDiv().dropParentheses().toString();
    }

    public static DynamicViscosityUnit getDefaultUnit() {
        return KILOGRAM_PER_METER_SECOND;
    }
}

