/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.thermodynamic;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.thermodynamic.KinematicViscosityUnit;
import com.synerset.unitility.unitsystem.thermodynamic.KinematicViscosityUnits;
import java.util.Objects;

public class KinematicViscosity
implements CalculableQuantity<KinematicViscosityUnit, KinematicViscosity> {
    private final double value;
    private final double baseValue;
    private final KinematicViscosityUnit unitType;

    public KinematicViscosity(double value, KinematicViscosityUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = KinematicViscosityUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static KinematicViscosity of(double value, KinematicViscosityUnit unit) {
        return new KinematicViscosity(value, unit);
    }

    public static KinematicViscosity of(double value, String unitSymbol) {
        KinematicViscosityUnit resolvedUnit = KinematicViscosityUnits.fromSymbol(unitSymbol);
        return new KinematicViscosity(value, resolvedUnit);
    }

    public static KinematicViscosity ofSquareMeterPerSecond(double value) {
        return new KinematicViscosity(value, KinematicViscosityUnits.SQUARE_METER_PER_SECOND);
    }

    public static KinematicViscosity ofSquareFootPerSecond(double value) {
        return new KinematicViscosity(value, KinematicViscosityUnits.SQUARE_FOOT_PER_SECOND);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public KinematicViscosityUnit getUnitType() {
        return this.unitType;
    }

    public KinematicViscosity toBaseUnit() {
        double valueInSquareMeterPerSecond = this.unitType.toValueInBaseUnit(this.value);
        return KinematicViscosity.of(valueInSquareMeterPerSecond, KinematicViscosityUnits.SQUARE_METER_PER_SECOND);
    }

    public KinematicViscosity toUnit(KinematicViscosityUnit targetUnit) {
        double valueInSquareMeterPerSecond = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInSquareMeterPerSecond);
        return KinematicViscosity.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public KinematicViscosity withValue(double value) {
        return KinematicViscosity.of(value, this.unitType);
    }

    public KinematicViscosity toSquareMeterPerSecond() {
        return this.toUnit(KinematicViscosityUnits.SQUARE_METER_PER_SECOND);
    }

    public KinematicViscosity toSquareFootPerSecond() {
        return this.toUnit(KinematicViscosityUnits.SQUARE_FOOT_PER_SECOND);
    }

    public double getInSquareMetersPerSecond() {
        return this.getInUnit(KinematicViscosityUnits.SQUARE_METER_PER_SECOND);
    }

    public double getInSquareFeetPerSecond() {
        return this.getInUnit(KinematicViscosityUnits.SQUARE_FOOT_PER_SECOND);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KinematicViscosity inputQuantity = (KinematicViscosity)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "KinematicViscosity{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

