/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.thermodynamic;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.thermodynamic.PressureUnit;
import com.synerset.unitility.unitsystem.thermodynamic.PressureUnits;
import java.util.Objects;

public class Pressure
implements CalculableQuantity<PressureUnit, Pressure> {
    public static final Pressure STANDARD_ATMOSPHERE = Pressure.ofPascal(101325.0);
    public static final Pressure TECHNICAL_ATMOSPHERE = Pressure.ofPascal(98067.0);
    private final double value;
    private final double baseValue;
    private final PressureUnit unitType;

    public Pressure(double value, PressureUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = PressureUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static Pressure of(double value, PressureUnit unit) {
        return new Pressure(value, unit);
    }

    public static Pressure of(double value, String unitSymbol) {
        PressureUnit resolvedUnit = PressureUnits.fromSymbol(unitSymbol);
        return new Pressure(value, resolvedUnit);
    }

    public static Pressure ofPascal(double value) {
        return new Pressure(value, PressureUnits.PASCAL);
    }

    public static Pressure ofHectoPascal(double value) {
        return new Pressure(value, PressureUnits.HECTOPASCAL);
    }

    public static Pressure ofMegaPascal(double value) {
        return new Pressure(value, PressureUnits.MEGAPASCAL);
    }

    public static Pressure ofBar(double value) {
        return new Pressure(value, PressureUnits.BAR);
    }

    public static Pressure ofMilliBar(double value) {
        return new Pressure(value, PressureUnits.MILLIBAR);
    }

    public static Pressure ofPsi(double value) {
        return new Pressure(value, PressureUnits.PSI);
    }

    public static Pressure ofTorr(double value) {
        return new Pressure(value, PressureUnits.TORR);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public PressureUnit getUnitType() {
        return this.unitType;
    }

    public Pressure toBaseUnit() {
        double valueInPascal = this.unitType.toValueInBaseUnit(this.value);
        return Pressure.of(valueInPascal, PressureUnits.PASCAL);
    }

    public Pressure toUnit(PressureUnit targetUnit) {
        double valueInPascal = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInPascal);
        return Pressure.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public Pressure withValue(double value) {
        return Pressure.of(value, this.unitType);
    }

    public Pressure toPascal() {
        return this.toUnit(PressureUnits.PASCAL);
    }

    public Pressure toHectoPascal() {
        return this.toUnit(PressureUnits.HECTOPASCAL);
    }

    public Pressure toMegaPascal() {
        return this.toUnit(PressureUnits.MEGAPASCAL);
    }

    public Pressure toBar() {
        return this.toUnit(PressureUnits.BAR);
    }

    public Pressure toMilliBar() {
        return this.toUnit(PressureUnits.MILLIBAR);
    }

    public Pressure toPsi() {
        return this.toUnit(PressureUnits.PSI);
    }

    public Pressure toTorr() {
        return this.toUnit(PressureUnits.TORR);
    }

    public double getInPascals() {
        return this.getInUnit(PressureUnits.PASCAL);
    }

    public double getInHectoPascals() {
        return this.getInUnit(PressureUnits.HECTOPASCAL);
    }

    public double getInMegaPascals() {
        return this.getInUnit(PressureUnits.MEGAPASCAL);
    }

    public double getInBar() {
        return this.getInUnit(PressureUnits.BAR);
    }

    public double getInMilliBar() {
        return this.getInUnit(PressureUnits.MILLIBAR);
    }

    public double getInPsi() {
        return this.getInUnit(PressureUnits.PSI);
    }

    public double getInTorr() {
        return this.getInUnit(PressureUnits.TORR);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pressure inputQuantity = (Pressure)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "Pressure{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

