/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.thermodynamic;

import com.synerset.unitility.unitsystem.exceptions.UnitSystemParseException;
import com.synerset.unitility.unitsystem.thermodynamic.PressureUnit;
import com.synerset.unitility.unitsystem.util.StringTransformer;
import java.util.function.DoubleUnaryOperator;

public enum PressureUnits implements PressureUnit
{
    PASCAL("Pa", val -> val, val -> val),
    HECTOPASCAL("hPa", val -> val * 100.0, val -> val / 100.0),
    MEGAPASCAL("MPa", val -> val * 1000000.0, val -> val / 1000000.0),
    BAR("bar", val -> val * 100000.0, val -> val / 100000.0),
    MILLIBAR("mbar", val -> val * 100.0, val -> val / 100.0),
    TORR("Torr", val -> val * 133.322368421053, val -> val / 133.322368421053),
    PSI("psi", val -> val * 6894.757293168, val -> val / 6894.757293168);

    private final String symbol;
    private final DoubleUnaryOperator toBaseConverter;
    private final DoubleUnaryOperator fromBaseToUnitConverter;

    private PressureUnits(String symbol, DoubleUnaryOperator toBaseConverter, DoubleUnaryOperator fromBaseToUnitConverter) {
        this.symbol = symbol;
        this.toBaseConverter = toBaseConverter;
        this.fromBaseToUnitConverter = fromBaseToUnitConverter;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public PressureUnit getBaseUnit() {
        return PASCAL;
    }

    @Override
    public double toValueInBaseUnit(double valueInThisUnit) {
        return this.toBaseConverter.applyAsDouble(valueInThisUnit);
    }

    @Override
    public double fromValueInBaseUnit(double valueInBaseUnit) {
        return this.fromBaseToUnitConverter.applyAsDouble(valueInBaseUnit);
    }

    public static PressureUnit fromSymbol(String rawSymbol) {
        if (rawSymbol == null || rawSymbol.isBlank()) {
            return PressureUnits.getDefaultUnit();
        }
        String requestedSymbol = PressureUnits.unifySymbol(rawSymbol);
        for (PressureUnits unit : PressureUnits.values()) {
            String currentSymbol = PressureUnits.unifySymbol(unit.getSymbol());
            if (!currentSymbol.equalsIgnoreCase(requestedSymbol)) continue;
            return unit;
        }
        throw new UnitSystemParseException("Unsupported unit symbol: {" + rawSymbol + "}. Target class: " + PressureUnits.class.getSimpleName());
    }

    private static String unifySymbol(String inputString) {
        return StringTransformer.of(inputString).trimLowerAndClean().toString();
    }

    public static PressureUnit getDefaultUnit() {
        return PASCAL;
    }
}

