/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.thermodynamic;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.thermodynamic.TemperatureUnit;
import com.synerset.unitility.unitsystem.thermodynamic.TemperatureUnits;
import java.util.Objects;

public class Temperature
implements CalculableQuantity<TemperatureUnit, Temperature> {
    public static final Temperature PHYSICAL_MIN_LIMIT = Temperature.ofKelvins(0.0);
    private final double value;
    private final double baseValue;
    private final TemperatureUnit unitType;

    public Temperature(double value, TemperatureUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = TemperatureUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static Temperature of(double value, TemperatureUnit unit) {
        return new Temperature(value, unit);
    }

    public static Temperature of(double value, String unitSymbol) {
        TemperatureUnit resolvedUnit = TemperatureUnits.fromSymbol(unitSymbol);
        return new Temperature(value, resolvedUnit);
    }

    public static Temperature ofKelvins(double value) {
        return new Temperature(value, TemperatureUnits.KELVIN);
    }

    public static Temperature ofCelsius(double value) {
        return new Temperature(value, TemperatureUnits.CELSIUS);
    }

    public static Temperature ofFahrenheit(double value) {
        return new Temperature(value, TemperatureUnits.FAHRENHEIT);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public TemperatureUnit getUnitType() {
        return this.unitType;
    }

    public Temperature toBaseUnit() {
        double valueInKelvin = this.unitType.toValueInBaseUnit(this.value);
        return Temperature.of(valueInKelvin, TemperatureUnits.KELVIN);
    }

    public Temperature toUnit(TemperatureUnit targetUnit) {
        double valueInKelvin = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInKelvin);
        return Temperature.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public Temperature withValue(double value) {
        return Temperature.of(value, this.unitType);
    }

    public Temperature toKelvin() {
        return this.toUnit(TemperatureUnits.KELVIN);
    }

    public Temperature toCelsius() {
        return this.toUnit(TemperatureUnits.CELSIUS);
    }

    public Temperature toFahrenheit() {
        return this.toUnit(TemperatureUnits.FAHRENHEIT);
    }

    public double getInKelvins() {
        return this.getInUnit(TemperatureUnits.KELVIN);
    }

    public double getInCelsius() {
        return this.getInUnit(TemperatureUnits.CELSIUS);
    }

    public double getInFahrenheits() {
        return this.getInUnit(TemperatureUnits.FAHRENHEIT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Temperature inputQuantity = (Temperature)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        String separator = this.getUnitType().getSymbol().contains("\u00b0") ? "" : " ";
        return "Temperature{" + this.value + separator + this.unitType.getSymbol() + "}";
    }
}

