/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.thermodynamic;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.thermodynamic.ThermalDiffusivityUnit;
import com.synerset.unitility.unitsystem.thermodynamic.ThermalDiffusivityUnits;
import java.util.Objects;

public class ThermalDiffusivity
implements CalculableQuantity<ThermalDiffusivityUnit, ThermalDiffusivity> {
    private final double value;
    private final double baseValue;
    private final ThermalDiffusivityUnit unitType;

    public ThermalDiffusivity(double value, ThermalDiffusivityUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = ThermalDiffusivityUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static ThermalDiffusivity of(double value, ThermalDiffusivityUnit unit) {
        return new ThermalDiffusivity(value, unit);
    }

    public static ThermalDiffusivity of(double value, String unitSymbol) {
        ThermalDiffusivityUnit resolvedUnit = ThermalDiffusivityUnits.fromSymbol(unitSymbol);
        return new ThermalDiffusivity(value, resolvedUnit);
    }

    public static ThermalDiffusivity ofSquareMeterPerSecond(double value) {
        return new ThermalDiffusivity(value, ThermalDiffusivityUnits.SQUARE_METER_PER_SECOND);
    }

    public static ThermalDiffusivity ofSquareFeetPerSecond(double value) {
        return new ThermalDiffusivity(value, ThermalDiffusivityUnits.SQUARE_FEET_PER_SECOND);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public ThermalDiffusivityUnit getUnitType() {
        return this.unitType;
    }

    public ThermalDiffusivity toBaseUnit() {
        double valueInSquareMeterPerSecond = this.unitType.toValueInBaseUnit(this.value);
        return ThermalDiffusivity.of(valueInSquareMeterPerSecond, ThermalDiffusivityUnits.SQUARE_METER_PER_SECOND);
    }

    public ThermalDiffusivity toUnit(ThermalDiffusivityUnit targetUnit) {
        double valueInSquareMeterPerSecond = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInSquareMeterPerSecond);
        return ThermalDiffusivity.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public ThermalDiffusivity withValue(double value) {
        return ThermalDiffusivity.of(value, this.unitType);
    }

    public ThermalDiffusivity toSquareMeterPerSecond() {
        return this.toUnit(ThermalDiffusivityUnits.SQUARE_METER_PER_SECOND);
    }

    public ThermalDiffusivity toSquareFeetPerSecond() {
        return this.toUnit(ThermalDiffusivityUnits.SQUARE_FEET_PER_SECOND);
    }

    public double getInSquareMetersPerSecond() {
        return this.getInUnit(ThermalDiffusivityUnits.SQUARE_METER_PER_SECOND);
    }

    public double getInSquareFeetPerSecond() {
        return this.getInUnit(ThermalDiffusivityUnits.SQUARE_FEET_PER_SECOND);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThermalDiffusivity inputQuantity = (ThermalDiffusivity)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "ThermalDiffusivity{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

