/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.thermodynamic;

import com.synerset.unitility.unitsystem.exceptions.UnitSystemParseException;
import com.synerset.unitility.unitsystem.thermodynamic.ThermalDiffusivityUnit;
import com.synerset.unitility.unitsystem.util.StringTransformer;
import java.util.function.DoubleUnaryOperator;

public enum ThermalDiffusivityUnits implements ThermalDiffusivityUnit
{
    SQUARE_METER_PER_SECOND("m\u00b2/s", val -> val, val -> val),
    SQUARE_FEET_PER_SECOND("ft\u00b2/s", val -> val * 0.09290304, val -> val / 0.09290304);

    private final String symbol;
    private final DoubleUnaryOperator toBaseConverter;
    private final DoubleUnaryOperator fromBaseToUnitConverter;

    private ThermalDiffusivityUnits(String symbol, DoubleUnaryOperator toBaseConverter, DoubleUnaryOperator fromBaseToUnitConverter) {
        this.symbol = symbol;
        this.toBaseConverter = toBaseConverter;
        this.fromBaseToUnitConverter = fromBaseToUnitConverter;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public ThermalDiffusivityUnit getBaseUnit() {
        return SQUARE_METER_PER_SECOND;
    }

    @Override
    public double toValueInBaseUnit(double valueInThisUnit) {
        return this.toBaseConverter.applyAsDouble(valueInThisUnit);
    }

    @Override
    public double fromValueInBaseUnit(double valueInBaseUnit) {
        return this.fromBaseToUnitConverter.applyAsDouble(valueInBaseUnit);
    }

    public static ThermalDiffusivityUnit fromSymbol(String rawSymbol) {
        if (rawSymbol == null || rawSymbol.isBlank()) {
            return ThermalDiffusivityUnits.getDefaultUnit();
        }
        String requestedSymbol = ThermalDiffusivityUnits.unifySymbol(rawSymbol);
        for (ThermalDiffusivityUnits unit : ThermalDiffusivityUnits.values()) {
            String currentSymbol = ThermalDiffusivityUnits.unifySymbol(unit.getSymbol());
            if (!currentSymbol.equalsIgnoreCase(requestedSymbol)) continue;
            return unit;
        }
        throw new UnitSystemParseException("Unsupported unit symbol: {" + rawSymbol + "}. Target class: " + ThermalDiffusivityUnits.class.getSimpleName());
    }

    private static String unifySymbol(String inputSymbol) {
        return StringTransformer.of(inputSymbol).trimLowerAndClean().unifyMultiAndDiv().unifyAerialAndVol().toString();
    }

    public static ThermalDiffusivityUnit getDefaultUnit() {
        return SQUARE_METER_PER_SECOND;
    }
}

