/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.util;

public class StringTransformer {
    private final String inputString;

    private StringTransformer(String inputString) {
        this.inputString = inputString;
    }

    public static StringTransformer of(String inputString) {
        return new StringTransformer(inputString);
    }

    public StringTransformer trimLowerAndClean() {
        return StringTransformer.of(this.inputString.trim().toLowerCase().replace(" ", "").replace("_", ""));
    }

    public StringTransformer unifyAerialAndVol() {
        return StringTransformer.of(this.inputString.replace("cfm", "ft3pmin").replace("\u00b3", "3").replace("\u00b2", "2"));
    }

    public StringTransformer unifyMultiAndDiv() {
        return StringTransformer.of(this.inputString.replace(".", "").replace("\u00b7", "").replace("x", "").replace("/", "p"));
    }

    public StringTransformer unifySymbolsOfAngle() {
        return StringTransformer.of(this.inputString.replace("\u00b0", "o").replace("deg", "o").replace("radian", "rad"));
    }

    public StringTransformer dropDegreeSymbols() {
        return StringTransformer.of(this.inputString.replace("\u00b0", "").replace("o", "").replace("deg", ""));
    }

    public StringTransformer dropParentheses() {
        return StringTransformer.of(this.inputString.replaceAll("[()\\[\\]{}<>]", ""));
    }

    public StringTransformer dropSquareBrackets() {
        return StringTransformer.of(this.inputString.replace("[", ""));
    }

    public StringTransformer replaceCommaForDot() {
        return StringTransformer.of(this.inputString.replace(",", "."));
    }

    public StringTransformer unifyDMSNotationSymbols() {
        String transformedString = this.inputString.replace("\u00b0", "o").replace("deg", "o").replace("d", "o").replace("min", "'").replace("m", "'").replace("sec", "\"");
        if (!transformedString.contains("\"")) {
            transformedString = transformedString.replaceFirst("s", "\"");
        }
        return StringTransformer.of(transformedString);
    }

    public String toString() {
        return this.inputString;
    }
}

