/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.jackson.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.synerset.unitility.unitsystem.PhysicalQuantity;
import com.synerset.unitility.unitsystem.Unit;
import com.synerset.unitility.unitsystem.util.ParsingHelpers;
import com.synerset.unitility.unitsystem.util.PhysicalQuantityParsingFactory;
import java.io.IOException;

public class PhysicalQuantityDeserializer<U extends Unit, Q extends PhysicalQuantity<U>>
extends JsonDeserializer<Q> {
    private final Class<Q> quantityClass;
    protected final PhysicalQuantityParsingFactory parsingFactory;

    public PhysicalQuantityDeserializer(Class<Q> quantityClass, PhysicalQuantityParsingFactory parsingFactory) {
        this.quantityClass = quantityClass;
        this.parsingFactory = parsingFactory;
    }

    public Q deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        JsonNode valueFieldNode = node.get("value");
        JsonNode symbolFieldNode = node.get("unit");
        if (valueFieldNode == null) {
            throw new IOException("Deserialization failure. Field not found: value");
        }
        String inputQuantityAsString = valueFieldNode.asText();
        if (symbolFieldNode == null || ParsingHelpers.containsNonDigitChars((String)inputQuantityAsString)) {
            return (Q)this.parsingFactory.parse(this.quantityClass, inputQuantityAsString);
        }
        double value = node.get("value").asDouble();
        String unitSymbol = node.get("unit").asText();
        return (Q)this.parsingFactory.parseValueAndSymbol(this.quantityClass, value, unitSymbol);
    }
}

