/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.AbstractConnection;
import com.taosdata.jdbc.TSDBDatabaseMetaData;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBJNIConnector;
import com.taosdata.jdbc.TSDBPreparedStatement;
import com.taosdata.jdbc.TSDBStatement;
import com.taosdata.jdbc.TSDBSubscribe;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class TSDBConnection
extends AbstractConnection {
    private TSDBJNIConnector connector;
    private final TSDBDatabaseMetaData databaseMetaData;
    private boolean batchFetch;

    public Boolean getBatchFetch() {
        return this.batchFetch;
    }

    public TSDBConnection(Properties info, TSDBDatabaseMetaData meta) throws SQLException {
        super(info);
        this.databaseMetaData = meta;
        this.connect(info.getProperty("host"), Integer.parseInt(info.getProperty("port", "0")), info.getProperty("dbname"), info.getProperty("user"), info.getProperty("password"));
        String batchLoad = info.getProperty("batchfetch");
        if (batchLoad != null) {
            this.batchFetch = Boolean.parseBoolean(batchLoad);
        }
    }

    private void connect(String host, int port, String dbName, String user, String password) throws SQLException {
        this.connector = new TSDBJNIConnector();
        this.connector.connect(host, port, dbName, user, password);
        this.catalog = dbName;
        this.databaseMetaData.setConnection(this);
    }

    public TSDBJNIConnector getConnector() {
        return this.connector;
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return new TSDBStatement(this);
    }

    public TSDBSubscribe subscribe(String topic, String sql, boolean restart) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        long id = this.connector.subscribe(topic, sql, restart);
        if (id == 0L) {
            throw TSDBError.createSQLException(9041);
        }
        return new TSDBSubscribe(this.connector, id);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return new TSDBPreparedStatement(this, sql);
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.connector.closeConnection();
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connector != null && this.connector.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return this.databaseMetaData;
    }
}

