/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws.entity;

import com.taosdata.jdbc.ws.entity.ConnectResp;
import com.taosdata.jdbc.ws.entity.FetchJsonResp;
import com.taosdata.jdbc.ws.entity.FetchResp;
import com.taosdata.jdbc.ws.entity.IdUtil;
import com.taosdata.jdbc.ws.entity.QueryResp;
import com.taosdata.jdbc.ws.entity.Response;
import java.util.HashMap;
import java.util.Map;

public enum Action {
    CONN("conn", ConnectResp.class),
    QUERY("query", QueryResp.class),
    FETCH("fetch", FetchResp.class),
    FETCH_JSON("fetch_json", FetchJsonResp.class),
    FETCH_BLOCK("fetch_block", Response.class);

    private final String action;
    private final Class<? extends Response> clazz;
    private static final Map<String, Action> actions;

    private Action(String action, Class<? extends Response> clazz) {
        this.action = action;
        this.clazz = clazz;
    }

    public String getAction() {
        return this.action;
    }

    public Class<? extends Response> getResponseClazz() {
        return this.clazz;
    }

    public static Action of(String action) {
        if (null == action || action.equals("")) {
            return null;
        }
        return actions.get(action);
    }

    static {
        actions = new HashMap<String, Action>();
        for (Action value : Action.values()) {
            actions.put(value.action, value);
            IdUtil.init(value.action);
        }
    }
}

