/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.WrapperImpl;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractStatement
extends WrapperImpl
implements Statement {
    protected List<String> batchedArgs;
    private int fetchSize;
    protected int affectedRows = -1;
    protected Long instanceId;

    @Override
    public abstract ResultSet executeQuery(String var1) throws SQLException;

    @Override
    public abstract int executeUpdate(String var1) throws SQLException;

    public abstract ResultSet executeQuery(String var1, Long var2) throws SQLException;

    public abstract int executeUpdate(String var1, Long var2) throws SQLException;

    @Override
    public abstract void close() throws SQLException;

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return 16384;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (max < 0) {
            throw TSDBError.createSQLException(8963);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (max < 0) {
            throw TSDBError.createSQLException(8963);
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (seconds < 0) {
            throw TSDBError.createSQLException(8963);
        }
    }

    @Override
    public void cancel() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public abstract boolean execute(String var1) throws SQLException;

    public abstract boolean execute(String var1, Long var2) throws SQLException;

    @Override
    public abstract ResultSet getResultSet() throws SQLException;

    @Override
    public abstract int getUpdateCount() throws SQLException;

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                throw TSDBError.createSQLException(8963);
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (rows < 0) {
            throw TSDBError.createSQLException(8963);
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList<String>();
        }
        this.batchedArgs.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (this.batchedArgs != null) {
            this.batchedArgs.clear();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        boolean batchErrorIgnore;
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (this.batchedArgs == null || this.batchedArgs.isEmpty()) {
            throw TSDBError.createSQLException(8966);
        }
        String clientInfo = this.getConnection().getClientInfo("batchErrorIgnore");
        boolean bl = batchErrorIgnore = clientInfo == null ? false : Boolean.parseBoolean(clientInfo);
        if (batchErrorIgnore) {
            return this.executeBatchIgnoreException();
        }
        return this.executeBatchThrowException();
    }

    private int[] executeBatchIgnoreException() {
        return this.batchedArgs.stream().mapToInt(sql -> {
            try {
                boolean isSelect = this.execute((String)sql);
                if (isSelect) {
                    return -2;
                }
                return this.getUpdateCount();
            }
            catch (SQLException e) {
                return -3;
            }
        }).toArray();
    }

    private int[] executeBatchThrowException() throws BatchUpdateException {
        int[] res = new int[this.batchedArgs.size()];
        for (int i = 0; i < this.batchedArgs.size(); ++i) {
            try {
                boolean isSelect = this.execute(this.batchedArgs.get(i));
                if (isSelect) {
                    res[i] = -2;
                    continue;
                }
                res[i] = this.getUpdateCount();
                continue;
            }
            catch (SQLException e) {
                String reason = e.getMessage();
                int[] updateCounts = Arrays.copyOfRange(res, 0, i);
                throw new BatchUpdateException(reason, updateCounts, (Throwable)e);
            }
        }
        return res;
    }

    @Override
    public abstract Connection getConnection() throws SQLException;

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.affectedRows = -1;
        switch (current) {
            case 1: {
                return false;
            }
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw TSDBError.createSQLException(8963);
            }
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return 1;
    }

    @Override
    public abstract boolean isClosed() throws SQLException;

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return false;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }
}

