/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.utils.ReqId;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.entity.Action;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.entity.VersionReq;
import com.taosdata.jdbc.ws.entity.VersionResp;
import java.sql.SQLException;

public class VersionUtil {
    private VersionUtil() {
    }

    public static boolean checkVersion(String version) throws SQLException {
        if (version != null) {
            return VersionUtil.compareVersions(version, "3.3.6.0") >= 0;
        }
        return false;
    }

    public static String getVersion(Transport transport) throws SQLException {
        VersionReq versionReq = new VersionReq();
        versionReq.setReqId(ReqId.getReqID());
        VersionResp versionResp = (VersionResp)transport.send(new Request(Action.VERSION.getAction(), versionReq));
        return versionResp.getVersion();
    }

    public static boolean surpportBlob(String version) {
        if (version != null) {
            try {
                return VersionUtil.compareVersions(version, "3.3.7.0.alpha") >= 0;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    public static int compareVersions(String v1, String v2) throws SQLException {
        if (v1 == null || v2 == null) {
            throw TSDBError.createSQLException(8963, "Version strings cannot be null");
        }
        String[] v1Parts = v1.split("[.-]");
        String[] v2Parts = v2.split("[.-]");
        int maxLength = Math.max(v1Parts.length, v2Parts.length);
        for (int i = 0; i < maxLength; ++i) {
            int v2Num;
            String v2Part;
            String v1Part = i < v1Parts.length ? v1Parts[i] : "0";
            String string = v2Part = i < v2Parts.length ? v2Parts[i] : "0";
            if (i == v1Parts.length - 1 && VersionUtil.containsNonDigit(v1Part)) {
                if (i < v2Parts.length && VersionUtil.containsNonDigit(v2Part)) {
                    return v1Part.compareTo(v2Part);
                }
                return -1;
            }
            if (i == v2Parts.length - 1 && VersionUtil.containsNonDigit(v2Part)) {
                return 1;
            }
            int v1Num = VersionUtil.parseVersionPart(v1Part);
            if (v1Num == (v2Num = VersionUtil.parseVersionPart(v2Part))) continue;
            return v1Num - v2Num;
        }
        return 0;
    }

    private static boolean containsNonDigit(String s) {
        for (char c : s.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return true;
        }
        return false;
    }

    private static int parseVersionPart(String part) {
        try {
            return Integer.parseInt(part);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

