/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbeetle;

import com.tigerbeetle.Batch;
import com.tigerbeetle.UInt128;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public final class AccountBatch
extends Batch {
    static final AccountBatch EMPTY = new AccountBatch(0);

    public AccountBatch(int capacity) {
        super(capacity, 128);
    }

    AccountBatch(ByteBuffer buffer) {
        super(buffer, 128);
    }

    public byte[] getId() {
        return this.getUInt128(this.at(0));
    }

    public long getId(UInt128 part) {
        return this.getUInt128(this.at(0), part);
    }

    public void setId(byte[] id) {
        this.putUInt128(this.at(0), id);
    }

    public void setId(long leastSignificant, long mostSignificant) {
        this.putUInt128(this.at(0), leastSignificant, mostSignificant);
    }

    public void setId(long leastSignificant) {
        this.putUInt128(this.at(0), leastSignificant, 0L);
    }

    public BigInteger getDebitsPending() {
        int index = this.at(16);
        return UInt128.asBigInteger(this.getUInt128(index, UInt128.LeastSignificant), this.getUInt128(index, UInt128.MostSignificant));
    }

    public long getDebitsPending(UInt128 part) {
        return this.getUInt128(this.at(16), part);
    }

    void setDebitsPending(BigInteger debitsPending) {
        this.putUInt128(this.at(16), UInt128.asBytes(debitsPending));
    }

    void setDebitsPending(long leastSignificant, long mostSignificant) {
        this.putUInt128(this.at(16), leastSignificant, mostSignificant);
    }

    void setDebitsPending(long leastSignificant) {
        this.putUInt128(this.at(16), leastSignificant, 0L);
    }

    public BigInteger getDebitsPosted() {
        int index = this.at(32);
        return UInt128.asBigInteger(this.getUInt128(index, UInt128.LeastSignificant), this.getUInt128(index, UInt128.MostSignificant));
    }

    public long getDebitsPosted(UInt128 part) {
        return this.getUInt128(this.at(32), part);
    }

    void setDebitsPosted(BigInteger debitsPosted) {
        this.putUInt128(this.at(32), UInt128.asBytes(debitsPosted));
    }

    void setDebitsPosted(long leastSignificant, long mostSignificant) {
        this.putUInt128(this.at(32), leastSignificant, mostSignificant);
    }

    void setDebitsPosted(long leastSignificant) {
        this.putUInt128(this.at(32), leastSignificant, 0L);
    }

    public BigInteger getCreditsPending() {
        int index = this.at(48);
        return UInt128.asBigInteger(this.getUInt128(index, UInt128.LeastSignificant), this.getUInt128(index, UInt128.MostSignificant));
    }

    public long getCreditsPending(UInt128 part) {
        return this.getUInt128(this.at(48), part);
    }

    void setCreditsPending(BigInteger creditsPending) {
        this.putUInt128(this.at(48), UInt128.asBytes(creditsPending));
    }

    void setCreditsPending(long leastSignificant, long mostSignificant) {
        this.putUInt128(this.at(48), leastSignificant, mostSignificant);
    }

    void setCreditsPending(long leastSignificant) {
        this.putUInt128(this.at(48), leastSignificant, 0L);
    }

    public BigInteger getCreditsPosted() {
        int index = this.at(64);
        return UInt128.asBigInteger(this.getUInt128(index, UInt128.LeastSignificant), this.getUInt128(index, UInt128.MostSignificant));
    }

    public long getCreditsPosted(UInt128 part) {
        return this.getUInt128(this.at(64), part);
    }

    void setCreditsPosted(BigInteger creditsPosted) {
        this.putUInt128(this.at(64), UInt128.asBytes(creditsPosted));
    }

    void setCreditsPosted(long leastSignificant, long mostSignificant) {
        this.putUInt128(this.at(64), leastSignificant, mostSignificant);
    }

    void setCreditsPosted(long leastSignificant) {
        this.putUInt128(this.at(64), leastSignificant, 0L);
    }

    public byte[] getUserData128() {
        return this.getUInt128(this.at(80));
    }

    public long getUserData128(UInt128 part) {
        return this.getUInt128(this.at(80), part);
    }

    public void setUserData128(byte[] userData128) {
        this.putUInt128(this.at(80), userData128);
    }

    public void setUserData128(long leastSignificant, long mostSignificant) {
        this.putUInt128(this.at(80), leastSignificant, mostSignificant);
    }

    public void setUserData128(long leastSignificant) {
        this.putUInt128(this.at(80), leastSignificant, 0L);
    }

    public long getUserData64() {
        long value = this.getUInt64(this.at(96));
        return value;
    }

    public void setUserData64(long userData64) {
        this.putUInt64(this.at(96), userData64);
    }

    public int getUserData32() {
        int value = this.getUInt32(this.at(104));
        return value;
    }

    public void setUserData32(int userData32) {
        this.putUInt32(this.at(104), userData32);
    }

    int getReserved() {
        int value = this.getUInt32(this.at(108));
        return value;
    }

    void setReserved(int reserved) {
        this.putUInt32(this.at(108), reserved);
    }

    public int getLedger() {
        int value = this.getUInt32(this.at(112));
        return value;
    }

    public void setLedger(int ledger) {
        this.putUInt32(this.at(112), ledger);
    }

    public int getCode() {
        int value = this.getUInt16(this.at(116));
        return value;
    }

    public void setCode(int code) {
        this.putUInt16(this.at(116), code);
    }

    public int getFlags() {
        int value = this.getUInt16(this.at(118));
        return value;
    }

    public void setFlags(int flags) {
        this.putUInt16(this.at(118), flags);
    }

    public long getTimestamp() {
        long value = this.getUInt64(this.at(120));
        return value;
    }

    void setTimestamp(long timestamp) {
        this.putUInt64(this.at(120), timestamp);
    }

    static interface Struct {
        public static final int SIZE = 128;
        public static final int Id = 0;
        public static final int DebitsPending = 16;
        public static final int DebitsPosted = 32;
        public static final int CreditsPending = 48;
        public static final int CreditsPosted = 64;
        public static final int UserData128 = 80;
        public static final int UserData64 = 96;
        public static final int UserData32 = 104;
        public static final int Reserved = 108;
        public static final int Ledger = 112;
        public static final int Code = 116;
        public static final int Flags = 118;
        public static final int Timestamp = 120;
    }
}

