/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbeetle;

import com.tigerbeetle.AssertionError;
import com.tigerbeetle.UInt128;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

public abstract class Batch {
    static final ByteOrder BYTE_ORDER = ByteOrder.nativeOrder();
    private int position;
    private CursorStatus cursorStatus;
    private int length;
    private final int capacity;
    private final ByteBuffer buffer;
    private final int ELEMENT_SIZE;

    Batch(int capacity, int ELEMENT_SIZE) {
        AssertionError.assertTrue(ELEMENT_SIZE > 0, "Element size cannot be zero or negative", new Object[0]);
        if (capacity < 0) {
            throw new IllegalArgumentException("Buffer capacity cannot be negative");
        }
        this.ELEMENT_SIZE = ELEMENT_SIZE;
        this.length = 0;
        this.capacity = capacity;
        this.position = -1;
        this.cursorStatus = CursorStatus.Begin;
        int bufferCapacity = capacity * ELEMENT_SIZE;
        this.buffer = ByteBuffer.allocateDirect(bufferCapacity).order(BYTE_ORDER);
    }

    Batch(ByteBuffer buffer, int ELEMENT_SIZE) {
        AssertionError.assertTrue(ELEMENT_SIZE > 0, "Element size cannot be zero or negative", new Object[0]);
        Objects.requireNonNull(buffer, "Buffer cannot be null");
        this.ELEMENT_SIZE = ELEMENT_SIZE;
        int bufferLen = buffer.capacity();
        AssertionError.assertTrue(bufferLen % ELEMENT_SIZE == 0, "Invalid data received from completion handler: bufferLen=%d, elementSize=%d.", bufferLen, ELEMENT_SIZE);
        this.length = this.capacity = bufferLen / ELEMENT_SIZE;
        this.position = -1;
        this.cursorStatus = CursorStatus.Begin;
        this.buffer = buffer.order(BYTE_ORDER);
    }

    public final boolean isReadOnly() {
        return this.buffer.isReadOnly();
    }

    public final void add() {
        if (this.isReadOnly()) {
            throw new IllegalStateException("Cannot add an element in a read-only batch");
        }
        int currentLen = this.length;
        if (currentLen >= this.capacity) {
            throw new IndexOutOfBoundsException(String.format("Cannot add an element because the batch's capacity of %d was exceeded", this.capacity));
        }
        this.length = currentLen + 1;
        this.setPosition(currentLen);
    }

    public final boolean next() {
        if (this.cursorStatus == CursorStatus.End) {
            throw new IndexOutOfBoundsException("This batch reached the end");
        }
        int nextPosition = this.position + 1;
        if (nextPosition >= this.length) {
            this.position = -1;
            this.cursorStatus = this.length > 0 ? CursorStatus.End : CursorStatus.Begin;
            return false;
        }
        this.setPosition(nextPosition);
        return true;
    }

    public final boolean isValidPosition() {
        return this.cursorStatus == CursorStatus.Valid;
    }

    public final void beforeFirst() {
        this.position = -1;
        this.cursorStatus = CursorStatus.Begin;
    }

    public final int getPosition() {
        return this.position;
    }

    public final void setPosition(int newPosition) {
        if (newPosition < 0 || newPosition >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        this.position = newPosition;
        this.cursorStatus = CursorStatus.Valid;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getCapacity() {
        return this.capacity;
    }

    final ByteBuffer getBuffer() {
        return this.buffer.position(0);
    }

    final int getBufferLen() {
        return this.length * this.ELEMENT_SIZE;
    }

    protected final int at(int fieldOffSet) {
        if (this.cursorStatus != CursorStatus.Valid) {
            throw new IllegalStateException();
        }
        int elementPosition = this.position * this.ELEMENT_SIZE;
        return elementPosition + fieldOffSet;
    }

    protected final byte[] getUInt128(int index) {
        byte[] bytes = new byte[16];
        this.buffer.position(index).get(bytes);
        return bytes;
    }

    protected final long getUInt128(int index, UInt128 part) {
        if (part == UInt128.LeastSignificant) {
            return this.buffer.getLong(index);
        }
        return this.buffer.getLong(index + 8);
    }

    protected final void putUInt128(int index, byte[] value) {
        if (value == null) {
            this.putUInt128(index, 0L, 0L);
        } else {
            if (value.length != 16) {
                throw new IllegalArgumentException("UInt128 must be 16 bytes long");
            }
            this.buffer.position(index).put(value);
        }
    }

    protected final void putUInt128(int index, long leastSignificant, long mostSignificant) {
        this.buffer.putLong(index, leastSignificant);
        this.buffer.putLong(index + 8, mostSignificant);
    }

    protected final long getUInt64(int index) {
        return this.buffer.getLong(index);
    }

    protected final void putUInt64(int index, long value) {
        this.buffer.putLong(index, value);
    }

    protected final int getUInt32(int index) {
        return this.buffer.getInt(index);
    }

    protected final void putUInt32(int index, int value) {
        this.buffer.putInt(index, value);
    }

    protected final int getUInt16(int index) {
        return Short.toUnsignedInt(this.buffer.getShort(index));
    }

    protected final void putUInt16(int index, int value) {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException("Value must be a 16-bit unsigned integer");
        }
        this.buffer.putShort(index, (short)value);
    }

    protected final byte[] getArray(int index, int len) {
        byte[] array = new byte[len];
        this.buffer.position(index);
        this.buffer.get(array);
        return array;
    }

    protected final void putArray(int index, byte[] array) {
        Objects.requireNonNull(array, "Array cannot be null");
        this.buffer.position(index);
        this.buffer.put(array);
    }

    static {
        AssertionError.assertTrue(BYTE_ORDER == ByteOrder.LITTLE_ENDIAN, "Native byte order LITTLE ENDIAN expected", new Object[0]);
    }

    private static enum CursorStatus {
        Begin,
        Valid,
        End;

        public static final int INVALID_POSITION = -1;
    }
}

