/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbeetle;

import com.tigerbeetle.AccountBalanceBatch;
import com.tigerbeetle.AccountBatch;
import com.tigerbeetle.AccountFilter;
import com.tigerbeetle.AssertionError;
import com.tigerbeetle.Batch;
import com.tigerbeetle.CreateAccountResultBatch;
import com.tigerbeetle.CreateTransferResultBatch;
import com.tigerbeetle.IdBatch;
import com.tigerbeetle.NativeClient;
import com.tigerbeetle.Request;
import com.tigerbeetle.RequestException;
import com.tigerbeetle.TransferBatch;

final class BlockingRequest<TResponse extends Batch>
extends Request<TResponse> {
    private TResponse result = null;
    private Throwable exception = null;

    BlockingRequest(NativeClient nativeClient, Request.Operations operation, Batch batch) {
        super(nativeClient, operation, batch);
    }

    public static BlockingRequest<CreateAccountResultBatch> createAccounts(NativeClient nativeClient, AccountBatch batch) {
        return new BlockingRequest<CreateAccountResultBatch>(nativeClient, Request.Operations.CREATE_ACCOUNTS, batch);
    }

    public static BlockingRequest<AccountBatch> lookupAccounts(NativeClient nativeClient, IdBatch batch) {
        return new BlockingRequest<AccountBatch>(nativeClient, Request.Operations.LOOKUP_ACCOUNTS, batch);
    }

    public static BlockingRequest<CreateTransferResultBatch> createTransfers(NativeClient nativeClient, TransferBatch batch) {
        return new BlockingRequest<CreateTransferResultBatch>(nativeClient, Request.Operations.CREATE_TRANSFERS, batch);
    }

    public static BlockingRequest<TransferBatch> lookupTransfers(NativeClient nativeClient, IdBatch batch) {
        return new BlockingRequest<TransferBatch>(nativeClient, Request.Operations.LOOKUP_TRANSFERS, batch);
    }

    public static BlockingRequest<TransferBatch> getAccountTransfers(NativeClient nativeClient, AccountFilter filter) {
        return new BlockingRequest<TransferBatch>(nativeClient, Request.Operations.GET_ACCOUNT_TRANSFERS, filter.batch);
    }

    public static BlockingRequest<AccountBalanceBatch> getAccountBalances(NativeClient nativeClient, AccountFilter filter) {
        return new BlockingRequest<AccountBalanceBatch>(nativeClient, Request.Operations.GET_ACCOUNT_BALANCES, filter.batch);
    }

    public static BlockingRequest<AccountBatch> echo(NativeClient nativeClient, AccountBatch batch) {
        return new BlockingRequest<AccountBatch>(nativeClient, Request.Operations.ECHO_ACCOUNTS, batch);
    }

    public static BlockingRequest<TransferBatch> echo(NativeClient nativeClient, TransferBatch batch) {
        return new BlockingRequest<TransferBatch>(nativeClient, Request.Operations.ECHO_TRANSFERS, batch);
    }

    public boolean isDone() {
        return this.result != null || this.exception != null;
    }

    public TResponse waitForResult() {
        this.waitForCompletionUninterruptibly();
        return this.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setResult(TResponse result) {
        BlockingRequest blockingRequest = this;
        synchronized (blockingRequest) {
            if (this.isDone()) {
                this.result = null;
                this.exception = new AssertionError(this.exception, "This request has already been completed", new Object[0]);
            } else {
                this.result = result;
                this.exception = null;
            }
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setException(Throwable exception) {
        BlockingRequest blockingRequest = this;
        synchronized (blockingRequest) {
            this.result = null;
            this.exception = exception;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCompletionUninterruptibly() {
        block6: {
            try {
                if (this.isDone()) break block6;
                BlockingRequest blockingRequest = this;
                synchronized (blockingRequest) {
                    while (!this.isDone()) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                throw new AssertionError(interruptedException, "Unexpected thread interruption on waitForCompletion.", new Object[0]);
            }
        }
    }

    TResponse getResult() {
        AssertionError.assertTrue(this.result != null || this.exception != null, "Unexpected request result: result=null", new Object[0]);
        if (this.exception != null) {
            if (this.exception instanceof RequestException) {
                throw (RequestException)this.exception;
            }
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            if (this.exception instanceof Error) {
                throw (Error)this.exception;
            }
            throw new AssertionError(this.exception, "Unexpected exception", new Object[0]);
        }
        return this.result;
    }
}

