/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbeetle;

import com.tigerbeetle.AccountBalanceBatch;
import com.tigerbeetle.AccountBatch;
import com.tigerbeetle.AccountFilter;
import com.tigerbeetle.AsyncRequest;
import com.tigerbeetle.BlockingRequest;
import com.tigerbeetle.ConcurrencyExceededException;
import com.tigerbeetle.CreateAccountResultBatch;
import com.tigerbeetle.CreateTransferResultBatch;
import com.tigerbeetle.IdBatch;
import com.tigerbeetle.NativeClient;
import com.tigerbeetle.TransferBatch;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;

public final class Client
implements AutoCloseable {
    private static final int DEFAULT_MAX_CONCURRENCY = 256;
    private final byte[] clusterID;
    private final NativeClient nativeClient;

    public Client(byte[] clusterID, String[] replicaAddresses, int concurrencyMax) {
        Objects.requireNonNull(clusterID, "ClusterID cannot be null");
        if (clusterID.length != 16) {
            throw new IllegalArgumentException("ClusterID must be 16 bytes long");
        }
        if (concurrencyMax <= 0) {
            throw new IllegalArgumentException("Invalid concurrencyMax");
        }
        Objects.requireNonNull(replicaAddresses, "Replica addresses cannot be null");
        if (replicaAddresses.length == 0) {
            throw new IllegalArgumentException("Empty replica addresses");
        }
        StringJoiner joiner = new StringJoiner(",");
        for (String address : replicaAddresses) {
            Objects.requireNonNull(address, "Replica address cannot be null");
            joiner.add(address);
        }
        this.clusterID = clusterID;
        this.nativeClient = NativeClient.init(clusterID, joiner.toString(), concurrencyMax);
    }

    public Client(byte[] clusterID, String[] replicaAddresses) {
        this(clusterID, replicaAddresses, 256);
    }

    public byte[] getClusterID() {
        return this.clusterID;
    }

    public CreateAccountResultBatch createAccounts(AccountBatch batch) throws ConcurrencyExceededException {
        BlockingRequest<CreateAccountResultBatch> request = BlockingRequest.createAccounts(this.nativeClient, batch);
        request.beginRequest();
        return request.waitForResult();
    }

    public CompletableFuture<CreateAccountResultBatch> createAccountsAsync(AccountBatch batch) throws ConcurrencyExceededException {
        AsyncRequest<CreateAccountResultBatch> request = AsyncRequest.createAccounts(this.nativeClient, batch);
        request.beginRequest();
        return request.getFuture();
    }

    public AccountBatch lookupAccounts(IdBatch batch) throws ConcurrencyExceededException {
        BlockingRequest<AccountBatch> request = BlockingRequest.lookupAccounts(this.nativeClient, batch);
        request.beginRequest();
        return request.waitForResult();
    }

    public CompletableFuture<AccountBatch> lookupAccountsAsync(IdBatch batch) throws ConcurrencyExceededException {
        AsyncRequest<AccountBatch> request = AsyncRequest.lookupAccounts(this.nativeClient, batch);
        request.beginRequest();
        return request.getFuture();
    }

    public CreateTransferResultBatch createTransfers(TransferBatch batch) throws ConcurrencyExceededException {
        BlockingRequest<CreateTransferResultBatch> request = BlockingRequest.createTransfers(this.nativeClient, batch);
        request.beginRequest();
        return request.waitForResult();
    }

    public CompletableFuture<CreateTransferResultBatch> createTransfersAsync(TransferBatch batch) throws ConcurrencyExceededException {
        AsyncRequest<CreateTransferResultBatch> request = AsyncRequest.createTransfers(this.nativeClient, batch);
        request.beginRequest();
        return request.getFuture();
    }

    public TransferBatch lookupTransfers(IdBatch batch) throws ConcurrencyExceededException {
        BlockingRequest<TransferBatch> request = BlockingRequest.lookupTransfers(this.nativeClient, batch);
        request.beginRequest();
        return request.waitForResult();
    }

    public CompletableFuture<TransferBatch> lookupTransfersAsync(IdBatch batch) throws ConcurrencyExceededException {
        AsyncRequest<TransferBatch> request = AsyncRequest.lookupTransfers(this.nativeClient, batch);
        request.beginRequest();
        return request.getFuture();
    }

    public TransferBatch getAccountTransfers(AccountFilter filter) throws ConcurrencyExceededException {
        BlockingRequest<TransferBatch> request = BlockingRequest.getAccountTransfers(this.nativeClient, filter);
        request.beginRequest();
        return request.waitForResult();
    }

    public CompletableFuture<TransferBatch> getAccountTransfersAsync(AccountFilter filter) throws ConcurrencyExceededException {
        AsyncRequest<TransferBatch> request = AsyncRequest.getAccountTransfers(this.nativeClient, filter);
        request.beginRequest();
        return request.getFuture();
    }

    public AccountBalanceBatch getAccountBalances(AccountFilter filter) throws ConcurrencyExceededException {
        BlockingRequest<AccountBalanceBatch> request = BlockingRequest.getAccountBalances(this.nativeClient, filter);
        request.beginRequest();
        return request.waitForResult();
    }

    public CompletableFuture<AccountBalanceBatch> getAccountBalancesAsync(AccountFilter filter) throws ConcurrencyExceededException {
        AsyncRequest<AccountBalanceBatch> request = AsyncRequest.getAccountBalances(this.nativeClient, filter);
        request.beginRequest();
        return request.getFuture();
    }

    @Override
    public void close() {
        this.nativeClient.close();
    }
}

