/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbeetle;

import com.tigerbeetle.AssertionError;
import com.tigerbeetle.ConcurrencyExceededException;
import com.tigerbeetle.JNILoader;
import com.tigerbeetle.PacketAcquireStatus;
import com.tigerbeetle.Request;
import java.lang.ref.Cleaner;
import java.util.concurrent.atomic.AtomicLong;

final class NativeClient
implements AutoCloseable {
    private static final Cleaner cleaner;
    private final NativeHandle handle;
    private final Cleaner.Cleanable cleanable;

    public static NativeClient init(byte[] clusterID, String addresses, int concurrencyMax) {
        NativeClient.assertArgs(clusterID, addresses, concurrencyMax);
        long contextHandle = NativeClient.clientInit(clusterID, addresses, concurrencyMax);
        return new NativeClient(contextHandle);
    }

    public static NativeClient initEcho(byte[] clusterID, String addresses, int concurrencyMax) {
        NativeClient.assertArgs(clusterID, addresses, concurrencyMax);
        long contextHandle = NativeClient.clientInitEcho(clusterID, addresses, concurrencyMax);
        return new NativeClient(contextHandle);
    }

    private static void assertArgs(byte[] clusterID, String addresses, int concurrencyMax) {
        AssertionError.assertTrue(clusterID.length == 16, "ClusterID must be a UInt128", new Object[0]);
        AssertionError.assertTrue(addresses != null, "Replica addresses cannot be null", new Object[0]);
        AssertionError.assertTrue(concurrencyMax > 0, "Invalid concurrencyMax", new Object[0]);
    }

    private NativeClient(long contextHandle) {
        try {
            this.handle = new NativeHandle(contextHandle);
            this.cleanable = cleaner.register(this, this.handle);
        }
        catch (Throwable forward) {
            NativeClient.clientDeinit(contextHandle);
            throw forward;
        }
    }

    public void submit(Request<?> request) throws ConcurrencyExceededException {
        this.handle.submit(request);
    }

    @Override
    public void close() {
        this.handle.close();
        this.cleanable.clean();
    }

    private static native int submit(long var0, Request<?> var2);

    private static native long clientInit(byte[] var0, String var1, int var2);

    private static native long clientInitEcho(byte[] var0, String var1, int var2);

    private static native void clientDeinit(long var0);

    static {
        JNILoader.loadFromJar();
        cleaner = Cleaner.create();
    }

    private static final class NativeHandle
    implements Runnable {
        private final AtomicLong atomicHandle;
        private final AtomicLong atomicHandleReferences;

        public NativeHandle(long handle) {
            this.atomicHandle = new AtomicLong(handle);
            this.atomicHandleReferences = new AtomicLong(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void submit(Request<?> request) throws ConcurrencyExceededException {
            try {
                this.atomicHandleReferences.incrementAndGet();
                long handle = this.atomicHandle.getAcquire();
                if (handle == 0L) {
                    throw new IllegalStateException("Client is closed");
                }
                int packet_acquire_status = NativeClient.submit(handle, request);
                if (packet_acquire_status == PacketAcquireStatus.ConcurrencyMaxExceeded.value) {
                    throw new ConcurrencyExceededException();
                }
                if (packet_acquire_status == PacketAcquireStatus.Shutdown.value) {
                    throw new IllegalStateException("Client is closing");
                }
                AssertionError.assertTrue(packet_acquire_status == PacketAcquireStatus.Ok.value, "PacketAcquireStatus=%d is not implemented", packet_acquire_status);
            }
            finally {
                this.atomicHandleReferences.decrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.atomicHandle.getAcquire() != 0L) {
                NativeHandle nativeHandle = this;
                synchronized (nativeHandle) {
                    long handle = this.atomicHandle.getAcquire();
                    if (handle != 0L) {
                        this.atomicHandle.setRelease(0L);
                        while (this.atomicHandleReferences.getAcquire() > 0L) {
                            Thread.onSpinWait();
                        }
                        NativeClient.clientDeinit(handle);
                    }
                }
            }
        }

        @Override
        public void run() {
            this.close();
        }
    }
}

