/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbeetle;

import com.tigerbeetle.AccountBalanceBatch;
import com.tigerbeetle.AccountBatch;
import com.tigerbeetle.AssertionError;
import com.tigerbeetle.Batch;
import com.tigerbeetle.ConcurrencyExceededException;
import com.tigerbeetle.CreateAccountResultBatch;
import com.tigerbeetle.CreateTransferResultBatch;
import com.tigerbeetle.NativeClient;
import com.tigerbeetle.PacketStatus;
import com.tigerbeetle.RequestException;
import com.tigerbeetle.TransferBatch;
import java.nio.ByteBuffer;
import java.util.Objects;

abstract class Request<TResponse extends Batch> {
    private final ByteBuffer sendBuffer;
    private final long sendBufferLen;
    private byte[] replyBuffer;
    private final NativeClient nativeClient;
    private final Operations operation;
    private final int requestLen;

    protected Request(NativeClient nativeClient, Operations operation, Batch batch) {
        Objects.requireNonNull(nativeClient, "Client cannot be null");
        Objects.requireNonNull(batch, "Batch cannot be null");
        this.nativeClient = nativeClient;
        this.operation = operation;
        this.requestLen = batch.getLength();
        this.sendBuffer = batch.getBuffer();
        this.sendBufferLen = batch.getBufferLen();
        this.replyBuffer = null;
        if (this.sendBufferLen == 0L || this.requestLen == 0) {
            throw new IllegalArgumentException("Empty batch");
        }
    }

    public void beginRequest() throws ConcurrencyExceededException {
        this.nativeClient.submit(this);
    }

    void endRequest(byte receivedOperation, byte status) {
        Batch result = null;
        Object exception = null;
        try {
            if (receivedOperation != this.operation.value) {
                exception = new AssertionError("Unexpected callback operation: expected=%d, actual=%d", this.operation.value, receivedOperation);
            } else if (status != PacketStatus.Ok.value) {
                exception = new RequestException(status);
            } else {
                switch (this.operation) {
                    case CREATE_ACCOUNTS: {
                        result = this.replyBuffer == null ? CreateAccountResultBatch.EMPTY : new CreateAccountResultBatch(ByteBuffer.wrap(this.replyBuffer));
                        exception = this.checkResultLength(result);
                        break;
                    }
                    case CREATE_TRANSFERS: {
                        result = this.replyBuffer == null ? CreateTransferResultBatch.EMPTY : new CreateTransferResultBatch(ByteBuffer.wrap(this.replyBuffer));
                        exception = this.checkResultLength(result);
                        break;
                    }
                    case ECHO_ACCOUNTS: 
                    case LOOKUP_ACCOUNTS: {
                        result = this.replyBuffer == null ? AccountBatch.EMPTY : new AccountBatch(ByteBuffer.wrap(this.replyBuffer));
                        exception = this.checkResultLength(result);
                        break;
                    }
                    case ECHO_TRANSFERS: 
                    case LOOKUP_TRANSFERS: {
                        result = this.replyBuffer == null ? TransferBatch.EMPTY : new TransferBatch(ByteBuffer.wrap(this.replyBuffer));
                        exception = this.checkResultLength(result);
                        break;
                    }
                    case GET_ACCOUNT_TRANSFERS: {
                        result = this.replyBuffer == null ? TransferBatch.EMPTY : new TransferBatch(ByteBuffer.wrap(this.replyBuffer));
                        break;
                    }
                    case GET_ACCOUNT_BALANCES: {
                        result = this.replyBuffer == null ? AccountBalanceBatch.EMPTY : new AccountBalanceBatch(ByteBuffer.wrap(this.replyBuffer));
                        break;
                    }
                    default: {
                        exception = new AssertionError("Unknown operation %d", new Object[]{this.operation});
                    }
                }
            }
        }
        catch (Throwable any) {
            exception = any;
        }
        if (exception == null) {
            this.setResult(result);
        } else {
            this.setException((Throwable)exception);
        }
    }

    private AssertionError checkResultLength(Batch result) {
        if (result.getLength() > this.requestLen) {
            return new AssertionError("Amount of results is greater than the amount of requests: resultLen=%d, requestLen=%d", result.getLength(), this.requestLen);
        }
        return null;
    }

    void setReplyBuffer(byte[] buffer) {
        this.replyBuffer = buffer;
    }

    byte getOperation() {
        return this.operation.value;
    }

    protected abstract void setResult(TResponse var1);

    protected abstract void setException(Throwable var1);

    static enum Operations {
        PULSE(128),
        CREATE_ACCOUNTS(129),
        CREATE_TRANSFERS(130),
        LOOKUP_ACCOUNTS(131),
        LOOKUP_TRANSFERS(132),
        GET_ACCOUNT_TRANSFERS(133),
        GET_ACCOUNT_BALANCES(134),
        ECHO_ACCOUNTS(129),
        ECHO_TRANSFERS(130);

        byte value;

        private Operations(int value) {
            this.value = (byte)value;
        }
    }
}

