/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbeetle;

import com.tigerbeetle.Batch;
import com.tigerbeetle.UInt128;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public final class TransferBatch
extends Batch {
    static final TransferBatch EMPTY = new TransferBatch(0);

    public TransferBatch(int capacity) {
        super(capacity, 128);
    }

    TransferBatch(ByteBuffer buffer) {
        super(buffer, 128);
    }

    public byte[] getId() {
        return this.getUInt128(this.at(0));
    }

    public long getId(UInt128 part) {
        return this.getUInt128(this.at(0), part);
    }

    public void setId(byte[] id) {
        this.putUInt128(this.at(0), id);
    }

    public void setId(long leastSignificant, long mostSignificant) {
        this.putUInt128(this.at(0), leastSignificant, mostSignificant);
    }

    public void setId(long leastSignificant) {
        this.putUInt128(this.at(0), leastSignificant, 0L);
    }

    public byte[] getDebitAccountId() {
        return this.getUInt128(this.at(16));
    }

    public long getDebitAccountId(UInt128 part) {
        return this.getUInt128(this.at(16), part);
    }

    public void setDebitAccountId(byte[] debitAccountId) {
        this.putUInt128(this.at(16), debitAccountId);
    }

    public void setDebitAccountId(long leastSignificant, long mostSignificant) {
        this.putUInt128(this.at(16), leastSignificant, mostSignificant);
    }

    public void setDebitAccountId(long leastSignificant) {
        this.putUInt128(this.at(16), leastSignificant, 0L);
    }

    public byte[] getCreditAccountId() {
        return this.getUInt128(this.at(32));
    }

    public long getCreditAccountId(UInt128 part) {
        return this.getUInt128(this.at(32), part);
    }

    public void setCreditAccountId(byte[] creditAccountId) {
        this.putUInt128(this.at(32), creditAccountId);
    }

    public void setCreditAccountId(long leastSignificant, long mostSignificant) {
        this.putUInt128(this.at(32), leastSignificant, mostSignificant);
    }

    public void setCreditAccountId(long leastSignificant) {
        this.putUInt128(this.at(32), leastSignificant, 0L);
    }

    public BigInteger getAmount() {
        int index = this.at(48);
        return UInt128.asBigInteger(this.getUInt128(index, UInt128.LeastSignificant), this.getUInt128(index, UInt128.MostSignificant));
    }

    public long getAmount(UInt128 part) {
        return this.getUInt128(this.at(48), part);
    }

    public void setAmount(BigInteger amount) {
        this.putUInt128(this.at(48), UInt128.asBytes(amount));
    }

    public void setAmount(long leastSignificant, long mostSignificant) {
        this.putUInt128(this.at(48), leastSignificant, mostSignificant);
    }

    public void setAmount(long leastSignificant) {
        this.putUInt128(this.at(48), leastSignificant, 0L);
    }

    public byte[] getPendingId() {
        return this.getUInt128(this.at(64));
    }

    public long getPendingId(UInt128 part) {
        return this.getUInt128(this.at(64), part);
    }

    public void setPendingId(byte[] pendingId) {
        this.putUInt128(this.at(64), pendingId);
    }

    public void setPendingId(long leastSignificant, long mostSignificant) {
        this.putUInt128(this.at(64), leastSignificant, mostSignificant);
    }

    public void setPendingId(long leastSignificant) {
        this.putUInt128(this.at(64), leastSignificant, 0L);
    }

    public byte[] getUserData128() {
        return this.getUInt128(this.at(80));
    }

    public long getUserData128(UInt128 part) {
        return this.getUInt128(this.at(80), part);
    }

    public void setUserData128(byte[] userData128) {
        this.putUInt128(this.at(80), userData128);
    }

    public void setUserData128(long leastSignificant, long mostSignificant) {
        this.putUInt128(this.at(80), leastSignificant, mostSignificant);
    }

    public void setUserData128(long leastSignificant) {
        this.putUInt128(this.at(80), leastSignificant, 0L);
    }

    public long getUserData64() {
        long value = this.getUInt64(this.at(96));
        return value;
    }

    public void setUserData64(long userData64) {
        this.putUInt64(this.at(96), userData64);
    }

    public int getUserData32() {
        int value = this.getUInt32(this.at(104));
        return value;
    }

    public void setUserData32(int userData32) {
        this.putUInt32(this.at(104), userData32);
    }

    public int getTimeout() {
        int value = this.getUInt32(this.at(108));
        return value;
    }

    public void setTimeout(int timeout) {
        this.putUInt32(this.at(108), timeout);
    }

    public int getLedger() {
        int value = this.getUInt32(this.at(112));
        return value;
    }

    public void setLedger(int ledger) {
        this.putUInt32(this.at(112), ledger);
    }

    public int getCode() {
        int value = this.getUInt16(this.at(116));
        return value;
    }

    public void setCode(int code) {
        this.putUInt16(this.at(116), code);
    }

    public int getFlags() {
        int value = this.getUInt16(this.at(118));
        return value;
    }

    public void setFlags(int flags) {
        this.putUInt16(this.at(118), flags);
    }

    public long getTimestamp() {
        long value = this.getUInt64(this.at(120));
        return value;
    }

    void setTimestamp(long timestamp) {
        this.putUInt64(this.at(120), timestamp);
    }

    static interface Struct {
        public static final int SIZE = 128;
        public static final int Id = 0;
        public static final int DebitAccountId = 16;
        public static final int CreditAccountId = 32;
        public static final int Amount = 48;
        public static final int PendingId = 64;
        public static final int UserData128 = 80;
        public static final int UserData64 = 96;
        public static final int UserData32 = 104;
        public static final int Timeout = 108;
        public static final int Ledger = 112;
        public static final int Code = 116;
        public static final int Flags = 118;
        public static final int Timestamp = 120;
    }
}

