/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbeetle;

import com.tigerbeetle.Batch;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.UUID;

public enum UInt128 {
    LeastSignificant,
    MostSignificant;

    public static final int SIZE = 16;
    private static final BigInteger MOST_SIGNIFICANT_MASK;
    private static final BigInteger LEAST_SIGNIFICANT_MASK;
    private static long idLastTimestamp;
    private static final byte[] idLastRandom;
    private static final SecureRandom idSecureRandom;

    public static long asLong(byte[] bytes, UInt128 part) {
        Objects.requireNonNull(bytes, "Bytes cannot be null");
        if (bytes.length != 16) {
            throw new IllegalArgumentException("Bytes must be 16 bytes long");
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(Batch.BYTE_ORDER).position(0);
        if (part == MostSignificant) {
            buffer.position(8);
        }
        return buffer.getLong();
    }

    public static byte[] asBytes(long leastSignificant, long mostSignificant) {
        byte[] bytes = new byte[16];
        if (leastSignificant != 0L || mostSignificant != 0L) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes).order(Batch.BYTE_ORDER);
            buffer.putLong(leastSignificant);
            buffer.putLong(mostSignificant);
        }
        return bytes;
    }

    public static byte[] asBytes(long leastSignificant) {
        return UInt128.asBytes(leastSignificant, 0L);
    }

    public static byte[] asBytes(UUID uuid) {
        Objects.requireNonNull(uuid, "Uuid cannot be null");
        return UInt128.asBytes(uuid.getLeastSignificantBits(), uuid.getMostSignificantBits());
    }

    public static UUID asUUID(byte[] bytes) {
        long leastSignificant = UInt128.asLong(bytes, LeastSignificant);
        long mostSignificant = UInt128.asLong(bytes, MostSignificant);
        return new UUID(mostSignificant, leastSignificant);
    }

    public static BigInteger asBigInteger(long leastSignificant, long mostSignificant) {
        if (leastSignificant == 0L && mostSignificant == 0L) {
            return BigInteger.ZERO;
        }
        BigInteger bigintMsb = BigInteger.valueOf(mostSignificant);
        BigInteger bigintLsb = BigInteger.valueOf(leastSignificant);
        if (bigintMsb.signum() < 0) {
            bigintMsb = bigintMsb.add(MOST_SIGNIFICANT_MASK);
        }
        if (bigintLsb.signum() < 0) {
            bigintLsb = bigintLsb.add(MOST_SIGNIFICANT_MASK);
        }
        return bigintLsb.add(bigintMsb.multiply(MOST_SIGNIFICANT_MASK));
    }

    public static BigInteger asBigInteger(byte[] bytes) {
        Objects.requireNonNull(bytes, "Bytes cannot be null");
        if (bytes.length != 16) {
            throw new IllegalArgumentException("Bytes must be 16 bytes long");
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(Batch.BYTE_ORDER).position(0);
        return UInt128.asBigInteger(buffer.getLong(), buffer.getLong());
    }

    public static byte[] asBytes(BigInteger value) {
        Objects.requireNonNull(value, "Value cannot be null");
        if (BigInteger.ZERO.equals(value)) {
            return new byte[16];
        }
        BigInteger[] parts = value.divideAndRemainder(MOST_SIGNIFICANT_MASK);
        BigInteger bigintMsb = parts[0];
        BigInteger bigintLsb = parts[1];
        if (LEAST_SIGNIFICANT_MASK.compareTo(bigintMsb) < 0) {
            bigintMsb = bigintMsb.subtract(MOST_SIGNIFICANT_MASK);
        }
        if (LEAST_SIGNIFICANT_MASK.compareTo(bigintLsb) < 0) {
            bigintLsb = bigintLsb.subtract(MOST_SIGNIFICANT_MASK);
        }
        return UInt128.asBytes(bigintLsb.longValueExact(), bigintMsb.longValueExact());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] id() {
        short randomHi;
        long randomLo;
        long timestamp = System.currentTimeMillis();
        SecureRandom secureRandom = idSecureRandom;
        synchronized (secureRandom) {
            if (timestamp <= idLastTimestamp) {
                timestamp = idLastTimestamp;
            } else {
                idLastTimestamp = timestamp;
                idSecureRandom.nextBytes(idLastRandom);
            }
            ByteBuffer random = ByteBuffer.wrap(idLastRandom).order(ByteOrder.nativeOrder());
            randomLo = random.getLong();
            randomHi = random.getShort();
            if (++randomLo == 0L && (randomHi = (short)(randomHi + 1)) == 0) {
                throw new ArithmeticException("Random bits overflow on monotonic increment");
            }
            random.flip();
            random.putLong(randomLo);
            random.putShort(randomHi);
        }
        ByteBuffer buffer = ByteBuffer.allocate(16).order(Batch.BYTE_ORDER);
        buffer.putLong(randomLo);
        buffer.putShort(randomHi);
        buffer.putShort((short)timestamp);
        buffer.putInt((int)(timestamp >> 16));
        return buffer.array();
    }

    static {
        MOST_SIGNIFICANT_MASK = BigInteger.ONE.shiftLeft(64);
        LEAST_SIGNIFICANT_MASK = BigInteger.valueOf(Long.MAX_VALUE);
        idLastTimestamp = 0L;
        idLastRandom = new byte[10];
        idSecureRandom = new SecureRandom();
    }
}

