/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider.internal;

import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderMethodResolver;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import com.tngtech.java.junit.dataprovider.common.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class DefaultDataProviderMethodResolver
implements DataProviderMethodResolver {
    @Override
    public List<FrameworkMethod> resolve(FrameworkMethod testMethod, UseDataProvider useDataProvider) {
        Preconditions.checkNotNull(testMethod, "testMethod must not be null");
        Preconditions.checkNotNull(useDataProvider, "useDataProvider must not be null");
        List<TestClass> dataProviderLocations = this.findDataProviderLocations(testMethod, useDataProvider.location());
        return this.findDataProviderMethods(dataProviderLocations, testMethod.getName(), useDataProvider.value());
    }

    protected List<TestClass> findDataProviderLocations(FrameworkMethod testMethod, Class<?>[] useDataProviderLocation) {
        if (useDataProviderLocation.length == 0) {
            return Collections.singletonList(new TestClass(testMethod.getMethod().getDeclaringClass()));
        }
        ArrayList<TestClass> result = new ArrayList<TestClass>();
        for (Class<?> location : useDataProviderLocation) {
            result.add(new TestClass(location));
        }
        return result;
    }

    protected List<FrameworkMethod> findDataProviderMethods(List<TestClass> locations, String testMethodName, String useDataProviderValue) {
        ArrayList<FrameworkMethod> result = new ArrayList<FrameworkMethod>();
        for (TestClass location : locations) {
            FrameworkMethod method = this.findDataProviderMethod(location, testMethodName, useDataProviderValue);
            if (method == null) continue;
            result.add(method);
        }
        return result;
    }

    protected FrameworkMethod findDataProviderMethod(TestClass location, String testMethodName, String useDataProviderValue) {
        String dataProviderMethodName;
        List dataProviderMethods = location.getAnnotatedMethods(DataProvider.class);
        if (!"<use_convention>".equals(useDataProviderValue)) {
            return this.findMethod(dataProviderMethods, useDataProviderValue);
        }
        FrameworkMethod result = this.findMethod(dataProviderMethods, testMethodName);
        if (result == null) {
            dataProviderMethodName = testMethodName.replaceAll("^test", "dataProvider");
            result = this.findMethod(dataProviderMethods, dataProviderMethodName);
        }
        if (result == null) {
            dataProviderMethodName = testMethodName.replaceAll("^test", "data");
            result = this.findMethod(dataProviderMethods, dataProviderMethodName);
        }
        if (result == null) {
            dataProviderMethodName = "dataProvider" + Character.toUpperCase(testMethodName.charAt(0)) + testMethodName.substring(1);
            result = this.findMethod(dataProviderMethods, dataProviderMethodName);
        }
        if (result == null) {
            dataProviderMethodName = "data" + Character.toUpperCase(testMethodName.charAt(0)) + testMethodName.substring(1);
            result = this.findMethod(dataProviderMethods, dataProviderMethodName);
        }
        return result;
    }

    private FrameworkMethod findMethod(List<FrameworkMethod> methods, String methodName) {
        for (FrameworkMethod method : methods) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }
}

