/*
 * Decompiled with CFR 0.152.
 */
package com.truelayer.signing;

import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.jwk.ECKey;
import com.truelayer.signing.HeaderName;
import com.truelayer.signing.KeyException;
import com.truelayer.signing.SignatureException;
import com.truelayer.signing.Utils;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.ECPrivateKey;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Signer {
    private final String kid;
    private final ECPrivateKey ecPrivateKey;
    private String path = "";
    private String method = "POST";
    private byte[] body = new byte[0];
    private final Map<HeaderName, String> headers = new LinkedHashMap<HeaderName, String>();

    private Signer(String kid, ECPrivateKey ecPrivateKey) {
        this.kid = kid;
        this.ecPrivateKey = ecPrivateKey;
    }

    public Signer method(String method) {
        if (method == null) {
            throw new IllegalArgumentException("the method must not be null");
        }
        this.method = method;
        return this;
    }

    public Signer path(String path) {
        if (path == null) {
            throw new IllegalArgumentException("the path must not be null");
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("invalid path " + path + " must start with '/'");
        }
        this.path = path;
        return this;
    }

    public Signer body(byte[] body) {
        if (body == null) {
            throw new IllegalArgumentException("the body must not be null");
        }
        this.body = body;
        return this;
    }

    public Signer body(String body) {
        if (body == null) {
            throw new IllegalArgumentException("the body must not be null");
        }
        this.body = body.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public Signer header(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("header name and value must not be null");
        }
        this.headers.put(new HeaderName(name), value);
        return this;
    }

    public Signer headers(Map<String, String> headers) {
        if (headers == null) {
            throw new IllegalArgumentException("headers must not be null");
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.headers.put(new HeaderName(entry.getKey()), entry.getValue());
        }
        return this;
    }

    public static Signer from(String kid, byte[] privateKeyPem) {
        if (kid == null || privateKeyPem == null) {
            throw new IllegalArgumentException("kid and privateKey must not be null");
        }
        ECPrivateKey privateKey = KeyException.evaluate(() -> ECKey.parseFromPEMEncodedObjects((String)new String(privateKeyPem)).toECKey().toECPrivateKey());
        return new Signer(kid, privateKey);
    }

    public static Signer from(String kid, String privateKeyPem) {
        if (kid == null || privateKeyPem == null) {
            throw new IllegalArgumentException("kid and privateKey must not be null");
        }
        ECPrivateKey privateKey = KeyException.evaluate(() -> ECKey.parseFromPEMEncodedObjects((String)privateKeyPem).toECKey().toECPrivateKey());
        return new Signer(kid, privateKey);
    }

    public static Signer from(String kid, ECPrivateKey privateKeyPem) {
        if (kid == null || privateKeyPem == null) {
            throw new IllegalArgumentException("kid and privateKey must not be null");
        }
        return new Signer(kid, privateKeyPem);
    }

    public String sign() {
        return SignatureException.evaluate(() -> {
            JWSHeader jwsHeader = JWSHeader.parse(Utils.jwsHeaderMap(this.kid, this.headers));
            JWSObject jwsObject = new JWSObject(jwsHeader, new Payload(Utils.buildPayload(this.headers, this.method, this.path, this.body)));
            jwsObject.sign((JWSSigner)new ECDSASigner(this.ecPrivateKey));
            return jwsObject.serialize(true);
        });
    }
}

