/*
 * Decompiled with CFR 0.152.
 */
package com.truelayer.signing;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWKSet;
import com.truelayer.signing.HeaderName;
import com.truelayer.signing.KeyException;
import com.truelayer.signing.SignatureException;
import com.truelayer.signing.VerifierFromJwks;
import com.truelayer.signing.VerifierFromPublicKey;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Verifier {
    protected String method = "";
    protected String path = "";
    protected byte[] body = new byte[0];
    protected final LinkedHashMap<HeaderName, String> headers = new LinkedHashMap();
    protected final HashSet<String> requiredHeaders = new HashSet();

    public static String extractJku(String tlSignature) {
        return SignatureException.evaluate(() -> {
            URI uri = JWSObject.parse((String)tlSignature).getHeader().getJWKURL();
            return uri.toString();
        });
    }

    public Verifier method(String method) {
        if (method == null) {
            throw new IllegalArgumentException("the method must not be null");
        }
        this.method = method;
        return this;
    }

    public Verifier path(String path) {
        if (path == null) {
            throw new IllegalArgumentException("the path must not be null");
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("invalid path " + path + " must start with '/'");
        }
        this.path = path;
        return this;
    }

    public Verifier body(byte[] body) {
        if (body == null) {
            throw new IllegalArgumentException("the body must not be null");
        }
        this.body = body;
        return this;
    }

    public Verifier body(String body) {
        if (body == null) {
            throw new IllegalArgumentException("the body must not be null");
        }
        this.body = body.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public Verifier headers(Map<String, String> headers) {
        if (headers == null) {
            throw new IllegalArgumentException("headers must not be null");
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.headers.put(new HeaderName(entry.getKey()), entry.getValue());
        }
        return this;
    }

    public Verifier header(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("header name and value must not be null");
        }
        this.headers.put(new HeaderName(name), value);
        return this;
    }

    public Verifier requiredHeader(String name) {
        if (name == null) {
            throw new IllegalArgumentException("the required header name must not be null");
        }
        this.requiredHeaders.add(name);
        return this;
    }

    public static Verifier from(byte[] publicKeyPem) {
        if (publicKeyPem == null) {
            throw new IllegalArgumentException("the publicKey must not be null");
        }
        ECPublicKey publicKey = KeyException.evaluate(() -> ECKey.parseFromPEMEncodedObjects((String)new String(publicKeyPem)).toECKey().toECPublicKey());
        return new VerifierFromPublicKey(publicKey);
    }

    public static Verifier from(String publicKeyPem) {
        if (publicKeyPem == null) {
            throw new IllegalArgumentException("the publicKey must not be null");
        }
        ECPublicKey publicKey = KeyException.evaluate(() -> ECKey.parseFromPEMEncodedObjects((String)publicKeyPem).toECKey().toECPublicKey());
        return new VerifierFromPublicKey(publicKey);
    }

    public static Verifier from(ECPublicKey publicKeyPem) {
        if (publicKeyPem == null) {
            throw new IllegalArgumentException("the publicKey must not be null");
        }
        return new VerifierFromPublicKey(publicKeyPem);
    }

    public static Verifier verifyWithJwks(String jwks) {
        JWKSet jwkSet = SignatureException.evaluate(() -> JWKSet.parse((String)jwks));
        return new VerifierFromJwks(jwkSet);
    }

    public abstract void verify(String var1);

    protected Map<HeaderName, String> validateSignatureHeader(JWSHeader jwsHeader) {
        List<String> validSignatureHeaders = this.validateSignatureHeaders(jwsHeader, this.requiredHeaders);
        LinkedHashMap<HeaderName, String> orderedHeaders = new LinkedHashMap<HeaderName, String>();
        validSignatureHeaders.forEach(h -> {
            String value = this.headers.get(new HeaderName((String)h));
            if (value != null) {
                orderedHeaders.put(new HeaderName((String)h), value);
            }
        });
        return orderedHeaders;
    }

    private List<String> validateSignatureHeaders(JWSHeader jwsHeader, HashSet<String> requiredHeaders) {
        SignatureException.ensure(jwsHeader.getAlgorithm().equals((Object)JWSAlgorithm.ES512), "unsupported jws alg");
        SignatureException.ensure(jwsHeader.getCustomParam("tl_version").toString().equals("2"), "unsupported jws tl_version");
        Supplier<Stream> tl_headers = () -> Arrays.stream(jwsHeader.getCustomParam("tl_headers").toString().split(",")).map(String::trim);
        Optional<String> missingRequiredHeader = requiredHeaders.stream().filter(rHeader -> ((Stream)tl_headers.get()).noneMatch(tlHeader -> tlHeader.toLowerCase().contains(rHeader.toLowerCase()))).findAny();
        SignatureException.ensure(!missingRequiredHeader.isPresent(), "missing required header: " + missingRequiredHeader.orElse(""));
        return tl_headers.get().collect(Collectors.toList());
    }
}

