/*
 * Decompiled with CFR 0.152.
 */
package com.truelayer.signing;

import com.nimbusds.jose.JOSEObject;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.util.Base64URL;
import com.truelayer.signing.HeaderName;
import com.truelayer.signing.SignatureException;
import com.truelayer.signing.Utils;
import com.truelayer.signing.Verifier;
import java.security.interfaces.ECPublicKey;
import java.util.Map;

class VerifierFromPublicKey
extends Verifier {
    private final ECPublicKey publicKey;

    protected VerifierFromPublicKey(ECPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public void verify(String signature) {
        JWSHeader jwsHeader = SignatureException.evaluate(() -> JWSHeader.parse((Base64URL)JOSEObject.split((String)signature)[0]));
        Map<HeaderName, String> orderedHeaders = this.validateSignatureHeader(jwsHeader);
        Boolean verifiedResult = SignatureException.evaluate(() -> JWSObject.parse((String)signature, (Payload)new Payload(Utils.buildPayload(orderedHeaders, this.method, this.path, this.body))).verify((JWSVerifier)new ECDSAVerifier(this.publicKey)));
        if (!verifiedResult.booleanValue()) {
            String path2 = this.path.endsWith("/") ? this.path.substring(0, this.path.length() - 1) : this.path + "/";
            verifiedResult = SignatureException.evaluate(() -> JWSObject.parse((String)signature, (Payload)new Payload(Utils.buildPayload(orderedHeaders, this.method, path2, this.body))).verify((JWSVerifier)new ECDSAVerifier(this.publicKey)));
        }
        SignatureException.ensure(verifiedResult, "invalid signature");
    }
}

