/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.MapContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class HadoopCompat {
    private static final boolean useV21;
    private static final Constructor<?> JOB_CONTEXT_CONSTRUCTOR;
    private static final Constructor<?> TASK_CONTEXT_CONSTRUCTOR;
    private static final Constructor<?> MAP_CONTEXT_CONSTRUCTOR;
    private static final Constructor<?> GENERIC_COUNTER_CONSTRUCTOR;
    private static final Field READER_FIELD;
    private static final Field WRITER_FIELD;
    private static final Method GET_CONFIGURATION_METHOD;
    private static final Method SET_STATUS_METHOD;
    private static final Method GET_COUNTER_METHOD;
    private static final Method GET_COUNTER_ENUM_METHOD;
    private static final Method INCREMENT_COUNTER_METHOD;
    private static final Method GET_COUNTER_VALUE_METHOD;
    private static final Method GET_TASK_ATTEMPT_ID;
    private static final Method GET_JOB_ID_METHOD;
    private static final Method GET_JOB_NAME_METHOD;
    private static final Method GET_INPUT_SPLIT_METHOD;
    private static final Method GET_DEFAULT_BLOCK_SIZE_METHOD;
    private static final Method GET_DEFAULT_REPLICATION_METHOD;

    public static boolean isVersion2x() {
        return useV21;
    }

    private static Object newInstance(Constructor<?> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Can't instantiate " + constructor, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't instantiate " + constructor, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Can't instantiate " + constructor, e);
        }
    }

    public static JobContext newJobContext(Configuration conf, JobID jobId) {
        return (JobContext)HadoopCompat.newInstance(JOB_CONTEXT_CONSTRUCTOR, conf, jobId);
    }

    public static TaskAttemptContext newTaskAttemptContext(Configuration conf, TaskAttemptID taskAttemptId) {
        return (TaskAttemptContext)HadoopCompat.newInstance(TASK_CONTEXT_CONSTRUCTOR, conf, taskAttemptId);
    }

    public static MapContext newMapContext(Configuration conf, TaskAttemptID taskAttemptID, RecordReader recordReader, RecordWriter recordWriter, OutputCommitter outputCommitter, StatusReporter statusReporter, InputSplit inputSplit) {
        return (MapContext)HadoopCompat.newInstance(MAP_CONTEXT_CONSTRUCTOR, conf, taskAttemptID, recordReader, recordWriter, outputCommitter, statusReporter, inputSplit);
    }

    public static Counter newGenericCounter(String name, String displayName, long value) {
        try {
            return (Counter)GENERIC_COUNTER_CONSTRUCTOR.newInstance(name, displayName, value);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Can't instantiate Counter", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't instantiate Counter", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Can't instantiate Counter", e);
        }
    }

    private static Object invoke(Method method, Object obj, Object ... args) {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't invoke method " + method.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Can't invoke method " + method.getName(), e);
        }
    }

    public static Configuration getConfiguration(JobContext context) {
        return (Configuration)HadoopCompat.invoke(GET_CONFIGURATION_METHOD, context, new Object[0]);
    }

    public static void setStatus(TaskAttemptContext context, String status) {
        HadoopCompat.invoke(SET_STATUS_METHOD, context, status);
    }

    public static TaskAttemptID getTaskAttemptID(TaskAttemptContext taskContext) {
        return (TaskAttemptID)HadoopCompat.invoke(GET_TASK_ATTEMPT_ID, taskContext, new Object[0]);
    }

    public static Counter getCounter(TaskInputOutputContext context, String groupName, String counterName) {
        return (Counter)HadoopCompat.invoke(GET_COUNTER_METHOD, context, groupName, counterName);
    }

    public static void progress(TaskAttemptContext context) {
        context.progress();
    }

    public static Counter getCounter(TaskInputOutputContext context, Enum<?> key) {
        return (Counter)HadoopCompat.invoke(GET_COUNTER_ENUM_METHOD, context, key);
    }

    public static void incrementCounter(Counter counter, long increment) {
        HadoopCompat.invoke(INCREMENT_COUNTER_METHOD, counter, increment);
    }

    public static long getCounterValue(Counter counter) {
        return (Long)HadoopCompat.invoke(GET_COUNTER_VALUE_METHOD, counter, new Object[0]);
    }

    public static JobID getJobID(JobContext jobContext) {
        return (JobID)HadoopCompat.invoke(GET_JOB_ID_METHOD, jobContext, new Object[0]);
    }

    public static String getJobName(JobContext jobContext) {
        return (String)HadoopCompat.invoke(GET_JOB_NAME_METHOD, jobContext, new Object[0]);
    }

    public static InputSplit getInputSplit(MapContext mapContext) {
        return (InputSplit)HadoopCompat.invoke(GET_INPUT_SPLIT_METHOD, mapContext, new Object[0]);
    }

    public static long getDefaultBlockSize(FileSystem fs, Path path) {
        return (Long)(HadoopCompat.isVersion2x() ? HadoopCompat.invoke(GET_DEFAULT_BLOCK_SIZE_METHOD, fs, path) : HadoopCompat.invoke(GET_DEFAULT_BLOCK_SIZE_METHOD, fs, new Object[0]));
    }

    public static short getDefaultReplication(FileSystem fs, Path path) {
        return (Short)(HadoopCompat.isVersion2x() ? HadoopCompat.invoke(GET_DEFAULT_REPLICATION_METHOD, fs, path) : HadoopCompat.invoke(GET_DEFAULT_REPLICATION_METHOD, fs, new Object[0]));
    }

    static {
        Class<?> genericCounterCls;
        Class<?> mapContextCls;
        Class<?> taskIOContextCls;
        Class<?> taskContextCls;
        Class<?> jobContextCls;
        boolean v21 = true;
        String PACKAGE = "org.apache.hadoop.mapreduce";
        try {
            Class.forName("org.apache.hadoop.mapreduce.task.JobContextImpl");
        }
        catch (ClassNotFoundException cnfe) {
            v21 = false;
        }
        useV21 = v21;
        try {
            if (v21) {
                jobContextCls = Class.forName("org.apache.hadoop.mapreduce.task.JobContextImpl");
                taskContextCls = Class.forName("org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl");
                taskIOContextCls = Class.forName("org.apache.hadoop.mapreduce.task.TaskInputOutputContextImpl");
                mapContextCls = Class.forName("org.apache.hadoop.mapreduce.task.MapContextImpl");
                genericCounterCls = Class.forName("org.apache.hadoop.mapreduce.counters.GenericCounter");
            } else {
                jobContextCls = Class.forName("org.apache.hadoop.mapreduce.JobContext");
                taskContextCls = Class.forName("org.apache.hadoop.mapreduce.TaskAttemptContext");
                taskIOContextCls = Class.forName("org.apache.hadoop.mapreduce.TaskInputOutputContext");
                mapContextCls = Class.forName("org.apache.hadoop.mapreduce.MapContext");
                genericCounterCls = Class.forName("org.apache.hadoop.mapred.Counters$Counter");
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Can't find class", e);
        }
        try {
            JOB_CONTEXT_CONSTRUCTOR = jobContextCls.getConstructor(Configuration.class, JobID.class);
            JOB_CONTEXT_CONSTRUCTOR.setAccessible(true);
            TASK_CONTEXT_CONSTRUCTOR = taskContextCls.getConstructor(Configuration.class, TaskAttemptID.class);
            TASK_CONTEXT_CONSTRUCTOR.setAccessible(true);
            GENERIC_COUNTER_CONSTRUCTOR = genericCounterCls.getDeclaredConstructor(String.class, String.class, Long.TYPE);
            GENERIC_COUNTER_CONSTRUCTOR.setAccessible(true);
            if (useV21) {
                Method get_counter;
                MAP_CONTEXT_CONSTRUCTOR = mapContextCls.getDeclaredConstructor(Configuration.class, TaskAttemptID.class, RecordReader.class, RecordWriter.class, OutputCommitter.class, StatusReporter.class, InputSplit.class);
                try {
                    get_counter = TaskAttemptContext.class.getMethod("getCounter", String.class, String.class);
                }
                catch (Exception e) {
                    get_counter = TaskInputOutputContext.class.getMethod("getCounter", String.class, String.class);
                }
                GET_COUNTER_METHOD = get_counter;
                GET_COUNTER_ENUM_METHOD = TaskAttemptContext.class.getMethod("getCounter", Enum.class);
                GET_DEFAULT_BLOCK_SIZE_METHOD = FileSystem.class.getMethod("getDefaultBlockSize", Path.class);
                GET_DEFAULT_REPLICATION_METHOD = FileSystem.class.getMethod("getDefaultReplication", Path.class);
            } else {
                MAP_CONTEXT_CONSTRUCTOR = mapContextCls.getConstructor(Configuration.class, TaskAttemptID.class, RecordReader.class, RecordWriter.class, OutputCommitter.class, StatusReporter.class, InputSplit.class);
                GET_COUNTER_METHOD = TaskInputOutputContext.class.getMethod("getCounter", String.class, String.class);
                GET_COUNTER_ENUM_METHOD = TaskInputOutputContext.class.getMethod("getCounter", Enum.class);
                GET_DEFAULT_BLOCK_SIZE_METHOD = FileSystem.class.getMethod("getDefaultBlockSize", new Class[0]);
                GET_DEFAULT_REPLICATION_METHOD = FileSystem.class.getMethod("getDefaultReplication", new Class[0]);
            }
            MAP_CONTEXT_CONSTRUCTOR.setAccessible(true);
            READER_FIELD = mapContextCls.getDeclaredField("reader");
            READER_FIELD.setAccessible(true);
            WRITER_FIELD = taskIOContextCls.getDeclaredField("output");
            WRITER_FIELD.setAccessible(true);
            GET_CONFIGURATION_METHOD = JobContext.class.getMethod("getConfiguration", new Class[0]);
            SET_STATUS_METHOD = TaskAttemptContext.class.getMethod("setStatus", String.class);
            GET_TASK_ATTEMPT_ID = TaskAttemptContext.class.getMethod("getTaskAttemptID", new Class[0]);
            INCREMENT_COUNTER_METHOD = Counter.class.getMethod("increment", Long.TYPE);
            GET_COUNTER_VALUE_METHOD = Counter.class.getMethod("getValue", new Class[0]);
            GET_JOB_ID_METHOD = JobContext.class.getMethod("getJobID", new Class[0]);
            GET_JOB_NAME_METHOD = JobContext.class.getMethod("getJobName", new Class[0]);
            GET_INPUT_SPLIT_METHOD = MapContext.class.getMethod("getInputSplit", new Class[0]);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Can't run constructor ", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Can't find constructor ", e);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Can't find field ", e);
        }
    }
}

