/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.collect.Lists;
import com.twitter.elephantbird.pig.store.SequenceFileStorage;
import com.twitter.elephantbird.pig.util.TextConverter;
import com.twitter.elephantbird.pig.util.WritableConverter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.io.Writable;
import org.apache.pig.impl.PigContext;

public class SequenceFileConfig<K extends Writable, V extends Writable> {
    public static final String CONVERTER_PARAM = "converter";
    public final CommandLine keyArguments;
    public final CommandLine valueArguments;
    public final CommandLine genericArguments;
    public final WritableConverter<K> keyConverter;
    public final WritableConverter<V> valueConverter;

    public SequenceFileConfig(String keyArgs, String valueArgs, String genericArgs) throws ParseException, IOException {
        Options keyValueOptions = this.getKeyValueOptions();
        Options genericOptions = this.getGenericOptions();
        this.keyArguments = SequenceFileConfig.parseArguments(keyValueOptions, keyArgs);
        this.valueArguments = SequenceFileConfig.parseArguments(keyValueOptions, valueArgs);
        this.genericArguments = SequenceFileConfig.parseArguments(genericOptions, genericArgs);
        this.keyConverter = SequenceFileConfig.getWritableConverter(this.keyArguments);
        this.valueConverter = SequenceFileConfig.getWritableConverter(this.valueArguments);
        this.initialize();
    }

    public SequenceFileConfig(String keyArgs, String valueArgs) throws ParseException, IOException {
        this(keyArgs, valueArgs, "");
    }

    public SequenceFileConfig() throws ParseException, IOException {
        this("", "");
    }

    protected Options getKeyValueOptions() {
        OptionBuilder.withLongOpt((String)CONVERTER_PARAM);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"cls");
        OptionBuilder.withDescription((String)String.format("Converter type to use for conversion of data. Defaults to '%s'.", TextConverter.class.getName()));
        Option converterOption = OptionBuilder.create((String)"c");
        return new Options().addOption(converterOption);
    }

    protected Options getGenericOptions() {
        return new Options();
    }

    private static CommandLine parseArguments(Options options, String args) throws ParseException {
        CommandLine cmdline = null;
        try {
            cmdline = new GnuParser().parse(options, args.split(" "));
        }
        catch (ParseException e) {
            new HelpFormatter().printHelp(SequenceFileStorage.class.getName() + "(keyArgs, valueArgs)", options);
            throw e;
        }
        return cmdline;
    }

    private static <T extends Writable> WritableConverter<T> getWritableConverter(CommandLine arguments) {
        String[] converterArgs = SequenceFileConfig.removeEmptyArgs(arguments.getArgs());
        try {
            String converterClassName = arguments.getOptionValue(CONVERTER_PARAM, TextConverter.class.getName());
            Class converterClass = PigContext.resolveClassName((String)converterClassName);
            if (converterArgs == null || converterArgs.length == 0) {
                return (WritableConverter)converterClass.newInstance();
            }
            try {
                Object[] parameterTypes = new Class[converterArgs.length];
                Arrays.fill(parameterTypes, String.class);
                Constructor ctor = converterClass.getConstructor((Class<?>[])parameterTypes);
                return (WritableConverter)ctor.newInstance(converterArgs);
            }
            catch (NoSuchMethodException e) {
                try {
                    Constructor ctor = converterClass.getConstructor(String[].class);
                    return (WritableConverter)ctor.newInstance(new Object[]{converterArgs});
                }
                catch (NoSuchMethodException e2) {
                    Constructor ctor = converterClass.getConstructor(String.class);
                    StringBuilder sb = new StringBuilder(converterArgs[0]);
                    for (int i = 1; i < converterArgs.length; ++i) {
                        sb.append(" ").append(converterArgs[i]);
                    }
                    return (WritableConverter)ctor.newInstance(sb.toString());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create WritableConverter instance", e);
        }
    }

    private static String[] removeEmptyArgs(String[] args) {
        ArrayList converterArgsFiltered = Lists.newArrayList();
        for (String arg : args) {
            if (arg == null || arg.isEmpty()) continue;
            converterArgsFiltered.add(arg);
        }
        return converterArgsFiltered.toArray(new String[0]);
    }

    protected void initialize() throws IOException {
        this.keyConverter.initialize(null);
        this.valueConverter.initialize(null);
    }
}

