/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.store;

import com.twitter.elephantbird.mapreduce.io.ThriftWritable;
import com.twitter.elephantbird.mapreduce.output.LzoThriftB64LineOutputFormat;
import com.twitter.elephantbird.pig.store.BaseStoreFunc;
import com.twitter.elephantbird.pig.util.PigToThrift;
import com.twitter.elephantbird.pig.util.PigUtil;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.pig.data.Tuple;
import org.apache.thrift.TBase;

public class LzoThriftB64LinePigStorage<T extends TBase<?, ?>>
extends BaseStoreFunc {
    private TypeRef<T> typeRef;
    private ThriftWritable<T> writable;
    private PigToThrift<T> pigToThrift;

    public LzoThriftB64LinePigStorage(String thriftClassName) {
        this.typeRef = PigUtil.getThriftTypeRef(thriftClassName);
        this.writable = ThriftWritable.newInstance((Class)this.typeRef.getRawClass());
        this.pigToThrift = PigToThrift.newInstance(this.typeRef);
    }

    public void putNext(Tuple f) throws IOException {
        if (f == null) {
            return;
        }
        try {
            this.writable.set(this.pigToThrift.getThriftObject(f));
            this.writer.write(null, this.writable);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public OutputFormat<T, ThriftWritable<T>> getOutputFormat() throws IOException {
        return new LzoThriftB64LineOutputFormat(this.typeRef);
    }
}

