/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.elephantbird.util.Protobufs;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PigToProtobuf {
    private static final Logger LOG = LoggerFactory.getLogger(PigToProtobuf.class);

    public static <M extends Message> M tupleToMessage(Class<M> protoClass, Tuple tuple) {
        Message.Builder builder = Protobufs.getMessageBuilder(protoClass);
        return (M)PigToProtobuf.tupleToMessage(builder, tuple);
    }

    public static Message tupleToMessage(Message.Builder builder, Tuple tuple) {
        return PigToProtobuf.tupleToMessage(builder, builder.getDescriptorForType().getFields(), tuple);
    }

    public static Message tupleToMessage(Message.Builder builder, List<Descriptors.FieldDescriptor> fieldDescriptors, Tuple tuple) {
        if (tuple == null) {
            return builder.build();
        }
        for (int i = 0; i < fieldDescriptors.size() && i < tuple.size(); ++i) {
            Object tupleField = null;
            Descriptors.FieldDescriptor fieldDescriptor = fieldDescriptors.get(i);
            try {
                tupleField = tuple.get(i);
            }
            catch (ExecException e) {
                LOG.warn("Could not convert tuple field " + tupleField + " to field with descriptor " + fieldDescriptor);
                continue;
            }
            if (tupleField == null) continue;
            try {
                if (fieldDescriptor.isRepeated()) {
                    builder.setField(fieldDescriptor, PigToProtobuf.dataBagToRepeatedField(builder, fieldDescriptor, (DataBag)tupleField));
                    continue;
                }
                if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                    Message.Builder nestedMessageBuilder = builder.newBuilderForField(fieldDescriptor);
                    builder.setField(fieldDescriptor, (Object)PigToProtobuf.tupleToMessage(nestedMessageBuilder, (Tuple)tupleField));
                    continue;
                }
                builder.setField(fieldDescriptor, PigToProtobuf.tupleFieldToSingleField(fieldDescriptor, tupleField));
                continue;
            }
            catch (Exception e) {
                String value = String.valueOf(tupleField);
                int max_length = 100;
                if (100 < value.length()) {
                    value = value.substring(0, 97) + "...";
                }
                String type = tupleField == null ? "unknown" : tupleField.getClass().getName();
                throw new RuntimeException(String.format("Failed to set field '%s' using tuple value '%s' of type '%s' at index %d", fieldDescriptor.getName(), value, type, i), e);
            }
        }
        return builder.build();
    }

    public static Descriptors.Descriptor schemaToProtoDescriptor(ResourceSchema schema) throws Descriptors.DescriptorValidationException {
        return PigToProtobuf.schemaToProtoDescriptor(schema, null);
    }

    public static Descriptors.Descriptor schemaToProtoDescriptor(ResourceSchema schema, List<Pair<String, DescriptorProtos.FieldDescriptorProto.Type>> extraFields) throws Descriptors.DescriptorValidationException {
        DescriptorProtos.DescriptorProto.Builder desBuilder = DescriptorProtos.DescriptorProto.newBuilder();
        int count = 0;
        for (ResourceSchema.ResourceFieldSchema fieldSchema : schema.getFields()) {
            int position = ++count;
            String fieldName = fieldSchema.getName();
            byte dataTypeId = fieldSchema.getType();
            DescriptorProtos.FieldDescriptorProto.Type protoType = PigToProtobuf.pigTypeToProtoType(dataTypeId);
            LOG.info("Mapping Pig field " + fieldName + " of type " + dataTypeId + " to protobuf type: " + protoType);
            PigToProtobuf.addField(desBuilder, fieldName, position, protoType);
        }
        if (count == 0) {
            throw new IllegalArgumentException("ResourceSchema does not have any fields");
        }
        if (extraFields != null) {
            for (Pair<String, DescriptorProtos.FieldDescriptorProto.Type> extraField : extraFields) {
                PigToProtobuf.addField(desBuilder, (String)extraField.first, ++count, (DescriptorProtos.FieldDescriptorProto.Type)extraField.second);
            }
        }
        desBuilder.setName("PigToProtobufDynamicBuilder");
        return Protobufs.makeMessageDescriptor((DescriptorProtos.DescriptorProto)desBuilder.build());
    }

    private static List<Object> dataBagToRepeatedField(Message.Builder containingMessageBuilder, Descriptors.FieldDescriptor fieldDescriptor, DataBag bag) {
        ArrayList<Object> bagContents = new ArrayList<Object>((int)bag.size());
        for (Tuple tuple : bag) {
            if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                Message.Builder nestedMessageBuilder = containingMessageBuilder.newBuilderForField(fieldDescriptor);
                bagContents.add(PigToProtobuf.tupleToMessage(nestedMessageBuilder, tuple));
                continue;
            }
            try {
                bagContents.add(PigToProtobuf.tupleFieldToSingleField(fieldDescriptor, tuple.get(0)));
            }
            catch (ExecException e) {
                LOG.warn("Could not add a value for repeated field with descriptor " + fieldDescriptor);
            }
        }
        return bagContents;
    }

    private static Object tupleFieldToSingleField(Descriptors.FieldDescriptor fieldDescriptor, Object tupleField) {
        switch (fieldDescriptor.getType()) {
            case ENUM: {
                return PigToProtobuf.toEnumValueDescriptor(fieldDescriptor, (String)tupleField);
            }
            case BOOL: {
                return (Integer)tupleField != 0;
            }
            case BYTES: {
                return ByteString.copyFrom((byte[])((DataByteArray)tupleField).get());
            }
        }
        return tupleField;
    }

    private static Descriptors.EnumValueDescriptor toEnumValueDescriptor(Descriptors.FieldDescriptor fieldDescriptor, String name) {
        Descriptors.EnumValueDescriptor out = fieldDescriptor.getEnumType().findValueByName(name);
        if (out == null) {
            throw new IllegalArgumentException(String.format("Failed to convert string '%s' to enum value of type '%s'", name, fieldDescriptor.getEnumType().getFullName()));
        }
        return out;
    }

    private static void addField(DescriptorProtos.DescriptorProto.Builder builder, String name, int fieldId, DescriptorProtos.FieldDescriptorProto.Type type) {
        DescriptorProtos.FieldDescriptorProto.Builder fdBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder().setName(name).setNumber(fieldId).setType(type);
        builder.addField(fdBuilder.build());
    }

    private static DescriptorProtos.FieldDescriptorProto.Type pigTypeToProtoType(byte pigTypeId) {
        switch (pigTypeId) {
            case 5: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL;
            }
            case 10: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32;
            }
            case 15: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64;
            }
            case 20: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT;
            }
            case 25: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE;
            }
            case 55: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING;
            }
            case 50: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES;
            }
        }
        throw new IllegalArgumentException("Unsupported Pig type passed (" + pigTypeId + ") where a simple type is expected while converting Pig to a dynamic Protobuf");
    }
}

