/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.input.RCFileProtobufInputFormat;
import com.twitter.elephantbird.pig.util.ProtobufToPig;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class RCFileProtobufTupleInputFormat
extends RCFileProtobufInputFormat {
    public RCFileProtobufTupleInputFormat() {
    }

    public RCFileProtobufTupleInputFormat(TypeRef<Message> typeRef) {
        super(typeRef);
    }

    @Override
    public RecordReader<LongWritable, Writable> createRecordReader(InputSplit split, TaskAttemptContext taskAttempt) throws IOException, InterruptedException {
        return new TupleReader(this.createUnwrappedRecordReader(split, taskAttempt));
    }

    public class TupleReader
    extends RCFileProtobufInputFormat.ProtobufReader {
        private final TupleFactory tf;
        private final ProtobufToPig protoToPig;

        public TupleReader(RecordReader reader) {
            super(reader);
            this.tf = TupleFactory.getInstance();
            this.protoToPig = new ProtobufToPig();
        }

        public Tuple getCurrentTupleValue() throws IOException, InterruptedException {
            BytesRefArrayWritable byteRefs = this.getCurrentBytesRefArrayWritable();
            if (byteRefs == null) {
                return null;
            }
            Tuple tuple = this.tf.newTuple(this.knownRequiredFields.size());
            for (int i = 0; i < this.knownRequiredFields.size(); ++i) {
                BytesRefWritable buf = byteRefs.get(((Integer)this.columnsBeingRead.get(i)).intValue());
                Descriptors.FieldDescriptor fd = (Descriptors.FieldDescriptor)this.knownRequiredFields.get(i);
                Object value = null;
                value = buf.getLength() > 0 ? Protobufs.readFieldNoTag((CodedInputStream)CodedInputStream.newInstance((byte[])buf.getData(), (int)buf.getStart(), (int)buf.getLength()), (Descriptors.FieldDescriptor)((Descriptors.FieldDescriptor)this.knownRequiredFields.get(i)), (Message.Builder)this.msgBuilder) : this.msgInstance.getField(fd);
                tuple.set(i, this.protoToPig.fieldToPig(fd, value));
            }
            if (this.isReadingUnknonwsColumn()) {
                throw new IOException("getCurrentTupleValue() is not supported when 'readUnknownColumns' is set");
            }
            return tuple;
        }
    }
}

