/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.twitter.elephantbird.mapreduce.input.RCFileThriftInputFormat;
import com.twitter.elephantbird.pig.util.ThriftToPig;
import com.twitter.elephantbird.thrift.TStructDescriptor;
import com.twitter.elephantbird.util.ThriftUtils;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class RCFileThriftTupleInputFormat
extends RCFileThriftInputFormat {
    public RCFileThriftTupleInputFormat() {
    }

    public RCFileThriftTupleInputFormat(TypeRef<TBase<?, ?>> typeRef) {
        super(typeRef);
    }

    @Override
    public RecordReader<LongWritable, Writable> createRecordReader(InputSplit split, TaskAttemptContext taskAttempt) throws IOException, InterruptedException {
        return new TupleReader(this.createUnwrappedRecordReader(split, taskAttempt));
    }

    public class TupleReader
    extends RCFileThriftInputFormat.ThriftReader {
        private final TupleFactory tf;

        public TupleReader(RecordReader reader) {
            super(reader);
            this.tf = TupleFactory.getInstance();
        }

        public Tuple getCurrentTupleValue() throws IOException, InterruptedException, TException {
            BytesRefArrayWritable byteRefs = this.getCurrentBytesRefArrayWritable();
            if (byteRefs == null) {
                return null;
            }
            Tuple tuple = this.tf.newTuple(this.knownRequiredFields.size());
            for (int i = 0; i < this.knownRequiredFields.size(); ++i) {
                BytesRefWritable buf = byteRefs.get(((Integer)this.columnsBeingRead.get(i)).intValue());
                if (buf.getLength() <= 0) continue;
                this.memTransport.reset(buf.getData(), buf.getStart(), buf.getLength());
                TStructDescriptor.Field field = (TStructDescriptor.Field)this.knownRequiredFields.get(i);
                Object value = ThriftUtils.readFieldNoTag((TProtocol)this.tProto, (TStructDescriptor.Field)field);
                tuple.set(i, ThriftToPig.toPigObject((TStructDescriptor.Field)field, (Object)value, (boolean)false));
            }
            if (this.isReadingUnknonwsColumn()) {
                throw new IOException("getCurrentTupleValue() is not supported when 'readUnknownColumns' is set");
            }
            return tuple;
        }
    }
}

