/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.output;

import com.twitter.elephantbird.util.HadoopCompat;
import com.twitter.elephantbird.util.RCFileUtil;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RCFileOutputFormat
extends FileOutputFormat<NullWritable, Writable> {
    private static final Logger LOG = LoggerFactory.getLogger(RCFileOutputFormat.class);
    public static String COMPRESSION_CODEC_CONF = "elephantbird.rcfile.output.compression.codec";
    public static String DEFAULT_EXTENSION = ".rc";
    public static String EXTENSION_OVERRIDE_CONF = "elephantbird.refile.output.filename.extension";

    public static void setColumnNumber(Configuration conf, int columnNum) {
        assert (columnNum > 0);
        conf.setInt("hive.io.rcfile.column.number.conf", columnNum);
    }

    public static int getColumnNumber(Configuration conf) {
        return conf.getInt("hive.io.rcfile.column.number.conf", 0);
    }

    protected RCFile.Writer createRCFileWriter(TaskAttemptContext job, Text columnMetadata) throws IOException {
        String ext;
        Configuration conf = HadoopCompat.getConfiguration((JobContext)job);
        String codecOverride = conf.get(COMPRESSION_CODEC_CONF);
        if (codecOverride != null) {
            conf.setBoolean("mapred.output.compress", true);
            conf.set("mapred.output.compression.codec", codecOverride);
        }
        CompressionCodec codec = null;
        if (RCFileOutputFormat.getCompressOutput((JobContext)job)) {
            Class codecClass = RCFileOutputFormat.getOutputCompressorClass((JobContext)job, GzipCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
        }
        SequenceFile.Metadata metadata = null;
        if (columnMetadata != null) {
            metadata = new SequenceFile.Metadata();
            metadata.set(new Text(RCFileUtil.COLUMN_METADATA_PROTOBUF_KEY), columnMetadata);
        }
        Path file = this.getDefaultWorkFile(job, (ext = conf.get(EXTENSION_OVERRIDE_CONF, DEFAULT_EXTENSION)).equalsIgnoreCase("none") ? null : ext);
        LOG.info("writing to rcfile " + file.toString());
        return new RCFile.Writer(file.getFileSystem(conf), conf, file, (Progressable)job, metadata, codec);
    }

    public RecordWriter<NullWritable, Writable> getRecordWriter(TaskAttemptContext job) throws IOException, InterruptedException {
        return new Writer(this, job, null);
    }

    protected static class Writer
    extends RecordWriter<NullWritable, Writable> {
        private RCFile.Writer rcfile;

        protected Writer(RCFileOutputFormat outputFormat, TaskAttemptContext job, Text columnMetadata) throws IOException {
            this.rcfile = outputFormat.createRCFileWriter(job, columnMetadata);
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.rcfile.close();
        }

        public void write(NullWritable key, Writable value) throws IOException, InterruptedException {
            this.rcfile.append(value);
        }
    }
}

