/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.output;

import com.google.common.collect.Lists;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.io.ProtobufWritable;
import com.twitter.elephantbird.mapreduce.output.RCFileOutputFormat;
import com.twitter.elephantbird.util.ColumnarMetadata;
import com.twitter.elephantbird.util.HadoopCompat;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class RCFileProtobufOutputFormat
extends RCFileOutputFormat {
    private TypeRef<? extends Message> typeRef;
    private List<Descriptors.FieldDescriptor> msgFields;
    private int numColumns;
    private BytesRefArrayWritable rowWritable = new BytesRefArrayWritable();
    private BytesRefWritable[] colValRefs;
    private ByteStream.Output byteStream = new ByteStream.Output();
    private CodedOutputStream protoStream = CodedOutputStream.newInstance((OutputStream)this.byteStream);

    public RCFileProtobufOutputFormat() {
    }

    public RCFileProtobufOutputFormat(TypeRef<? extends Message> typeRef) {
        this.typeRef = typeRef;
        this.init();
    }

    private void init() {
        Message.Builder msgBuilder = Protobufs.getMessageBuilder((Class)this.typeRef.getRawClass());
        this.msgFields = msgBuilder.getDescriptorForType().getFields();
        this.numColumns = this.msgFields.size() + 1;
        this.colValRefs = new BytesRefWritable[this.numColumns];
        for (int i = 0; i < this.numColumns; ++i) {
            this.colValRefs[i] = new BytesRefWritable();
            this.rowWritable.set(i, this.colValRefs[i]);
        }
    }

    protected ColumnarMetadata makeColumnarMetadata() {
        ArrayList fieldIds = Lists.newArrayList();
        for (Descriptors.FieldDescriptor fd : this.msgFields) {
            fieldIds.add(fd.getNumber());
        }
        fieldIds.add(-1);
        return ColumnarMetadata.newInstance(this.typeRef.getRawClass().getName(), fieldIds);
    }

    public static void setClassConf(Class<? extends Message> protoClass, Configuration conf) {
        Protobufs.setClassConf((Configuration)conf, RCFileProtobufOutputFormat.class, protoClass);
    }

    @Override
    public RecordWriter<NullWritable, Writable> getRecordWriter(TaskAttemptContext job) throws IOException, InterruptedException {
        if (this.typeRef == null) {
            this.typeRef = Protobufs.getTypeRef((Configuration)HadoopCompat.getConfiguration((JobContext)job), RCFileProtobufOutputFormat.class);
            this.init();
        }
        RCFileOutputFormat.setColumnNumber(HadoopCompat.getConfiguration((JobContext)job), this.numColumns);
        return new ProtobufWriter(job);
    }

    private class ProtobufWriter
    extends RCFileOutputFormat.Writer {
        ProtobufWriter(TaskAttemptContext job) throws IOException {
            super(RCFileProtobufOutputFormat.this, job, Protobufs.toText((Message)RCFileProtobufOutputFormat.this.makeColumnarMetadata().getMessage()));
        }

        @Override
        public void write(NullWritable key, Writable value) throws IOException, InterruptedException {
            Message msg = (Message)((ProtobufWritable)value).get();
            RCFileProtobufOutputFormat.this.protoStream.flush();
            RCFileProtobufOutputFormat.this.byteStream.reset();
            int startPos = 0;
            for (int i = 0; i < RCFileProtobufOutputFormat.this.numColumns; ++i) {
                if (i < RCFileProtobufOutputFormat.this.numColumns - 1) {
                    Descriptors.FieldDescriptor fd = (Descriptors.FieldDescriptor)RCFileProtobufOutputFormat.this.msgFields.get(i);
                    if (fd.isRepeated() || msg.hasField(fd)) {
                        Protobufs.writeFieldNoTag((CodedOutputStream)RCFileProtobufOutputFormat.this.protoStream, (Descriptors.FieldDescriptor)fd, (Object)msg.getField(fd));
                    }
                } else {
                    msg.getUnknownFields().writeTo(RCFileProtobufOutputFormat.this.protoStream);
                }
                RCFileProtobufOutputFormat.this.protoStream.flush();
                RCFileProtobufOutputFormat.this.colValRefs[i].set(RCFileProtobufOutputFormat.this.byteStream.getData(), startPos, RCFileProtobufOutputFormat.this.byteStream.getCount() - startPos);
                startPos = RCFileProtobufOutputFormat.this.byteStream.getCount();
            }
            super.write(null, (Writable)RCFileProtobufOutputFormat.this.rowWritable);
        }
    }
}

