/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.statistics;

import java.util.Arrays;
import parquet.column.UnknownColumnTypeException;
import parquet.column.statistics.BinaryStatistics;
import parquet.column.statistics.BooleanStatistics;
import parquet.column.statistics.DoubleStatistics;
import parquet.column.statistics.FloatStatistics;
import parquet.column.statistics.IntStatistics;
import parquet.column.statistics.LongStatistics;
import parquet.column.statistics.StatisticsClassException;
import parquet.io.api.Binary;
import parquet.schema.PrimitiveType;

public abstract class Statistics {
    private boolean firstValueAccountedFor = false;
    private long num_nulls = 0L;

    public static Statistics getStatsBasedOnType(PrimitiveType.PrimitiveTypeName type) {
        switch (type) {
            case INT32: {
                return new IntStatistics();
            }
            case INT64: {
                return new LongStatistics();
            }
            case FLOAT: {
                return new FloatStatistics();
            }
            case DOUBLE: {
                return new DoubleStatistics();
            }
            case BOOLEAN: {
                return new BooleanStatistics();
            }
            case BINARY: {
                return new BinaryStatistics();
            }
            case INT96: {
                return new BinaryStatistics();
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return new BinaryStatistics();
            }
        }
        throw new UnknownColumnTypeException(type);
    }

    public void updateStats(int value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(long value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(float value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(double value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(boolean value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(Binary value) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Statistics stats) {
        return Arrays.equals(stats.getMaxBytes(), this.getMaxBytes()) && Arrays.equals(stats.getMinBytes(), this.getMinBytes()) && stats.getNumNulls() == this.getNumNulls();
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.getMaxBytes()) + 17 * Arrays.hashCode(this.getMinBytes()) + Long.valueOf(this.getNumNulls()).hashCode();
    }

    public void mergeStatistics(Statistics stats) {
        if (stats.isEmpty()) {
            return;
        }
        if (this.getClass() != stats.getClass()) {
            throw new StatisticsClassException(this.getClass().toString(), stats.getClass().toString());
        }
        this.incrementNumNulls(stats.getNumNulls());
        this.mergeStatisticsMinMax(stats);
    }

    protected abstract void mergeStatisticsMinMax(Statistics var1);

    public abstract void setMinMaxFromBytes(byte[] var1, byte[] var2);

    public abstract byte[] getMaxBytes();

    public abstract byte[] getMinBytes();

    public abstract String toString();

    public void incrementNumNulls() {
        ++this.num_nulls;
    }

    public void incrementNumNulls(long increment) {
        this.num_nulls += increment;
    }

    public long getNumNulls() {
        return this.num_nulls;
    }

    public void setNumNulls(long nulls) {
        this.num_nulls = nulls;
    }

    public boolean isEmpty() {
        return !this.firstValueAccountedFor;
    }

    protected void markAsNotEmpty() {
        this.firstValueAccountedFor = true;
    }
}

