/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.api;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import parquet.hadoop.api.InitContext;
import parquet.io.api.RecordMaterializer;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;
import parquet.schema.Type;

public abstract class ReadSupport<T> {
    public static final String PARQUET_READ_SCHEMA = "parquet.read.schema";

    public static MessageType getSchemaForRead(MessageType fileMessageType, String partialReadSchemaString) {
        if (partialReadSchemaString == null) {
            return fileMessageType;
        }
        MessageType requestedMessageType = MessageTypeParser.parseMessageType((String)partialReadSchemaString);
        return ReadSupport.getSchemaForRead(fileMessageType, requestedMessageType);
    }

    public static MessageType getSchemaForRead(MessageType fileMessageType, MessageType projectedMessageType) {
        fileMessageType.checkContains((Type)projectedMessageType);
        return projectedMessageType;
    }

    @Deprecated
    public ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        throw new UnsupportedOperationException("Override init(InitContext)");
    }

    public ReadContext init(InitContext context) {
        return this.init(context.getConfiguration(), context.getMergedKeyValueMetaData(), context.getFileSchema());
    }

    public abstract RecordMaterializer<T> prepareForRead(Configuration var1, Map<String, String> var2, MessageType var3, ReadContext var4);

    public static final class ReadContext {
        private final MessageType requestedSchema;
        private final Map<String, String> readSupportMetadata;

        public ReadContext(MessageType requestedSchema) {
            this(requestedSchema, null);
        }

        public ReadContext(MessageType requestedSchema, Map<String, String> readSupportMetadata) {
            if (requestedSchema == null) {
                throw new NullPointerException("requestedSchema");
            }
            this.requestedSchema = requestedSchema;
            this.readSupportMetadata = readSupportMetadata;
        }

        public MessageType getRequestedSchema() {
            return this.requestedSchema;
        }

        public Map<String, String> getReadSupportMetadata() {
            return this.readSupportMetadata;
        }
    }
}

