/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import parquet.Log;
import parquet.column.ColumnDescriptor;
import parquet.column.page.DictionaryPage;
import parquet.column.page.Page;
import parquet.column.page.PageReadStore;
import parquet.column.page.PageReader;
import parquet.hadoop.CodecFactory;

class ColumnChunkPageReadStore
implements PageReadStore {
    private static final Log LOG = Log.getLog(ColumnChunkPageReadStore.class);
    private final Map<ColumnDescriptor, ColumnChunkPageReader> readers = new HashMap<ColumnDescriptor, ColumnChunkPageReader>();
    private final long rowCount;

    public ColumnChunkPageReadStore(long rowCount) {
        this.rowCount = rowCount;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public PageReader getPageReader(ColumnDescriptor path) {
        if (!this.readers.containsKey(path)) {
            throw new IllegalArgumentException(path + " is not in the store: " + this.readers.keySet() + " " + this.rowCount);
        }
        return this.readers.get(path);
    }

    void addColumn(ColumnDescriptor path, ColumnChunkPageReader reader) {
        if (this.readers.put(path, reader) != null) {
            throw new RuntimeException(path + " was added twice");
        }
    }

    static final class ColumnChunkPageReader
    implements PageReader {
        private final CodecFactory.BytesDecompressor decompressor;
        private final long valueCount;
        private final List<Page> compressedPages;
        private final DictionaryPage compressedDictionaryPage;

        ColumnChunkPageReader(CodecFactory.BytesDecompressor decompressor, List<Page> compressedPages, DictionaryPage compressedDictionaryPage) {
            this.decompressor = decompressor;
            this.compressedPages = new LinkedList<Page>(compressedPages);
            this.compressedDictionaryPage = compressedDictionaryPage;
            int count = 0;
            for (Page p : compressedPages) {
                count += p.getValueCount();
            }
            this.valueCount = count;
        }

        public long getTotalValueCount() {
            return this.valueCount;
        }

        public Page readPage() {
            if (this.compressedPages.isEmpty()) {
                return null;
            }
            Page compressedPage = this.compressedPages.remove(0);
            try {
                return new Page(this.decompressor.decompress(compressedPage.getBytes(), compressedPage.getUncompressedSize()), compressedPage.getValueCount(), compressedPage.getUncompressedSize(), compressedPage.getStatistics(), compressedPage.getRlEncoding(), compressedPage.getDlEncoding(), compressedPage.getValueEncoding());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public DictionaryPage readDictionaryPage() {
            if (this.compressedDictionaryPage == null) {
                return null;
            }
            try {
                return new DictionaryPage(this.decompressor.decompress(this.compressedDictionaryPage.getBytes(), this.compressedDictionaryPage.getUncompressedSize()), this.compressedDictionaryPage.getDictionarySize(), this.compressedDictionaryPage.getEncoding());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

