/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import parquet.Log;
import parquet.Preconditions;
import parquet.filter.UnboundRecordFilter;
import parquet.filter2.compat.FilterCompat;
import parquet.filter2.predicate.FilterPredicate;
import parquet.hadoop.BadConfigurationException;
import parquet.hadoop.Footer;
import parquet.hadoop.LruCache;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetFileWriter;
import parquet.hadoop.ParquetInputSplit;
import parquet.hadoop.ParquetRecordReader;
import parquet.hadoop.SplitStrategy;
import parquet.hadoop.api.InitContext;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.metadata.GlobalMetaData;
import parquet.hadoop.util.ConfigurationUtil;
import parquet.hadoop.util.ContextUtil;
import parquet.hadoop.util.SerializationUtil;
import parquet.io.ParquetDecodingException;

public class ParquetInputFormat<T>
extends FileInputFormat<Void, T> {
    private static final Log LOG = Log.getLog(ParquetInputFormat.class);
    public static final String READ_SUPPORT_CLASS = "parquet.read.support.class";
    public static final String UNBOUND_RECORD_FILTER = "parquet.read.filter";
    public static final String STRICT_TYPE_CHECKING = "parquet.strict.typing";
    public static final String FILTER_PREDICATE = "parquet.private.read.filter.predicate";
    public static final String TASK_SIDE_METADATA = "parquet.task.side.metadata";
    private static final int MIN_FOOTER_CACHE_SIZE = 100;
    private LruCache<FileStatusWrapper, FootersCacheValue> footersCache;
    private Class<?> readSupportClass;
    private static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };

    public static void setTaskSideMetaData(Job job, boolean taskSideMetadata) {
        ContextUtil.getConfiguration((JobContext)job).setBoolean(TASK_SIDE_METADATA, taskSideMetadata);
    }

    public static boolean isTaskSideMetaData(Configuration configuration) {
        return configuration.getBoolean(TASK_SIDE_METADATA, Boolean.FALSE.booleanValue());
    }

    public static void setReadSupportClass(Job job, Class<?> readSupportClass) {
        ContextUtil.getConfiguration((JobContext)job).set(READ_SUPPORT_CLASS, readSupportClass.getName());
    }

    public static void setUnboundRecordFilter(Job job, Class<? extends UnboundRecordFilter> filterClass) {
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Preconditions.checkArgument((ParquetInputFormat.getFilterPredicate(conf) == null ? 1 : 0) != 0, (String)"You cannot provide an UnboundRecordFilter after providing a FilterPredicate");
        conf.set(UNBOUND_RECORD_FILTER, filterClass.getName());
    }

    @Deprecated
    public static Class<?> getUnboundRecordFilter(Configuration configuration) {
        return ConfigurationUtil.getClassFromConfig(configuration, UNBOUND_RECORD_FILTER, UnboundRecordFilter.class);
    }

    private static UnboundRecordFilter getUnboundRecordFilterInstance(Configuration configuration) {
        Class<?> clazz = ConfigurationUtil.getClassFromConfig(configuration, UNBOUND_RECORD_FILTER, UnboundRecordFilter.class);
        if (clazz == null) {
            return null;
        }
        try {
            UnboundRecordFilter unboundRecordFilter = (UnboundRecordFilter)clazz.newInstance();
            if (unboundRecordFilter instanceof Configurable) {
                ((Configurable)unboundRecordFilter).setConf(configuration);
            }
            return unboundRecordFilter;
        }
        catch (InstantiationException e) {
            throw new BadConfigurationException("could not instantiate unbound record filter class", e);
        }
        catch (IllegalAccessException e) {
            throw new BadConfigurationException("could not instantiate unbound record filter class", e);
        }
    }

    public static void setReadSupportClass(JobConf conf, Class<?> readSupportClass) {
        conf.set(READ_SUPPORT_CLASS, readSupportClass.getName());
    }

    public static Class<?> getReadSupportClass(Configuration configuration) {
        return ConfigurationUtil.getClassFromConfig(configuration, READ_SUPPORT_CLASS, ReadSupport.class);
    }

    public static void setFilterPredicate(Configuration configuration, FilterPredicate filterPredicate) {
        Preconditions.checkArgument((ParquetInputFormat.getUnboundRecordFilter(configuration) == null ? 1 : 0) != 0, (String)"You cannot provide a FilterPredicate after providing an UnboundRecordFilter");
        configuration.set("parquet.private.read.filter.predicate.human.readable", filterPredicate.toString());
        try {
            SerializationUtil.writeObjectToConfAsBase64(FILTER_PREDICATE, filterPredicate, configuration);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static FilterPredicate getFilterPredicate(Configuration configuration) {
        try {
            return (FilterPredicate)SerializationUtil.readObjectFromConfAsBase64(FILTER_PREDICATE, configuration);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static FilterCompat.Filter getFilter(Configuration conf) {
        return FilterCompat.get((FilterPredicate)ParquetInputFormat.getFilterPredicate(conf), (UnboundRecordFilter)ParquetInputFormat.getUnboundRecordFilterInstance(conf));
    }

    public ParquetInputFormat() {
    }

    public <S extends ReadSupport<T>> ParquetInputFormat(Class<S> readSupportClass) {
        this.readSupportClass = readSupportClass;
    }

    public RecordReader<Void, T> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Configuration conf = ContextUtil.getConfiguration((JobContext)taskAttemptContext);
        ReadSupport<T> readSupport = this.getReadSupport(conf);
        return new ParquetRecordReader<T>(readSupport, ParquetInputFormat.getFilter(conf));
    }

    public ReadSupport<T> getReadSupport(Configuration configuration) {
        try {
            if (this.readSupportClass == null) {
                this.readSupportClass = ParquetInputFormat.getReadSupportClass(configuration);
            }
            return (ReadSupport)this.readSupportClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new BadConfigurationException("could not instantiate read support class", e);
        }
        catch (IllegalAccessException e) {
            throw new BadConfigurationException("could not instantiate read support class", e);
        }
    }

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException {
        Configuration configuration = ContextUtil.getConfiguration(jobContext);
        return new ArrayList<ParquetInputSplit>(this.getSplits(configuration, this.getFooters(jobContext)));
    }

    public List<ParquetInputSplit> getSplits(Configuration configuration, List<Footer> footers) throws IOException {
        boolean taskSideMetaData = ParquetInputFormat.isTaskSideMetaData(configuration);
        boolean strictTypeChecking = configuration.getBoolean(STRICT_TYPE_CHECKING, true);
        long maxSplitSize = configuration.getLong("mapred.max.split.size", Long.MAX_VALUE);
        long minSplitSize = Math.max(this.getFormatMinSplitSize(), configuration.getLong("mapred.min.split.size", 0L));
        if (maxSplitSize < 0L || minSplitSize < 0L) {
            throw new ParquetDecodingException("maxSplitSize or minSplitSize should not be negative: maxSplitSize = " + maxSplitSize + "; minSplitSize = " + minSplitSize);
        }
        GlobalMetaData globalMetaData = ParquetFileWriter.getGlobalMetaData(footers, strictTypeChecking);
        ReadSupport.ReadContext readContext = this.getReadSupport(configuration).init(new InitContext(configuration, globalMetaData.getKeyValueMetaData(), globalMetaData.getSchema()));
        return SplitStrategy.getSplitStrategy(taskSideMetaData).getSplits(configuration, footers, maxSplitSize, minSplitSize, readContext);
    }

    protected List<FileStatus> listStatus(JobContext jobContext) throws IOException {
        return ParquetInputFormat.getAllFileRecursively(super.listStatus(jobContext), ContextUtil.getConfiguration(jobContext));
    }

    private static List<FileStatus> getAllFileRecursively(List<FileStatus> files, Configuration conf) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        for (FileStatus file : files) {
            if (file.isDir()) {
                Path p = file.getPath();
                FileSystem fs = p.getFileSystem(conf);
                ParquetInputFormat.staticAddInputPathRecursively(result, fs, p, hiddenFileFilter);
                continue;
            }
            result.add(file);
        }
        LOG.info((Object)("Total input paths to process : " + result.size()));
        return result;
    }

    private static void staticAddInputPathRecursively(List<FileStatus> result, FileSystem fs, Path path, PathFilter inputFilter) throws IOException {
        for (FileStatus stat : fs.listStatus(path, inputFilter)) {
            if (stat.isDir()) {
                ParquetInputFormat.staticAddInputPathRecursively(result, fs, stat.getPath(), inputFilter);
                continue;
            }
            result.add(stat);
        }
    }

    public List<Footer> getFooters(JobContext jobContext) throws IOException {
        List<FileStatus> statuses = this.listStatus(jobContext);
        if (statuses.isEmpty()) {
            return Collections.emptyList();
        }
        Configuration config = ContextUtil.getConfiguration(jobContext);
        ArrayList<Footer> footers = new ArrayList<Footer>(statuses.size());
        HashSet<FileStatus> missingStatuses = new HashSet<FileStatus>();
        HashMap<Path, FileStatusWrapper> missingStatusesMap = new HashMap<Path, FileStatusWrapper>(missingStatuses.size());
        if (this.footersCache == null) {
            this.footersCache = new LruCache(Math.max(statuses.size(), 100));
        }
        for (FileStatus status : statuses) {
            FileStatusWrapper statusWrapper = new FileStatusWrapper(status);
            FootersCacheValue cacheEntry = this.footersCache.getCurrentValue(statusWrapper);
            if (Log.DEBUG) {
                LOG.debug((Object)("Cache entry " + (cacheEntry == null ? "not " : "") + " found for '" + status.getPath() + "'"));
            }
            if (cacheEntry != null) {
                footers.add(cacheEntry.getFooter());
                continue;
            }
            missingStatuses.add(status);
            missingStatusesMap.put(status.getPath(), statusWrapper);
        }
        if (Log.DEBUG) {
            LOG.debug((Object)("found " + footers.size() + " footers in cache and adding up " + "to " + missingStatuses.size() + " missing footers to the cache"));
        }
        if (missingStatuses.isEmpty()) {
            return footers;
        }
        List<Footer> newFooters = this.getFooters(config, missingStatuses);
        for (Footer newFooter : newFooters) {
            FileStatusWrapper fileStatus = (FileStatusWrapper)missingStatusesMap.get(newFooter.getFile());
            this.footersCache.put(fileStatus, new FootersCacheValue(fileStatus, newFooter));
        }
        footers.addAll(newFooters);
        return footers;
    }

    public List<Footer> getFooters(Configuration configuration, List<FileStatus> statuses) throws IOException {
        return this.getFooters(configuration, (Collection<FileStatus>)statuses);
    }

    public List<Footer> getFooters(Configuration configuration, Collection<FileStatus> statuses) throws IOException {
        if (Log.DEBUG) {
            LOG.debug((Object)("reading " + statuses.size() + " files"));
        }
        boolean taskSideMetaData = ParquetInputFormat.isTaskSideMetaData(configuration);
        return ParquetFileReader.readAllFootersInParallelUsingSummaryFiles(configuration, statuses, taskSideMetaData);
    }

    public GlobalMetaData getGlobalMetaData(JobContext jobContext) throws IOException {
        return ParquetFileWriter.getGlobalMetaData(this.getFooters(jobContext));
    }

    static final class FileStatusWrapper {
        private final FileStatus status;

        public FileStatusWrapper(FileStatus fileStatus) {
            if (fileStatus == null) {
                throw new IllegalArgumentException("FileStatus object cannot be null");
            }
            this.status = fileStatus;
        }

        public long getModificationTime() {
            return this.status.getModificationTime();
        }

        public int hashCode() {
            return this.status.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof FileStatusWrapper && this.status.equals((Object)((FileStatusWrapper)other).status);
        }

        public String toString() {
            return this.status.getPath().toString();
        }
    }

    static final class FootersCacheValue
    implements LruCache.Value<FileStatusWrapper, FootersCacheValue> {
        private final long modificationTime;
        private final Footer footer;

        public FootersCacheValue(FileStatusWrapper status, Footer footer) {
            this.modificationTime = status.getModificationTime();
            this.footer = new Footer(footer.getFile(), footer.getParquetMetadata());
        }

        @Override
        public boolean isCurrent(FileStatusWrapper key) {
            boolean isCurrent;
            long currentModTime = key.getModificationTime();
            boolean bl = isCurrent = this.modificationTime >= currentModTime;
            if (Log.DEBUG && !isCurrent) {
                LOG.debug((Object)("The cache value for '" + key + "' is not current: " + "cached modification time=" + this.modificationTime + ", " + "current modification time: " + currentModTime));
            }
            return isCurrent;
        }

        public Footer getFooter() {
            return this.footer;
        }

        @Override
        public boolean isNewerThan(FootersCacheValue otherValue) {
            return otherValue == null || this.modificationTime > otherValue.modificationTime;
        }

        public Path getPath() {
            return this.footer.getFile();
        }
    }
}

