/*
 * Decompiled with CFR 0.152.
 */
package parquet.format;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import parquet.format.FileMetaData;
import parquet.format.PageHeader;
import parquet.org.apache.thrift.TBase;
import parquet.org.apache.thrift.TException;
import parquet.org.apache.thrift.protocol.TCompactProtocol;
import parquet.org.apache.thrift.transport.TIOStreamTransport;

public class Util {
    public static void writePageHeader(PageHeader pageHeader, OutputStream to) throws IOException {
        Util.write(pageHeader, to);
    }

    public static PageHeader readPageHeader(InputStream from) throws IOException {
        return Util.read(from, new PageHeader());
    }

    public static void writeFileMetaData(FileMetaData fileMetadata, OutputStream to) throws IOException {
        Util.write(fileMetadata, to);
    }

    public static FileMetaData readFileMetaData(InputStream from) throws IOException {
        return Util.read(from, new FileMetaData());
    }

    private static TCompactProtocol protocol(OutputStream to) {
        return new TCompactProtocol(new TIOStreamTransport(to));
    }

    private static TCompactProtocol protocol(InputStream from) {
        return new TCompactProtocol(new TIOStreamTransport(from));
    }

    private static <T extends TBase<?, ?>> T read(InputStream from, T tbase) throws IOException {
        try {
            tbase.read(Util.protocol(from));
            return tbase;
        }
        catch (TException e) {
            throw new IOException("can not read " + tbase.getClass() + ": " + e.getMessage(), e);
        }
    }

    private static void write(TBase<?, ?> tbase, OutputStream to) throws IOException {
        try {
            tbase.write(Util.protocol(to));
        }
        catch (TException e) {
            throw new IOException("can not write " + tbase, e);
        }
    }
}

