/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig.summary;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import parquet.org.codehaus.jackson.JsonGenerationException;
import parquet.org.codehaus.jackson.JsonParseException;
import parquet.org.codehaus.jackson.annotate.JsonWriteNullProperties;
import parquet.org.codehaus.jackson.map.JsonMappingException;
import parquet.org.codehaus.jackson.map.ObjectMapper;
import parquet.org.codehaus.jackson.map.SerializationConfig;

@JsonWriteNullProperties(value=false)
public abstract class SummaryData {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static ObjectMapper prettyObjectMapper = new ObjectMapper();
    private long count;

    public static String toJSON(SummaryData summaryData) {
        return SummaryData.toJSON(summaryData, objectMapper);
    }

    public static String toPrettyJSON(SummaryData summaryData) {
        return SummaryData.toJSON(summaryData, prettyObjectMapper);
    }

    private static String toJSON(SummaryData summaryData, ObjectMapper mapper) {
        StringWriter stringWriter = new StringWriter();
        try {
            mapper.writeValue(stringWriter, (Object)summaryData);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stringWriter.toString();
    }

    public static <T extends SummaryData> T fromJSON(String json, Class<T> clazz) {
        try {
            return (T)((SummaryData)objectMapper.readValue((Reader)new StringReader(json), clazz));
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends SummaryData> T merge(T s1, T s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        s1.merge(s2);
        return s1;
    }

    protected Schema.FieldSchema getField(Schema schema, int i) {
        try {
            if (schema == null || i >= schema.size()) {
                return null;
            }
            Schema.FieldSchema field = schema.getField(i);
            return field;
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }

    protected Schema getSchema(Schema.FieldSchema field) {
        return field == null ? null : field.schema;
    }

    protected String getName(Schema.FieldSchema field) {
        return field == null ? null : field.alias;
    }

    public void add(Object o) {
        ++this.count;
    }

    public void merge(SummaryData other) {
        this.count += other.count;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public String toString() {
        return SummaryData.toJSON(this);
    }

    static {
        prettyObjectMapper.getSerializationConfig().set(SerializationConfig.Feature.INDENT_OUTPUT, true);
    }
}

