/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.parser.ParserException;
import parquet.Log;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.metadata.GlobalMetaData;
import parquet.hadoop.util.ContextUtil;
import parquet.io.ParquetDecodingException;
import parquet.pig.PigSchemaConverter;
import parquet.pig.TupleReadSupport;

public class ParquetLoader
extends LoadFunc
implements LoadMetadata,
LoadPushDown {
    private static final Log LOG = Log.getLog(ParquetLoader.class);
    static final Map<String, Reference<ParquetInputFormat<Tuple>>> inputFormatCache = new WeakHashMap<String, Reference<ParquetInputFormat<Tuple>>>();
    private Schema requestedSchema;
    private String location;
    private boolean setLocationHasBeenCalled = false;
    private RecordReader<Void, Tuple> reader;
    private ParquetInputFormat<Tuple> parquetInputFormat;
    private Schema schema;
    protected String signature;

    public ParquetLoader() {
        this(null);
    }

    public ParquetLoader(String requestedSchemaStr) {
        this.requestedSchema = PigSchemaConverter.parsePigSchema(requestedSchemaStr);
    }

    public void setLocation(String location, Job job) throws IOException {
        if (Log.DEBUG) {
            LOG.debug((Object)("LoadFunc.setLocation(" + location + ", " + job + ")"));
        }
        this.setInput(location, job);
        ContextUtil.getConfiguration((JobContext)job).set("parquet.pig.schema", PigSchemaConverter.pigSchemaToString(this.schema));
    }

    private void setInput(String location, Job job) throws IOException {
        this.setLocationHasBeenCalled = true;
        this.location = location;
        FileInputFormat.setInputPaths((Job)job, (String)location);
        this.initSchema(job);
    }

    public InputFormat<Void, Tuple> getInputFormat() throws IOException {
        if (Log.DEBUG) {
            LOG.debug((Object)"LoadFunc.getInputFormat()");
        }
        return this.getParquetInputFormat();
    }

    private void checkSetLocationHasBeenCalled() {
        if (!this.setLocationHasBeenCalled) {
            throw new IllegalStateException("setLocation() must be called first");
        }
    }

    private ParquetInputFormat<Tuple> getParquetInputFormat() throws ParserException {
        this.checkSetLocationHasBeenCalled();
        if (this.parquetInputFormat == null) {
            Reference<ParquetInputFormat<Tuple>> ref = inputFormatCache.get(this.location);
            ParquetInputFormat<Tuple> parquetInputFormat = this.parquetInputFormat = ref == null ? null : ref.get();
            if (this.parquetInputFormat == null) {
                this.parquetInputFormat = new UnregisteringParquetInputFormat(this.location);
                inputFormatCache.put(this.location, new SoftReference<ParquetInputFormat<Tuple>>(this.parquetInputFormat));
            }
        }
        return this.parquetInputFormat;
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        if (Log.DEBUG) {
            LOG.debug((Object)("LoadFunc.prepareToRead(" + reader + ", " + split + ")"));
        }
        this.reader = reader;
    }

    public Tuple getNext() throws IOException {
        try {
            if (this.reader.nextKeyValue()) {
                return (Tuple)this.reader.getCurrentValue();
            }
            return null;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ParquetDecodingException("Interrupted", (Throwable)e);
        }
    }

    public String[] getPartitionKeys(String location, Job job) throws IOException {
        if (Log.DEBUG) {
            LOG.debug((Object)("LoadMetadata.getPartitionKeys(" + location + ", " + job + ")"));
        }
        this.setInput(location, job);
        return null;
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        if (Log.DEBUG) {
            LOG.debug((Object)("LoadMetadata.getSchema(" + location + ", " + job + ")"));
        }
        this.setInput(location, job);
        return new ResourceSchema(this.schema);
    }

    private void initSchema(Job job) throws IOException {
        if (this.schema != null) {
            return;
        }
        this.schema = PigSchemaConverter.parsePigSchema(this.getPropertyFromUDFContext("parquet.pig.schema"));
        if (this.schema == null && this.requestedSchema != null) {
            this.schema = this.requestedSchema;
        }
        if (this.schema == null) {
            GlobalMetaData globalMetaData = this.getParquetInputFormat().getGlobalMetaData((JobContext)job);
            this.schema = TupleReadSupport.getPigSchemaFromMultipleFiles(globalMetaData.getSchema(), globalMetaData.getKeyValueMetaData());
        }
        if (this.isElephantBirdCompatible(job)) {
            this.convertToElephantBirdCompatibleSchema(this.schema);
        }
    }

    private void convertToElephantBirdCompatibleSchema(Schema schema) {
        if (schema == null) {
            return;
        }
        for (Schema.FieldSchema fieldSchema : schema.getFields()) {
            if (fieldSchema.type == 5) {
                fieldSchema.type = (byte)10;
            }
            this.convertToElephantBirdCompatibleSchema(fieldSchema.schema);
        }
    }

    private boolean isElephantBirdCompatible(Job job) {
        return ContextUtil.getConfiguration((JobContext)job).getBoolean("parquet.pig.elephantbird.compatible", false);
    }

    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        if (Log.DEBUG) {
            LOG.debug((Object)("LoadMetadata.getStatistics(" + location + ", " + job + ")"));
        }
        long length = 0L;
        try {
            for (InputSplit split : this.getParquetInputFormat().getSplits((JobContext)job)) {
                length += split.getLength();
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Interrupted: ", (Throwable)e);
            return null;
        }
        ResourceStatistics stats = new ResourceStatistics();
        stats.setmBytes(Long.valueOf(length / 1024L / 1024L));
        return stats;
    }

    public void setPartitionFilter(Expression expression) throws IOException {
        if (Log.DEBUG) {
            LOG.debug((Object)("LoadMetadata.setPartitionFilter(" + expression + ")"));
        }
    }

    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Arrays.asList(LoadPushDown.OperatorSet.PROJECTION);
    }

    protected String getPropertyFromUDFContext(String key) {
        UDFContext udfContext = UDFContext.getUDFContext();
        return udfContext.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.signature}).getProperty(key);
    }

    protected Object getFromUDFContext(String key) {
        UDFContext udfContext = UDFContext.getUDFContext();
        return udfContext.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.signature}).get(key);
    }

    protected void storeInUDFContext(String key, Object value) {
        UDFContext udfContext = UDFContext.getUDFContext();
        Properties props = udfContext.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.signature});
        props.put(key, value);
    }

    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        if (requiredFieldList == null) {
            return null;
        }
        this.schema = this.getSchemaFromRequiredFieldList(this.schema, requiredFieldList.getFields());
        this.storeInUDFContext("parquet.pig.schema", PigSchemaConverter.pigSchemaToString(this.schema));
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    public void setUDFContextSignature(String signature) {
        this.signature = signature;
    }

    private Schema getSchemaFromRequiredFieldList(Schema schema, List<LoadPushDown.RequiredField> fieldList) throws FrontendException {
        Schema s = new Schema();
        for (LoadPushDown.RequiredField rf : fieldList) {
            Schema.FieldSchema f;
            try {
                f = schema.getField(rf.getAlias()).clone();
            }
            catch (CloneNotSupportedException e) {
                throw new FrontendException("Clone not supported for the fieldschema", (Throwable)e);
            }
            if (rf.getSubFields() == null) {
                s.add(f);
                continue;
            }
            Schema innerSchema = this.getSchemaFromRequiredFieldList(f.schema, rf.getSubFields());
            if (innerSchema == null) {
                return null;
            }
            f.schema = innerSchema;
            s.add(f);
        }
        return s;
    }

    private static class UnregisteringParquetInputFormat
    extends ParquetInputFormat<Tuple> {
        private final String location;

        public UnregisteringParquetInputFormat(String location) {
            super(TupleReadSupport.class);
            this.location = location;
        }

        public RecordReader<Void, Tuple> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            inputFormatCache.remove(this.location);
            return super.createRecordReader(inputSplit, taskAttemptContext);
        }
    }
}

