/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.EntryValidator;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.DuplicateValueBehavior;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.ldif.LDIFReaderEntryTranslator;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ValidateLDIF
extends LDAPCommandLineTool
implements LDIFReaderEntryTranslator {
    private static final String EOL = System.getProperty("line.separator", "\n");
    private BooleanArgument ignoreDuplicateValues;
    private BooleanArgument ignoreUndefinedObjectClasses;
    private BooleanArgument ignoreUndefinedAttributes;
    private BooleanArgument ignoreMalformedDNs;
    private BooleanArgument ignoreMissingSuperiorObjectClasses;
    private BooleanArgument ignoreStructuralObjectClasses;
    private BooleanArgument ignoreProhibitedObjectClasses;
    private BooleanArgument ignoreProhibitedAttributes;
    private BooleanArgument ignoreMissingAttributes;
    private BooleanArgument ignoreSingleValuedAttributes;
    private BooleanArgument ignoreAttributeSyntax;
    private BooleanArgument ignoreNameForms;
    private BooleanArgument isCompressed;
    private FileArgument schemaDirectory;
    private FileArgument ldifFile;
    private FileArgument rejectFile;
    private IntegerArgument numThreads;
    private final AtomicLong entriesProcessed = new AtomicLong(0L);
    private final AtomicLong malformedEntries = new AtomicLong(0L);
    private EntryValidator entryValidator;
    private LDIFWriter rejectWriter;

    public static void main(String[] args) {
        ResultCode resultCode = ValidateLDIF.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(String[] args, OutputStream outStream, OutputStream errStream) {
        ValidateLDIF validateLDIF = new ValidateLDIF(outStream, errStream);
        return validateLDIF.runTool(args);
    }

    public ValidateLDIF(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    public String getToolName() {
        return "validate-ldif";
    }

    @Override
    public String getToolDescription() {
        return "Validate the contents of an LDIF file against the server schema.";
    }

    @Override
    public String getToolVersion() {
        return "2.3.8";
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        String description = "The path to the LDIF file to process.";
        this.ldifFile = new FileArgument(Character.valueOf('f'), "ldifFile", true, 1, "{path}", description, true, true, true, false);
        parser.addArgument(this.ldifFile);
        description = "Indicates that the specified LDIF file is compressed using gzip compression.";
        this.isCompressed = new BooleanArgument(Character.valueOf('c'), "isCompressed", description);
        parser.addArgument(this.isCompressed);
        description = "The path to the file to which rejected entries should be written.";
        this.rejectFile = new FileArgument(Character.valueOf('R'), "rejectFile", false, 1, "{path}", description, false, true, true, false);
        parser.addArgument(this.rejectFile);
        description = "The path to a directory containing one or more LDIF files with the schema information to use.  If this is provided, then no LDAP communication will be performed.";
        this.schemaDirectory = new FileArgument(null, "schemaDirectory", false, 1, "{path}", description, true, true, false, true);
        parser.addArgument(this.schemaDirectory);
        description = "The number of threads to use when processing the LDIF file.";
        this.numThreads = new IntegerArgument(Character.valueOf('t'), "numThreads", true, 1, "{num}", description, 1, Integer.MAX_VALUE, 1);
        parser.addArgument(this.numThreads);
        description = "Ignore validation failures due to entries containing duplicate values for the same attribute.";
        this.ignoreDuplicateValues = new BooleanArgument(null, "ignoreDuplicateValues", description);
        parser.addArgument(this.ignoreDuplicateValues);
        description = "Ignore validation failures due to object classes not defined in the schema.";
        this.ignoreUndefinedObjectClasses = new BooleanArgument(null, "ignoreUndefinedObjectClasses", description);
        parser.addArgument(this.ignoreUndefinedObjectClasses);
        description = "Ignore validation failures due to attributes not defined in the schema.";
        this.ignoreUndefinedAttributes = new BooleanArgument(null, "ignoreUndefinedAttributes", description);
        parser.addArgument(this.ignoreUndefinedAttributes);
        description = "Ignore validation failures due to entries with malformed DNs.";
        this.ignoreMalformedDNs = new BooleanArgument(null, "ignoreMalformedDNs", description);
        parser.addArgument(this.ignoreMalformedDNs);
        description = "Ignore validation failures due to entries without exactly structural object class.";
        this.ignoreStructuralObjectClasses = new BooleanArgument(null, "ignoreStructuralObjectClasses", description);
        parser.addArgument(this.ignoreStructuralObjectClasses);
        description = "Ignore validation failures due to entries with object classes that are not allowed.";
        this.ignoreProhibitedObjectClasses = new BooleanArgument(null, "ignoreProhibitedObjectClasses", description);
        parser.addArgument(this.ignoreProhibitedObjectClasses);
        description = "Ignore validation failures due to entries that are one or more superior object classes.";
        this.ignoreMissingSuperiorObjectClasses = new BooleanArgument(null, "ignoreMissingSuperiorObjectClasses", description);
        parser.addArgument(this.ignoreMissingSuperiorObjectClasses);
        description = "Ignore validation failures due to entries with attributes that are not allowed.";
        this.ignoreProhibitedAttributes = new BooleanArgument(null, "ignoreProhibitedAttributes", description);
        parser.addArgument(this.ignoreProhibitedAttributes);
        description = "Ignore validation failures due to entries missing required attributes.";
        this.ignoreMissingAttributes = new BooleanArgument(null, "ignoreMissingAttributes", description);
        parser.addArgument(this.ignoreMissingAttributes);
        description = "Ignore validation failures due to entries with multiple values for single-valued attributes.";
        this.ignoreSingleValuedAttributes = new BooleanArgument(null, "ignoreSingleValuedAttributes", description);
        parser.addArgument(this.ignoreSingleValuedAttributes);
        description = "Ignore validation failures due to entries with attribute values that violate their associated syntax.";
        this.ignoreAttributeSyntax = new BooleanArgument(null, "ignoreAttributeSyntax", description);
        parser.addArgument(this.ignoreAttributeSyntax);
        description = "Ignore validation failures due to entries with RDNs that violate the associated name form definition.";
        this.ignoreNameForms = new BooleanArgument(null, "ignoreNameForms", description);
        parser.addArgument(this.ignoreNameForms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultCode doToolProcessing() {
        block56: {
            if (this.schemaDirectory.isPresent()) {
                schemaDir = this.schemaDirectory.getValue();
                try {
                    fileMap = new TreeMap<String, File>();
                    for (File f : schemaDir.listFiles()) {
                        name = f.getName();
                        if (!f.isFile() || !name.endsWith(".ldif")) continue;
                        fileMap.put(name, f);
                    }
                    if (fileMap.isEmpty()) {
                        this.err(new Object[]{"No LDIF files found in directory " + schemaDir.getAbsolutePath()});
                        return ResultCode.PARAM_ERROR;
                    }
                    fileList /* !! */  = new ArrayList<File>(fileMap.values());
                    schema = Schema.getSchema(fileList /* !! */ );
                }
                catch (Exception e) {
                    this.err(new Object[]{"Unable to read schema from files in directory " + schemaDir.getAbsolutePath() + ":  " + StaticUtils.getExceptionMessage(e)});
                    return ResultCode.LOCAL_ERROR;
                }
            }
            try {
                connection = this.getConnection();
                schema = connection.getSchema();
                connection.close();
            }
            catch (LDAPException le) {
                this.err(new Object[]{"Unable to connect to the directory server and read the schema:  ", le.getMessage()});
                return le.getResultCode();
            }
            this.entryValidator = new EntryValidator(schema);
            this.entryValidator.setCheckAttributeSyntax(this.ignoreAttributeSyntax.isPresent() == false);
            this.entryValidator.setCheckMalformedDNs(this.ignoreMalformedDNs.isPresent() == false);
            this.entryValidator.setCheckMissingAttributes(this.ignoreMissingAttributes.isPresent() == false);
            this.entryValidator.setCheckNameForms(this.ignoreNameForms.isPresent() == false);
            this.entryValidator.setCheckProhibitedAttributes(this.ignoreProhibitedAttributes.isPresent() == false);
            this.entryValidator.setCheckProhibitedObjectClasses(this.ignoreProhibitedObjectClasses.isPresent() == false);
            this.entryValidator.setCheckMissingSuperiorObjectClasses(this.ignoreMissingSuperiorObjectClasses.isPresent() == false);
            this.entryValidator.setCheckSingleValuedAttributes(this.ignoreSingleValuedAttributes.isPresent() == false);
            this.entryValidator.setCheckStructuralObjectClasses(this.ignoreStructuralObjectClasses.isPresent() == false);
            this.entryValidator.setCheckUndefinedAttributes(this.ignoreUndefinedAttributes.isPresent() == false);
            this.entryValidator.setCheckUndefinedObjectClasses(this.ignoreUndefinedObjectClasses.isPresent() == false);
            this.rejectWriter = null;
            try {
                inputStream /* !! */  = new FileInputStream(this.ldifFile.getValue());
                if (this.isCompressed.isPresent()) {
                    inputStream /* !! */  = new GZIPInputStream(inputStream /* !! */ );
                }
                ldifReader = new LDIFReader(inputStream /* !! */ , (int)this.numThreads.getValue(), (LDIFReaderEntryTranslator)this);
            }
            catch (Exception e) {
                this.err(new Object[]{"Unable to open the LDIF reader:  ", StaticUtils.getExceptionMessage(e)});
                return ResultCode.LOCAL_ERROR;
            }
            ldifReader.setSchema(schema);
            if (this.ignoreDuplicateValues.isPresent()) {
                ldifReader.setDuplicateValueBehavior(DuplicateValueBehavior.STRIP);
            } else {
                ldifReader.setDuplicateValueBehavior(DuplicateValueBehavior.REJECT);
            }
            try {
                try {
                    if (this.rejectFile.isPresent()) {
                        this.rejectWriter = new LDIFWriter(this.rejectFile.getValue());
                    }
                }
                catch (Exception e) {
                    this.err(new Object[]{"Unable to create the reject writer:  ", StaticUtils.getExceptionMessage(e)});
                    fileList /* !! */  = ResultCode.LOCAL_ERROR;
                    var10_22 = null;
                    try {
                        ldifReader.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (this.rejectWriter == null) return fileList /* !! */ ;
                        this.rejectWriter.close();
                        return fileList /* !! */ ;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return fileList /* !! */ ;
                }
                resultCode = ResultCode.SUCCESS;
                while (true) {
                    try {
                        while ((e = ldifReader.readEntry()) != null) {
                        }
                    }
                    catch (LDIFException le) {
                        block52: {
                            this.malformedEntries.incrementAndGet();
                            if (resultCode == ResultCode.SUCCESS) {
                                resultCode = ResultCode.DECODING_ERROR;
                            }
                            if (this.rejectWriter == null) continue;
                            try {
                                this.rejectWriter.writeComment("Unable to parse an entry read from LDIF:", false, false);
                                if (le.mayContinueReading()) {
                                    this.rejectWriter.writeComment(StaticUtils.getExceptionMessage(le), false, true);
                                    continue;
                                }
                                this.rejectWriter.writeComment(StaticUtils.getExceptionMessage(le), false, false);
                                this.rejectWriter.writeComment("Unable to continue LDIF processing.", false, true);
                                this.err(new Object[]{"Aborting LDIF processing:  ", StaticUtils.getExceptionMessage(le)});
                                len$ = ResultCode.LOCAL_ERROR;
                            }
                            catch (IOException ioe) {
                                block51: {
                                    this.err(new Object[]{"Unable to write to the reject file:", StaticUtils.getExceptionMessage(ioe)});
                                    this.err(new Object[]{"LDIF parse failure that triggered the rejection:  ", StaticUtils.getExceptionMessage(le)});
                                    var6_17 = ResultCode.LOCAL_ERROR;
                                    var10_24 = null;
                                    ** try [egrp 8[TRYBLOCK] [16 : 1153->1160)] { 
lbl107:
                                    // 1 sources

                                    ldifReader.close();
                                    break block51;
lbl109:
                                    // 1 sources

                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                ** try [egrp 9[TRYBLOCK] [17 : 1162->1179)] { 
lbl113:
                                // 1 sources

                                if (this.rejectWriter == null) return var6_17;
                                this.rejectWriter.close();
                                return var6_17;
lbl116:
                                // 1 sources

                                catch (Exception e) {
                                    // empty catch block
                                }
                                return var6_17;
                            }
                            var10_23 = null;
                            ** try [egrp 8[TRYBLOCK] [16 : 1153->1160)] { 
lbl121:
                            // 1 sources

                            ldifReader.close();
                            break block52;
lbl123:
                            // 1 sources

                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 9[TRYBLOCK] [17 : 1162->1179)] { 
lbl127:
                        // 1 sources

                        if (this.rejectWriter == null) return len$;
                        this.rejectWriter.close();
                        return len$;
lbl130:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                        return len$;
                    }
                    catch (IOException ioe) {
                        block54: {
                            if (this.rejectWriter != null) ** break;
                            continue;
                            try {
                                this.rejectWriter.writeComment("I/O error reading from LDIF:", false, false);
                                this.rejectWriter.writeComment(StaticUtils.getExceptionMessage(ioe), false, true);
                                ioe = ResultCode.LOCAL_ERROR;
                            }
                            catch (Exception ex) {
                                block53: {
                                    this.err(new Object[]{"I/O error reading from LDIF:", StaticUtils.getExceptionMessage(ioe)});
                                    var6_18 = ResultCode.LOCAL_ERROR;
                                    var10_26 = null;
                                    ** try [egrp 8[TRYBLOCK] [16 : 1153->1160)] { 
lbl147:
                                    // 1 sources

                                    ldifReader.close();
                                    break block53;
lbl149:
                                    // 1 sources

                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                ** try [egrp 9[TRYBLOCK] [17 : 1162->1179)] { 
lbl153:
                                // 1 sources

                                if (this.rejectWriter == null) return var6_18;
                                this.rejectWriter.close();
                                return var6_18;
lbl156:
                                // 1 sources

                                catch (Exception e) {
                                    // empty catch block
                                }
                                return var6_18;
                            }
                            var10_25 = null;
                            ** try [egrp 8[TRYBLOCK] [16 : 1153->1160)] { 
lbl161:
                            // 1 sources

                            ldifReader.close();
                            break block54;
lbl163:
                            // 1 sources

                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 9[TRYBLOCK] [17 : 1162->1179)] { 
lbl167:
                        // 1 sources

                        if (this.rejectWriter == null) return ioe;
                        this.rejectWriter.close();
                        return ioe;
lbl170:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                        return ioe;
                    }
                    break;
                }
                if (this.malformedEntries.get() > 0L) {
                    this.out(new Object[]{this.malformedEntries.get() + " entries were malformed and could not " + "be read from the LDIF file."});
                }
                if (this.entryValidator.getInvalidEntries() > 0L) {
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = ResultCode.OBJECT_CLASS_VIOLATION;
                    }
                    for (String s : this.entryValidator.getInvalidEntrySummary(true)) {
                        this.out(new Object[]{s});
                    }
                } else if (this.malformedEntries.get() == 0L) {
                    this.out(new Object[]{"No errors were encountered."});
                }
                var4_7 = resultCode;
                var10_27 = null;
            }
            catch (Throwable var9_36) {
                block55: {
                    var10_28 = null;
                    ** try [egrp 8[TRYBLOCK] [16 : 1153->1160)] { 
lbl192:
                    // 1 sources

                    ldifReader.close();
                    break block55;
lbl194:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {}
                catch (Exception e) {
                    throw var9_36;
                }
                if (this.rejectWriter == null) throw var9_36;
                this.rejectWriter.close();
                throw var9_36;
            }
            ** try [egrp 8[TRYBLOCK] [16 : 1153->1160)] { 
lbl204:
            // 1 sources

            ldifReader.close();
            break block56;
lbl206:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
        }
        ** try [egrp 9[TRYBLOCK] [17 : 1162->1179)] { 
lbl210:
        // 1 sources

        if (this.rejectWriter == null) return var4_7;
        this.rejectWriter.close();
        return var4_7;
lbl213:
        // 1 sources

        catch (Exception e) {
            // empty catch block
        }
        return var4_7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry translate(Entry entry, long firstLineNumber) {
        long numEntries;
        ArrayList<String> invalidReasons = new ArrayList<String>(5);
        if (!this.entryValidator.entryIsValid(entry, invalidReasons) && this.rejectWriter != null) {
            ValidateLDIF validateLDIF = this;
            synchronized (validateLDIF) {
                try {
                    this.rejectWriter.writeEntry(entry, ValidateLDIF.listToString(invalidReasons));
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
        if ((numEntries = this.entriesProcessed.incrementAndGet()) % 1000L == 0L) {
            this.out("Processed ", numEntries, " entries.");
        }
        return null;
    }

    private static String listToString(List<String> l) {
        if (l == null || l.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        Iterator<String> iterator = l.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(EOL);
        }
        return buffer.toString();
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(2);
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--ldifFile", "data.ldif", "--rejectFile", "rejects.ldif", "--numThreads", "4"};
        String description = "Validate the contents of the 'data.ldif' file using the schema defined in the specified directory server using four concurrent threads.  All types of validation will be performed, and information about any errors will be written to the 'rejects.ldif' file.";
        examples.put(args, description);
        args = new String[]{"--schemaDirectory", "/ds/config/schema", "--ldifFile", "data.ldif", "--rejectFile", "rejects.ldif", "--ignoreStructuralObjectClasses", "--ignoreAttributeSyntax"};
        description = "Validate the contents of the 'data.ldif' file using the schema defined in LDIF files contained in the /ds/config/schema directory using a single thread.  Any errors resulting from entries that do not have exactly one structural object class or from values which violate the syntax for their associated attribute types will be ignored.  Information about any other failures will be written to the 'rejects.ldif' file.";
        examples.put(args, description);
        return examples;
    }

    public EntryValidator getEntryValidator() {
        return this.entryValidator;
    }
}

