/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.WrapperKeyManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class KeyStoreKeyManager
extends WrapperKeyManager
implements Serializable {
    private static final long serialVersionUID = -5202641256733094253L;
    private final String keyStoreFile;
    private final String keyStoreFormat;

    public KeyStoreKeyManager(File keyStoreFile, char[] keyStorePIN) throws KeyStoreException {
        this(keyStoreFile.getAbsolutePath(), keyStorePIN, null, null);
    }

    public KeyStoreKeyManager(String keyStoreFile, char[] keyStorePIN) throws KeyStoreException {
        this(keyStoreFile, keyStorePIN, null, null);
    }

    public KeyStoreKeyManager(File keyStoreFile, char[] keyStorePIN, String keyStoreFormat, String certificateAlias) throws KeyStoreException {
        this(keyStoreFile.getAbsolutePath(), keyStorePIN, keyStoreFormat, certificateAlias);
    }

    public KeyStoreKeyManager(String keyStoreFile, char[] keyStorePIN, String keyStoreFormat, String certificateAlias) throws KeyStoreException {
        super(KeyStoreKeyManager.getKeyManagers(keyStoreFile, keyStorePIN, keyStoreFormat), certificateAlias);
        this.keyStoreFile = keyStoreFile;
        this.keyStoreFormat = keyStoreFormat == null ? KeyStore.getDefaultType() : keyStoreFormat;
    }

    /*
     * Unable to fully structure code
     */
    private static KeyManager[] getKeyManagers(String keyStoreFile, char[] keyStorePIN, String keyStoreFormat) throws KeyStoreException {
        block13: {
            Validator.ensureNotNull(keyStoreFile);
            type = keyStoreFormat;
            if (type == null) {
                type = KeyStore.getDefaultType();
            }
            if (!(f = new File(keyStoreFile)).exists()) {
                throw new KeyStoreException(SSLMessages.ERR_KEYSTORE_NO_SUCH_FILE.get(new Object[]{keyStoreFile}));
            }
            ks = KeyStore.getInstance(type);
            inputStream = null;
            try {
                inputStream = new FileInputStream(f);
                ks.load(inputStream, keyStorePIN);
                var9_7 = null;
                ** if (inputStream == null) goto lbl-1000
            }
            catch (Throwable var8_14) {
                var9_8 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                }
                throw var8_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block13;
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new KeyStoreException(SSLMessages.ERR_KEYSTORE_CANNOT_LOAD.get(new Object[]{keyStoreFile, type, String.valueOf(e)}), e);
                }
            }
        }
        try {
            factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            factory.init(ks, keyStorePIN);
            return factory.getKeyManagers();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new KeyStoreException(SSLMessages.ERR_KEYSTORE_CANNOT_GET_KEY_MANAGERS.get(new Object[]{keyStoreFile, keyStoreFormat, String.valueOf(e)}), e);
        }
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public String getKeyStoreFormat() {
        return this.keyStoreFormat;
    }
}

