/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RotateLogTask
extends Task {
    static final String ROTATE_LOG_TASK_CLASS = "com.unboundid.directory.server.tasks.RotateLogTask";
    private static final String ATTR_PATH = "ds-task-rotate-log-path";
    private static final String OC_ROTATE_LOG_TASK = "ds-task-rotate-log";
    private static final TaskProperty PROPERTY_PATH = new TaskProperty("ds-task-rotate-log-path", TaskMessages.INFO_ROTATE_LOG_DISPLAY_NAME_PATH.get(), TaskMessages.INFO_ROTATE_LOG_DESCRIPTION_PATH.get(), String.class, false, true, false);
    private static final long serialVersionUID = -7737121245254808139L;
    private final List<String> paths;

    public RotateLogTask() {
        this.paths = null;
    }

    public RotateLogTask(String taskID, String ... paths) {
        this(taskID, (Date)null, (List<String>)null, (FailedDependencyAction)null, (List<String>)null, (List<String>)null, paths);
    }

    public RotateLogTask(String taskID, Collection<String> paths) {
        this(taskID, null, null, null, null, null, paths);
    }

    public RotateLogTask(String taskID, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError, String ... paths) {
        this(taskID, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnCompletion, notifyOnError, StaticUtils.toList(paths));
    }

    public RotateLogTask(String taskID, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError, Collection<String> paths) {
        this(taskID, scheduledStartTime, dependencyIDs, failedDependencyAction, null, notifyOnCompletion, null, notifyOnError, null, null, null, paths);
    }

    public RotateLogTask(String taskID, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnStart, List<String> notifyOnCompletion, List<String> notifyOnSuccess, List<String> notifyOnError, Boolean alertOnStart, Boolean alertOnSuccess, Boolean alertOnError, Collection<String> paths) {
        super(taskID, ROTATE_LOG_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        this.paths = paths == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(paths));
    }

    public RotateLogTask(Entry entry) throws TaskException {
        super(entry);
        String[] pathValues = entry.getAttributeValues(ATTR_PATH);
        this.paths = pathValues == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(pathValues)));
    }

    public RotateLogTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(ROTATE_LOG_TASK_CLASS, properties);
        String[] pathArray = StaticUtils.NO_STRINGS;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (!attrName.equalsIgnoreCase(ATTR_PATH)) continue;
            pathArray = RotateLogTask.parseStrings(p, values, pathArray);
        }
        this.paths = Collections.unmodifiableList(Arrays.asList(pathArray));
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_ROTATE_LOG.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_ROTATE_LOG.get();
    }

    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_ROTATE_LOG_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        if (this.paths.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new Attribute(ATTR_PATH, this.paths));
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.singletonList(PROPERTY_PATH);
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(StaticUtils.computeMapCapacity(10));
        if (!this.paths.isEmpty()) {
            props.put(PROPERTY_PATH, Collections.unmodifiableList(this.paths));
        }
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

