/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.UnsolicitedNotificationHandler;
import com.unboundid.ldap.sdk.unboundidds.tools.ManageAccountProcessor;
import com.unboundid.ldap.sdk.unboundidds.tools.ManageAccountSearchProcessor;
import com.unboundid.ldap.sdk.unboundidds.tools.ManageAccountSubCommandType;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.DNFileReader;
import com.unboundid.util.Debug;
import com.unboundid.util.FilterFileReader;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.RateAdjustor;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.BooleanValueArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.FilterArgument;
import com.unboundid.util.args.IPAddressArgumentValueValidator;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.args.SubCommand;
import com.unboundid.util.args.TimestampArgument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ManageAccount
extends LDAPCommandLineTool
implements UnsolicitedNotificationHandler {
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    private static final String ARG_APPEND_TO_REJECT_FILE = "appendToRejectFile";
    static final String ARG_BASE_DN = "baseDN";
    private static final String ARG_GENERATE_SAMPLE_RATE_FILE = "generateSampleRateFile";
    private static final String ARG_DN_INPUT_FILE = "dnInputFile";
    private static final String ARG_FILTER_INPUT_FILE = "filterInputFile";
    static final String ARG_NUM_SEARCH_THREADS = "numSearchThreads";
    static final String ARG_NUM_THREADS = "numThreads";
    private static final String ARG_RATE_PER_SECOND = "ratePerSecond";
    private static final String ARG_REJECT_FILE = "rejectFile";
    static final String ARG_SIMPLE_PAGE_SIZE = "simplePageSize";
    static final String ARG_SUPPRESS_EMPTY_RESULT_OPERATIONS = "suppressEmptyResultOperations";
    private static final String ARG_TARGET_DN = "targetDN";
    private static final String ARG_TARGET_FILTER = "targetFilter";
    private static final String ARG_TARGET_USER_ID = "targetUserID";
    static final String ARG_USER_ID_ATTRIBUTE = "userIDAttribute";
    private static final String ARG_USER_ID_INPUT_FILE = "userIDInputFile";
    private static final String ARG_VARIABLE_RATE_DATA = "variableRateData";
    private static final DN DEFAULT_BASE_DN = DN.NULL_DN;
    private static final String DEFAULT_USER_ID_ATTRIBUTE = "uid";
    private static final String EXAMPLE_TARGET_USER_DN = "uid=jdoe,ou=People,dc=example,dc=com";
    private volatile ArgumentParser parser;
    private final AtomicBoolean allDNsProvided;
    private final AtomicBoolean allFiltersProvided;
    private final AtomicBoolean cancelRequested;
    private volatile FixedRateBarrier rateLimiter;
    private final LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
    private volatile LDIFWriter outputWriter;
    private volatile LDIFWriter rejectWriter;
    private volatile ManageAccountSearchProcessor searchProcessor;
    private volatile RateAdjustor rateAdjustor;

    public static void main(String ... args) {
        ResultCode resultCode = ManageAccount.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultCode main(OutputStream out, OutputStream err, String ... args) {
        ManageAccount tool = new ManageAccount(out, err);
        boolean origCommentAboutBase64EncodedValues = LDIFWriter.commentAboutBase64EncodedValues();
        LDIFWriter.setCommentAboutBase64EncodedValues(true);
        try {
            ResultCode resultCode = tool.runTool(args);
            return resultCode;
        }
        finally {
            LDIFWriter.setCommentAboutBase64EncodedValues(origCommentAboutBase64EncodedValues);
        }
    }

    public ManageAccount(OutputStream out, OutputStream err) {
        super(out, err);
        this.connectionOptions.setUnsolicitedNotificationHandler(this);
        this.allDNsProvided = new AtomicBoolean(false);
        this.allFiltersProvided = new AtomicBoolean(false);
        this.cancelRequested = new AtomicBoolean(false);
        this.parser = null;
        this.rateLimiter = null;
        this.rateAdjustor = null;
        this.outputWriter = null;
        this.rejectWriter = null;
        this.searchProcessor = null;
    }

    @Override
    public String getToolName() {
        return "manage-account";
    }

    @Override
    public String getToolDescription() {
        return ToolMessages.INFO_MANAGE_ACCT_TOOL_DESC.get();
    }

    @Override
    public String getToolVersion() {
        return "4.0.14";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean supportsAuthentication() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    protected boolean supportsSASLHelp() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    protected boolean supportsSSLDebugging() {
        return true;
    }

    @Override
    protected boolean supportsMultipleServers() {
        return true;
    }

    @Override
    protected boolean logToolInvocationByDefault() {
        return true;
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        this.parser = parser;
        String currentGeneralizedTime = StaticUtils.encodeGeneralizedTime(System.currentTimeMillis());
        String olderGeneralizedTime = StaticUtils.encodeGeneralizedTime(System.currentTimeMillis() - 12345L);
        DNArgument targetDN = new DNArgument(Character.valueOf('b'), ARG_TARGET_DN, false, 0, null, ToolMessages.INFO_MANAGE_ACCT_ARG_DESC_TARGET_DN.get());
        targetDN.addLongIdentifier("userDN", true);
        targetDN.addLongIdentifier("target-dn", true);
        targetDN.addLongIdentifier("user-dn", true);
        targetDN.setArgumentGroupName(ToolMessages.INFO_MANAGE_ACCT_ARG_GROUP_TARGET_USER_ARGS.get());
        parser.addArgument(targetDN);
        FileArgument dnInputFile = new FileArgument(null, ARG_DN_INPUT_FILE, false, 0, null, ToolMessages.INFO_MANAGE_ACCT_ARG_DESC_DN_FILE.get(), true, true, true, false);
        dnInputFile.addLongIdentifier("targetDNFile", true);
        dnInputFile.addLongIdentifier("userDNFile", true);
        dnInputFile.addLongIdentifier("dn-input-file", true);
        dnInputFile.addLongIdentifier("target-dn-file", true);
        dnInputFile.addLongIdentifier("user-dn-file", true);
        dnInputFile.setArgumentGroupName(ToolMessages.INFO_MANAGE_ACCT_ARG_GROUP_TARGET_USER_ARGS.get());
        parser.addArgument(dnInputFile);
        FilterArgument targetFilter = new FilterArgument(null, ARG_TARGET_FILTER, false, 0, null, ToolMessages.INFO_MANAGE_ACCT_ARG_DESC_TARGET_FILTER.get(ARG_BASE_DN));
        targetFilter.addLongIdentifier("target-filter", true);
        targetFilter.setArgumentGroupName(ToolMessages.INFO_MANAGE_ACCT_ARG_GROUP_TARGET_USER_ARGS.get());
        parser.addArgument(targetFilter);
        FileArgument filterInputFile = new FileArgument(null, ARG_FILTER_INPUT_FILE, false, 0, null, ToolMessages.INFO_MANAGE_ACCT_ARG_DESC_FILTER_INPUT_FILE.get(ARG_BASE_DN), true, true, true, false);
        filterInputFile.addLongIdentifier("targetFilterFile", true);
        filterInputFile.addLongIdentifier("filter-input-file", true);
        filterInputFile.addLongIdentifier("target-filter-file", true);
        filterInputFile.setArgumentGroupName(ToolMessages.INFO_MANAGE_ACCT_ARG_GROUP_TARGET_USER_ARGS.get());
        parser.addArgument(filterInputFile);
        StringArgument targetUserID = new StringArgument(null, ARG_TARGET_USER_ID, false, 0, null, ToolMessages.INFO_MANAGE_ACCT_ARG_DESC_TARGET_USER_ID.get(ARG_BASE_DN, ARG_USER_ID_ATTRIBUTE));
        targetUserID.addLongIdentifier("userID", true);
        targetUserID.addLongIdentifier("target-user-id", true);
        targetUserID.addLongIdentifier("user-id", true);
        targetUserID.setArgumentGroupName(ToolMessages.INFO_MANAGE_ACCT_ARG_GROUP_TARGET_USER_ARGS.get());
        parser.addArgument(targetUserID);
        FileArgument userIDInputFile = new FileArgument(null, ARG_USER_ID_INPUT_FILE, false, 0, null, ToolMessages.INFO_MANAGE_ACCT_ARG_DESC_USER_ID_INPUT_FILE.get(ARG_BASE_DN, ARG_USER_ID_ATTRIBUTE), true, true, true, false);
        userIDInputFile.addLongIdentifier("targetUserIDFile", true);
        userIDInputFile.addLongIdentifier("user-id-input-file", true);
        userIDInputFile.addLongIdentifier("target-user-id-file", true);
        userIDInputFile.setArgumentGroupName(ToolMessages.INFO_MANAGE_ACCT_ARG_GROUP_TARGET_USER_ARGS.get());
        parser.addArgument(userIDInputFile);
        StringArgument userIDAttribute = new StringArgument(null, ARG_USER_ID_ATTRIBUTE, false, 1, null, ToolMessages.INFO_MANAGE_ACCT_ARG_DESC_USER_ID_ATTR.get(ARG_TARGET_USER_ID, ARG_USER_ID_INPUT_FILE, DEFAULT_USER_ID_ATTRIBUTE), DEFAULT_USER_ID_ATTRIBUTE);
        userIDAttribute.addLongIdentifier("user-id-attribute", true);
        userIDAttribute.setArgumentGroupName(ToolMessages.INFO_MANAGE_ACCT_ARG_GROUP_TARGET_USER_ARGS.get());
        parser.addArgument(userIDAttribute);
        DNArgument baseDN = new DNArgument(null, ARG_BASE_DN, false, 1, null, ToolMessages.INFO_MANAGE_ACCT_ARG_DESC_BASE_DN.get(ARG_TARGET_FILTER, ARG_FILTER_INPUT_FILE, ARG_TARGET_USER_ID, ARG_USER_ID_INPUT_FILE), DEFAULT_BASE_DN);
        baseDN.addLongIdentifier("base-dn", true);
        baseDN.setArgumentGroupName(ToolMessages.INFO_MANAGE_ACCT_ARG_GROUP_TARGET_USER_ARGS.get());
        parser.addArgument(baseDN);
        IntegerArgument simplePageSize = new IntegerArgument(Character.valueOf('z'), ARG_SIMPLE_PAGE_SIZE, false, 1, null, ToolMessages.INFO_MANAGE_ACCT_ARG_DESC_SIMPLE_PAGE_SIZE.get(this.getToolName()), 1, Integer.MAX_VALUE);
        simplePageSize.addLongIdentifier("simple-page-size", true);
        simplePageSize.setArgumentGroupName(ToolMessages.INFO_MANAGE_ACCT_ARG_GROUP_TARGET_USER_ARGS.get(this.getToolName()));
        parser.addArgument(simplePageSize);
        parser.addRequiredArgumentSet(targetDN, dnInputFile, targetFilter, filterInputFile, targetUserID, userIDInputFile);
        IntegerArgument numThreads = new IntegerArgument(Character.valueOf('t'), ARG_NUM_THREADS, false, 1, null, ToolMessages.INFO_MANAGE_ACCT_ARG_DESC_NUM_THREADS.get(this.getToolName()), 1, Integer.MAX_VALUE, 1);
        numThreads.addLongIdentifier("num-threads", true);
        numThreads.setArgumentGroupName(ToolMessages.INFO_MANAGE_ACCT_ARG_GROUP_PERFORMANCE.get());
        parser.addArgument(numThreads);
        IntegerArgument numSearchThreads = new IntegerArgument(null, ARG_NUM_SEARCH_THREADS, false, 1, null, ToolMessages.INFO_MANAGE_ACCT_ARG_DESC_NUM_SEARCH_THREADS.get(this.getToolName()), 1, Integer.MAX_VALUE, 1);
        numSearchThreads.addLongIdentifier("num-search-threads", true);
        numSearchThreads.setArgumentGroupName(ToolMessages.INFO_MANAGE_ACCT_ARG_GROUP_PERFORMANCE.get());
        parser.addArgument(numSearchThreads);
        IntegerArgument ratePerSecond = new IntegerArgument(Character.valueOf('r'), ARG_RATE_PER_SECOND, false, 1, null, ToolMessages.INFO_MANAGE_ACCT_ARG_DESC_RATE_PER_SECOND.get(ARG_VARIABLE_RATE_DATA), 1, Integer.MAX_VALUE);
        ratePerSecond.addLongIdentifier("rate-per-second", true);
        ratePerSecond.setArgumentGroupName(ToolMessages.INFO_MANAGE_ACCT_ARG_GROUP_PERFORMANCE.get());
        parser.addArgument(ratePerSecond);
        FileArgument variableRateData = new FileArgument(null, ARG_VARIABLE_RATE_DATA, false, 1, null, ToolMessages.INFO_MANAGE_ACCT_ARG_DESC_VARIABLE_RATE_DATA.get(ARG_RATE_PER_SECOND), true, true, true, false);
        variableRateData.addLongIdentifier("variable-rate-data", true);
        variableRateData.setArgumentGroupName(ToolMessages.INFO_MANAGE_ACCT_ARG_GROUP_PERFORMANCE.get());
        parser.addArgument(variableRateData);
        FileArgument generateSampleRateFile = new FileArgument(null, ARG_GENERATE_SAMPLE_RATE_FILE, false, 1, null, ToolMessages.INFO_MANAGE_ACCT_ARG_DESC_GENERATE_SAMPLE_RATE_FILE.get(ARG_VARIABLE_RATE_DATA), false, true, true, false);
        generateSampleRateFile.addLongIdentifier("generate-sample-rate-file", true);
        generateSampleRateFile.setArgumentGroupName(ToolMessages.INFO_MANAGE_ACCT_ARG_GROUP_PERFORMANCE.get());
        generateSampleRateFile.setUsageArgument(true);
        parser.addArgument(generateSampleRateFile);
        FileArgument rejectFile = new FileArgument(Character.valueOf('R'), ARG_REJECT_FILE, false, 1, null, ToolMessages.INFO_MANAGE_ACCT_ARG_DESC_REJECT_FILE.get(), false, true, true, false);
        rejectFile.addLongIdentifier("reject-file", true);
        parser.addArgument(rejectFile);
        BooleanArgument appendToRejectFile = new BooleanArgument(null, ARG_APPEND_TO_REJECT_FILE, 1, ToolMessages.INFO_MANAGE_ACCT_ARG_DESC_APPEND_TO_REJECT_FILE.get(rejectFile.getIdentifierString()));
        appendToRejectFile.addLongIdentifier("append-to-reject-file", true);
        parser.addArgument(appendToRejectFile);
        parser.addDependentArgumentSet(appendToRejectFile, rejectFile, new Argument[0]);
        BooleanArgument suppressEmptyResultOperations = new BooleanArgument(null, ARG_SUPPRESS_EMPTY_RESULT_OPERATIONS, 1, ToolMessages.INFO_MANAGE_ACCT_ARG_DESC_SUPPRESS_EMPTY_RESULT_OPERATIONS.get(this.getToolName()));
        parser.addArgument(suppressEmptyResultOperations);
        this.createSubCommand(ManageAccountSubCommandType.GET_ALL, ToolMessages.INFO_MANAGE_ACCT_SC_GET_ALL_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_PASSWORD_POLICY_DN, ToolMessages.INFO_MANAGE_ACCT_SC_GET_POLICY_DN_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_ACCOUNT_IS_USABLE, ToolMessages.INFO_MANAGE_ACCT_SC_GET_IS_USABLE_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_ACCOUNT_USABILITY_NOTICES, ToolMessages.INFO_MANAGE_ACCT_SC_GET_USABILITY_NOTICES_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_ACCOUNT_USABILITY_WARNINGS, ToolMessages.INFO_MANAGE_ACCT_SC_GET_USABILITY_WARNINGS_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_ACCOUNT_USABILITY_ERRORS, ToolMessages.INFO_MANAGE_ACCT_SC_GET_USABILITY_ERRORS_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_PASSWORD_CHANGED_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_GET_PW_CHANGED_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        ArgumentParser setPWChangedTimeParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.SET_PASSWORD_CHANGED_TIME);
        TimestampArgument setPWChangedTimeValueArg = new TimestampArgument(Character.valueOf('O'), "passwordChangedTime", false, 1, null, ToolMessages.INFO_MANAGE_ACCT_SC_SET_PW_CHANGED_TIME_ARG_VALUE.get());
        setPWChangedTimeValueArg.addLongIdentifier("operationValue", true);
        setPWChangedTimeValueArg.addLongIdentifier("password-changed-time", true);
        setPWChangedTimeValueArg.addLongIdentifier("operation-value", true);
        setPWChangedTimeParser.addArgument(setPWChangedTimeValueArg);
        this.createSubCommand(ManageAccountSubCommandType.SET_PASSWORD_CHANGED_TIME, setPWChangedTimeParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.SET_PASSWORD_CHANGED_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_SET_PW_CHANGED_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN, currentGeneralizedTime), "--passwordChangedTime", currentGeneralizedTime));
        this.createSubCommand(ManageAccountSubCommandType.CLEAR_PASSWORD_CHANGED_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_CLEAR_PW_CHANGED_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_ACCOUNT_IS_DISABLED, ToolMessages.INFO_MANAGE_ACCT_SC_GET_IS_DISABLED_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        ArgumentParser setAcctDisabledParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.SET_ACCOUNT_IS_DISABLED);
        BooleanValueArgument setAcctDisabledValueArg = new BooleanValueArgument(Character.valueOf('O'), "accountIsDisabled", true, null, ToolMessages.INFO_MANAGE_ACCT_SC_SET_IS_DISABLED_ARG_VALUE.get());
        setAcctDisabledValueArg.addLongIdentifier("operationValue", true);
        setAcctDisabledValueArg.addLongIdentifier("account-is-disabled", true);
        setAcctDisabledValueArg.addLongIdentifier("operation-value", true);
        setAcctDisabledParser.addArgument(setAcctDisabledValueArg);
        this.createSubCommand(ManageAccountSubCommandType.SET_ACCOUNT_IS_DISABLED, setAcctDisabledParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.SET_ACCOUNT_IS_DISABLED, ToolMessages.INFO_MANAGE_ACCT_SC_SET_IS_DISABLED_EXAMPLE.get(EXAMPLE_TARGET_USER_DN), "--accountIsDisabled", "true"));
        this.createSubCommand(ManageAccountSubCommandType.CLEAR_ACCOUNT_IS_DISABLED, ToolMessages.INFO_MANAGE_ACCT_SC_CLEAR_IS_DISABLED_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_ACCOUNT_ACTIVATION_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_GET_ACCT_ACT_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        ArgumentParser setAcctActivationTimeParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.SET_ACCOUNT_ACTIVATION_TIME);
        TimestampArgument setAcctActivationTimeValueArg = new TimestampArgument(Character.valueOf('O'), "accountActivationTime", false, 1, null, ToolMessages.INFO_MANAGE_ACCT_SC_SET_ACCT_ACT_TIME_ARG_VALUE.get());
        setAcctActivationTimeValueArg.addLongIdentifier("operationValue", true);
        setAcctActivationTimeValueArg.addLongIdentifier("account-activation-time", true);
        setAcctActivationTimeValueArg.addLongIdentifier("operation-value", true);
        setAcctActivationTimeParser.addArgument(setAcctActivationTimeValueArg);
        this.createSubCommand(ManageAccountSubCommandType.SET_ACCOUNT_ACTIVATION_TIME, setAcctActivationTimeParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.SET_ACCOUNT_ACTIVATION_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_SET_ACCT_ACT_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN, currentGeneralizedTime), "--accountActivationTime", currentGeneralizedTime));
        this.createSubCommand(ManageAccountSubCommandType.CLEAR_ACCOUNT_ACTIVATION_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_CLEAR_ACCT_ACT_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_SECONDS_UNTIL_ACCOUNT_ACTIVATION, ToolMessages.INFO_MANAGE_ACCT_SC_GET_SECONDS_UNTIL_ACCT_ACT_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_ACCOUNT_IS_NOT_YET_ACTIVE, ToolMessages.INFO_MANAGE_ACCT_SC_GET_ACCT_NOT_YET_ACTIVE_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_ACCOUNT_EXPIRATION_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_GET_ACCT_EXP_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        ArgumentParser setAcctExpirationTimeParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.SET_ACCOUNT_EXPIRATION_TIME);
        TimestampArgument setAcctExpirationTimeValueArg = new TimestampArgument(Character.valueOf('O'), "accountExpirationTime", false, 1, null, ToolMessages.INFO_MANAGE_ACCT_SC_SET_ACCT_EXP_TIME_ARG_VALUE.get());
        setAcctExpirationTimeValueArg.addLongIdentifier("operationValue", true);
        setAcctExpirationTimeValueArg.addLongIdentifier("account-expiration-time", true);
        setAcctExpirationTimeValueArg.addLongIdentifier("operation-value", true);
        setAcctExpirationTimeParser.addArgument(setAcctExpirationTimeValueArg);
        this.createSubCommand(ManageAccountSubCommandType.SET_ACCOUNT_EXPIRATION_TIME, setAcctExpirationTimeParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.SET_ACCOUNT_EXPIRATION_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_SET_ACCT_EXP_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN, currentGeneralizedTime), "--accountExpirationTime", currentGeneralizedTime));
        this.createSubCommand(ManageAccountSubCommandType.CLEAR_ACCOUNT_EXPIRATION_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_CLEAR_ACCT_EXP_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_SECONDS_UNTIL_ACCOUNT_EXPIRATION, ToolMessages.INFO_MANAGE_ACCT_SC_GET_SECONDS_UNTIL_ACCT_EXP_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_ACCOUNT_IS_EXPIRED, ToolMessages.INFO_MANAGE_ACCT_SC_GET_ACCT_IS_EXPIRED_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_PASSWORD_EXPIRATION_WARNED_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_GET_PW_EXP_WARNED_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        ArgumentParser setPWExpWarnedTimeParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.SET_PASSWORD_EXPIRATION_WARNED_TIME);
        TimestampArgument setPWExpWarnedTimeValueArg = new TimestampArgument(Character.valueOf('O'), "passwordExpirationWarnedTime", false, 1, null, ToolMessages.INFO_MANAGE_ACCT_SC_SET_PW_EXP_WARNED_TIME_ARG_VALUE.get());
        setPWExpWarnedTimeValueArg.addLongIdentifier("operationValue", true);
        setPWExpWarnedTimeValueArg.addLongIdentifier("password-expiration-warned-time", true);
        setPWExpWarnedTimeValueArg.addLongIdentifier("operation-value", true);
        setPWExpWarnedTimeParser.addArgument(setPWExpWarnedTimeValueArg);
        this.createSubCommand(ManageAccountSubCommandType.SET_PASSWORD_EXPIRATION_WARNED_TIME, setPWExpWarnedTimeParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.SET_PASSWORD_EXPIRATION_WARNED_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_SET_PW_EXP_WARNED_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN, currentGeneralizedTime), "--passwordExpirationWarnedTime", currentGeneralizedTime));
        this.createSubCommand(ManageAccountSubCommandType.CLEAR_PASSWORD_EXPIRATION_WARNED_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_CLEAR_PW_EXP_WARNED_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_SECONDS_UNTIL_PASSWORD_EXPIRATION_WARNING, ToolMessages.INFO_MANAGE_ACCT_SC_GET_SECONDS_UNTIL_PW_EXP_WARNING_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_PASSWORD_EXPIRATION_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_GET_PW_EXP_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_SECONDS_UNTIL_PASSWORD_EXPIRATION, ToolMessages.INFO_MANAGE_ACCT_SC_GET_SECONDS_UNTIL_PW_EXP_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_PASSWORD_IS_EXPIRED, ToolMessages.INFO_MANAGE_ACCT_SC_GET_PW_IS_EXPIRED_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_ACCOUNT_IS_FAILURE_LOCKED, ToolMessages.INFO_MANAGE_ACCT_SC_GET_ACCT_FAILURE_LOCKED_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        ArgumentParser setIsFailureLockedParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.SET_ACCOUNT_IS_FAILURE_LOCKED);
        BooleanValueArgument setIsFailureLockedValueArg = new BooleanValueArgument(Character.valueOf('O'), "accountIsFailureLocked", true, null, ToolMessages.INFO_MANAGE_ACCT_SC_SET_ACCT_FAILURE_LOCKED_ARG_VALUE.get());
        setIsFailureLockedValueArg.addLongIdentifier("operationValue", true);
        setIsFailureLockedValueArg.addLongIdentifier("account-is-failure-locked", true);
        setIsFailureLockedValueArg.addLongIdentifier("operation-value", true);
        setIsFailureLockedParser.addArgument(setIsFailureLockedValueArg);
        this.createSubCommand(ManageAccountSubCommandType.SET_ACCOUNT_IS_FAILURE_LOCKED, setIsFailureLockedParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.SET_ACCOUNT_IS_FAILURE_LOCKED, ToolMessages.INFO_MANAGE_ACCT_SC_SET_ACCT_FAILURE_LOCKED_EXAMPLE.get(EXAMPLE_TARGET_USER_DN), "--accountIsFailureLocked", "true"));
        this.createSubCommand(ManageAccountSubCommandType.GET_FAILURE_LOCKOUT_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_GET_FAILURE_LOCKED_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_SECONDS_UNTIL_AUTHENTICATION_FAILURE_UNLOCK, ToolMessages.INFO_MANAGE_ACCT_SC_GET_SECONDS_UNTIL_FAILURE_UNLOCK_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_AUTHENTICATION_FAILURE_TIMES, ToolMessages.INFO_MANAGE_ACCT_SC_GET_AUTH_FAILURE_TIMES_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        ArgumentParser addAuthFailureTimeParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.ADD_AUTHENTICATION_FAILURE_TIME);
        TimestampArgument addAuthFailureTimeValueArg = new TimestampArgument(Character.valueOf('O'), "authenticationFailureTime", false, 0, null, ToolMessages.INFO_MANAGE_ACCT_SC_ADD_AUTH_FAILURE_TIME_ARG_VALUE.get());
        addAuthFailureTimeValueArg.addLongIdentifier("operationValue", true);
        addAuthFailureTimeValueArg.addLongIdentifier("authentication-failure-time", true);
        addAuthFailureTimeValueArg.addLongIdentifier("operation-value", true);
        addAuthFailureTimeParser.addArgument(addAuthFailureTimeValueArg);
        this.createSubCommand(ManageAccountSubCommandType.ADD_AUTHENTICATION_FAILURE_TIME, addAuthFailureTimeParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.ADD_AUTHENTICATION_FAILURE_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_ADD_AUTH_FAILURE_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN), new String[0]));
        ArgumentParser setAuthFailureTimesParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.SET_AUTHENTICATION_FAILURE_TIMES);
        TimestampArgument setAuthFailureTimesValueArg = new TimestampArgument(Character.valueOf('O'), "authenticationFailureTime", false, 0, null, ToolMessages.INFO_MANAGE_ACCT_SC_SET_AUTH_FAILURE_TIMES_ARG_VALUE.get());
        setAuthFailureTimesValueArg.addLongIdentifier("operationValue", true);
        setAuthFailureTimesValueArg.addLongIdentifier("authentication-failure-time", true);
        setAuthFailureTimesValueArg.addLongIdentifier("operation-value", true);
        setAuthFailureTimesParser.addArgument(setAuthFailureTimesValueArg);
        this.createSubCommand(ManageAccountSubCommandType.SET_AUTHENTICATION_FAILURE_TIMES, setAuthFailureTimesParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.SET_AUTHENTICATION_FAILURE_TIMES, ToolMessages.INFO_MANAGE_ACCT_SC_SET_AUTH_FAILURE_TIMES_EXAMPLE.get(EXAMPLE_TARGET_USER_DN, olderGeneralizedTime, currentGeneralizedTime), "--authenticationFailureTime", olderGeneralizedTime, "--authenticationFailureTime", currentGeneralizedTime));
        this.createSubCommand(ManageAccountSubCommandType.CLEAR_AUTHENTICATION_FAILURE_TIMES, ToolMessages.INFO_MANAGE_ACCT_SC_CLEAR_AUTH_FAILURE_TIMES_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_REMAINING_AUTHENTICATION_FAILURE_COUNT, ToolMessages.INFO_MANAGE_ACCT_SC_GET_REMAINING_FAILURE_COUNT_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_ACCOUNT_IS_IDLE_LOCKED, ToolMessages.INFO_MANAGE_ACCT_SC_GET_ACCT_IDLE_LOCKED_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_SECONDS_UNTIL_IDLE_LOCKOUT, ToolMessages.INFO_MANAGE_ACCT_SC_GET_SECONDS_UNTIL_IDLE_LOCKOUT_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_IDLE_LOCKOUT_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_GET_IDLE_LOCKOUT_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_MUST_CHANGE_PASSWORD, ToolMessages.INFO_MANAGE_ACCT_SC_GET_MUST_CHANGE_PW_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        ArgumentParser setPWIsResetParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.SET_MUST_CHANGE_PASSWORD);
        BooleanValueArgument setPWIsResetValueArg = new BooleanValueArgument(Character.valueOf('O'), "mustChangePassword", true, null, ToolMessages.INFO_MANAGE_ACCT_SC_SET_MUST_CHANGE_PW_ARG_VALUE.get());
        setPWIsResetValueArg.addLongIdentifier("passwordIsReset", true);
        setPWIsResetValueArg.addLongIdentifier("operationValue", true);
        setPWIsResetValueArg.addLongIdentifier("must-change-password", true);
        setPWIsResetValueArg.addLongIdentifier("password-is-reset", true);
        setPWIsResetValueArg.addLongIdentifier("operation-value", true);
        setPWIsResetParser.addArgument(setPWIsResetValueArg);
        this.createSubCommand(ManageAccountSubCommandType.SET_MUST_CHANGE_PASSWORD, setPWIsResetParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.SET_MUST_CHANGE_PASSWORD, ToolMessages.INFO_MANAGE_ACCT_SC_SET_MUST_CHANGE_PW_EXAMPLE.get(EXAMPLE_TARGET_USER_DN), "--mustChangePassword", "true"));
        this.createSubCommand(ManageAccountSubCommandType.CLEAR_MUST_CHANGE_PASSWORD, ToolMessages.INFO_MANAGE_ACCT_SC_CLEAR_MUST_CHANGE_PW_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_ACCOUNT_IS_PASSWORD_RESET_LOCKED, ToolMessages.INFO_MANAGE_ACCT_SC_GET_ACCT_IS_RESET_LOCKED_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_SECONDS_UNTIL_PASSWORD_RESET_LOCKOUT, ToolMessages.INFO_MANAGE_ACCT_SC_GET_SECONDS_UNTIL_RESET_LOCKOUT_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_PASSWORD_RESET_LOCKOUT_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_GET_RESET_LOCKOUT_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_LAST_LOGIN_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_GET_LAST_LOGIN_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        ArgumentParser setLastLoginTimeParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.SET_LAST_LOGIN_TIME);
        TimestampArgument setLastLoginTimeValueArg = new TimestampArgument(Character.valueOf('O'), "lastLoginTime", false, 1, null, ToolMessages.INFO_MANAGE_ACCT_SC_SET_LAST_LOGIN_TIME_ARG_VALUE.get());
        setLastLoginTimeValueArg.addLongIdentifier("operationValue", true);
        setLastLoginTimeValueArg.addLongIdentifier("last-login-time", true);
        setLastLoginTimeValueArg.addLongIdentifier("operation-value", true);
        setLastLoginTimeParser.addArgument(setLastLoginTimeValueArg);
        this.createSubCommand(ManageAccountSubCommandType.SET_LAST_LOGIN_TIME, setLastLoginTimeParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.SET_LAST_LOGIN_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_SET_LAST_LOGIN_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN, currentGeneralizedTime), "--lastLoginTime", currentGeneralizedTime));
        this.createSubCommand(ManageAccountSubCommandType.CLEAR_LAST_LOGIN_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_CLEAR_LAST_LOGIN_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_LAST_LOGIN_IP_ADDRESS, ToolMessages.INFO_MANAGE_ACCT_SC_GET_LAST_LOGIN_IP_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        ArgumentParser setLastLoginIPParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.SET_LAST_LOGIN_IP_ADDRESS);
        StringArgument setLastLoginIPValueArg = new StringArgument(Character.valueOf('O'), "lastLoginIPAddress", true, 1, null, ToolMessages.INFO_MANAGE_ACCT_SC_SET_LAST_LOGIN_IP_ARG_VALUE.get());
        setLastLoginIPValueArg.addLongIdentifier("operationValue", true);
        setLastLoginIPValueArg.addLongIdentifier("last-login-ip-address", true);
        setLastLoginIPValueArg.addLongIdentifier("operation-value", true);
        setLastLoginIPValueArg.addValueValidator(new IPAddressArgumentValueValidator());
        setLastLoginIPParser.addArgument(setLastLoginIPValueArg);
        this.createSubCommand(ManageAccountSubCommandType.SET_LAST_LOGIN_IP_ADDRESS, setLastLoginIPParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.SET_LAST_LOGIN_IP_ADDRESS, ToolMessages.INFO_MANAGE_ACCT_SC_SET_LAST_LOGIN_IP_EXAMPLE.get(EXAMPLE_TARGET_USER_DN, "1.2.3.4"), "--lastLoginIPAddress", "1.2.3.4"));
        this.createSubCommand(ManageAccountSubCommandType.CLEAR_LAST_LOGIN_IP_ADDRESS, ToolMessages.INFO_MANAGE_ACCT_SC_CLEAR_LAST_LOGIN_IP_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_GRACE_LOGIN_USE_TIMES, ToolMessages.INFO_MANAGE_ACCT_SC_GET_GRACE_LOGIN_TIMES_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        ArgumentParser addGraceLoginTimeParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.ADD_GRACE_LOGIN_USE_TIME);
        TimestampArgument addGraceLoginTimeValueArg = new TimestampArgument(Character.valueOf('O'), "graceLoginUseTime", false, 0, null, ToolMessages.INFO_MANAGE_ACCT_SC_ADD_GRACE_LOGIN_TIME_ARG_VALUE.get());
        addGraceLoginTimeValueArg.addLongIdentifier("operationValue", true);
        addGraceLoginTimeValueArg.addLongIdentifier("grace-login-use-time", true);
        addGraceLoginTimeValueArg.addLongIdentifier("operation-value", true);
        addGraceLoginTimeParser.addArgument(addGraceLoginTimeValueArg);
        this.createSubCommand(ManageAccountSubCommandType.ADD_GRACE_LOGIN_USE_TIME, addGraceLoginTimeParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.ADD_GRACE_LOGIN_USE_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_ADD_GRACE_LOGIN_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN), new String[0]));
        ArgumentParser setGraceLoginTimesParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.SET_GRACE_LOGIN_USE_TIMES);
        TimestampArgument setGraceLoginTimesValueArg = new TimestampArgument(Character.valueOf('O'), "graceLoginUseTime", false, 0, null, ToolMessages.INFO_MANAGE_ACCT_SC_SET_GRACE_LOGIN_TIMES_ARG_VALUE.get());
        setGraceLoginTimesValueArg.addLongIdentifier("operationValue", true);
        setGraceLoginTimesValueArg.addLongIdentifier("grace-login-use-time", true);
        setGraceLoginTimesValueArg.addLongIdentifier("operation-value", true);
        setGraceLoginTimesParser.addArgument(setGraceLoginTimesValueArg);
        this.createSubCommand(ManageAccountSubCommandType.SET_GRACE_LOGIN_USE_TIMES, setGraceLoginTimesParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.SET_GRACE_LOGIN_USE_TIMES, ToolMessages.INFO_MANAGE_ACCT_SC_SET_GRACE_LOGIN_TIMES_EXAMPLE.get(EXAMPLE_TARGET_USER_DN, olderGeneralizedTime, currentGeneralizedTime), "--graceLoginUseTime", olderGeneralizedTime, "--graceLoginUseTime", currentGeneralizedTime));
        this.createSubCommand(ManageAccountSubCommandType.CLEAR_GRACE_LOGIN_USE_TIMES, ToolMessages.INFO_MANAGE_ACCT_SC_CLEAR_GRACE_LOGIN_TIMES_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_REMAINING_GRACE_LOGIN_COUNT, ToolMessages.INFO_MANAGE_ACCT_SC_GET_REMAINING_GRACE_LOGIN_COUNT_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_PASSWORD_CHANGED_BY_REQUIRED_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_GET_PW_CHANGED_BY_REQ_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        ArgumentParser setPWChangedByReqTimeParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.SET_PASSWORD_CHANGED_BY_REQUIRED_TIME);
        TimestampArgument setPWChangedByReqTimeValueArg = new TimestampArgument(Character.valueOf('O'), "passwordChangedByRequiredTime", false, 1, null, ToolMessages.INFO_MANAGE_ACCT_SC_SET_PW_CHANGED_BY_REQ_TIME_ARG_VALUE.get());
        setPWChangedByReqTimeValueArg.addLongIdentifier("operationValue", true);
        setPWChangedByReqTimeValueArg.addLongIdentifier("password-changed-by-required-time", true);
        setPWChangedByReqTimeValueArg.addLongIdentifier("operation-value", true);
        setPWChangedByReqTimeParser.addArgument(setPWChangedByReqTimeValueArg);
        this.createSubCommand(ManageAccountSubCommandType.SET_PASSWORD_CHANGED_BY_REQUIRED_TIME, setPWChangedByReqTimeParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.SET_PASSWORD_CHANGED_BY_REQUIRED_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_SET_PW_CHANGED_BY_REQ_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN), new String[0]));
        this.createSubCommand(ManageAccountSubCommandType.CLEAR_PASSWORD_CHANGED_BY_REQUIRED_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_CLEAR_PW_CHANGED_BY_REQ_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_SECONDS_UNTIL_REQUIRED_PASSWORD_CHANGE_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_GET_SECS_UNTIL_REQ_CHANGE_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_PASSWORD_HISTORY_COUNT, ToolMessages.INFO_MANAGE_ACCT_SC_GET_PW_HISTORY_COUNT_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.CLEAR_PASSWORD_HISTORY, ToolMessages.INFO_MANAGE_ACCT_SC_CLEAR_PW_HISTORY_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_HAS_RETIRED_PASSWORD, ToolMessages.INFO_MANAGE_ACCT_SC_GET_HAS_RETIRED_PW_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_PASSWORD_RETIRED_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_GET_PW_RETIRED_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_RETIRED_PASSWORD_EXPIRATION_TIME, ToolMessages.INFO_MANAGE_ACCT_SC_GET_RETIRED_PW_EXP_TIME_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.CLEAR_RETIRED_PASSWORD, ToolMessages.INFO_MANAGE_ACCT_SC_PURGE_RETIRED_PW_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_AVAILABLE_SASL_MECHANISMS, ToolMessages.INFO_MANAGE_ACCT_SC_GET_AVAILABLE_SASL_MECHS_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_AVAILABLE_OTP_DELIVERY_MECHANISMS, ToolMessages.INFO_MANAGE_ACCT_SC_GET_AVAILABLE_OTP_MECHS_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_HAS_TOTP_SHARED_SECRET, ToolMessages.INFO_MANAGE_ACCT_SC_GET_HAS_TOTP_SHARED_SECRET_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        ArgumentParser addTOTPSharedSecretParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.ADD_TOTP_SHARED_SECRET);
        StringArgument addTOTPSharedSecretValueArg = new StringArgument(Character.valueOf('O'), "totpSharedSecret", true, 0, null, ToolMessages.INFO_MANAGE_ACCT_SC_ADD_YUBIKEY_ID_ARG_VALUE.get());
        addTOTPSharedSecretValueArg.addLongIdentifier("operationValue", true);
        addTOTPSharedSecretValueArg.addLongIdentifier("totp-shared-secret", true);
        addTOTPSharedSecretValueArg.addLongIdentifier("operation-value", true);
        addTOTPSharedSecretValueArg.setSensitive(true);
        addTOTPSharedSecretParser.addArgument(addTOTPSharedSecretValueArg);
        this.createSubCommand(ManageAccountSubCommandType.ADD_TOTP_SHARED_SECRET, addTOTPSharedSecretParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.ADD_TOTP_SHARED_SECRET, ToolMessages.INFO_MANAGE_ACCT_SC_ADD_TOTP_SHARED_SECRET_EXAMPLE.get("abcdefghijklmnop", EXAMPLE_TARGET_USER_DN), "--totpSharedSecret", "abcdefghijklmnop"));
        ArgumentParser removeTOTPSharedSecretParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.REMOVE_TOTP_SHARED_SECRET);
        StringArgument removeTOTPSharedSecretValueArg = new StringArgument(Character.valueOf('O'), "totpSharedSecret", true, 0, null, ToolMessages.INFO_MANAGE_ACCT_SC_REMOVE_YUBIKEY_ID_ARG_VALUE.get());
        removeTOTPSharedSecretValueArg.addLongIdentifier("operationValue", true);
        removeTOTPSharedSecretValueArg.addLongIdentifier("totp-shared-secret", true);
        removeTOTPSharedSecretValueArg.addLongIdentifier("operation-value", true);
        removeTOTPSharedSecretValueArg.setSensitive(true);
        removeTOTPSharedSecretParser.addArgument(removeTOTPSharedSecretValueArg);
        this.createSubCommand(ManageAccountSubCommandType.REMOVE_TOTP_SHARED_SECRET, removeTOTPSharedSecretParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.REMOVE_TOTP_SHARED_SECRET, ToolMessages.INFO_MANAGE_ACCT_SC_REMOVE_TOTP_SHARED_SECRET_EXAMPLE.get("abcdefghijklmnop", EXAMPLE_TARGET_USER_DN), "--totpSharedSecret", "abcdefghijklmnop"));
        ArgumentParser setTOTPSharedSecretsParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.SET_TOTP_SHARED_SECRETS);
        StringArgument setTOTPSharedSecretsValueArg = new StringArgument(Character.valueOf('O'), "totpSharedSecret", true, 0, null, ToolMessages.INFO_MANAGE_ACCT_SC_SET_TOTP_SHARED_SECRETS_ARG_VALUE.get());
        setTOTPSharedSecretsValueArg.addLongIdentifier("operationValue", true);
        setTOTPSharedSecretsValueArg.addLongIdentifier("totp-shared-secret", true);
        setTOTPSharedSecretsValueArg.addLongIdentifier("operation-value", true);
        setTOTPSharedSecretsValueArg.setSensitive(true);
        setTOTPSharedSecretsParser.addArgument(setTOTPSharedSecretsValueArg);
        this.createSubCommand(ManageAccountSubCommandType.SET_TOTP_SHARED_SECRETS, setTOTPSharedSecretsParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.SET_TOTP_SHARED_SECRETS, ToolMessages.INFO_MANAGE_ACCT_SC_SET_TOTP_SHARED_SECRETS_EXAMPLE.get(EXAMPLE_TARGET_USER_DN, "abcdefghijklmnop"), "--totpSharedSecret", "abcdefghijklmnop"));
        this.createSubCommand(ManageAccountSubCommandType.CLEAR_TOTP_SHARED_SECRETS, ToolMessages.INFO_MANAGE_ACCT_SC_CLEAR_TOTP_SHARED_SECRETS_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_HAS_REGISTERED_YUBIKEY_PUBLIC_ID, ToolMessages.INFO_MANAGE_ACCT_SC_GET_HAS_YUBIKEY_ID_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_REGISTERED_YUBIKEY_PUBLIC_IDS, ToolMessages.INFO_MANAGE_ACCT_SC_GET_YUBIKEY_IDS_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        ArgumentParser addRegisteredYubiKeyPublicIDParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.ADD_REGISTERED_YUBIKEY_PUBLIC_ID);
        StringArgument addRegisteredYubiKeyPublicIDValueArg = new StringArgument(Character.valueOf('O'), "publicID", true, 0, null, ToolMessages.INFO_MANAGE_ACCT_SC_ADD_YUBIKEY_ID_ARG_VALUE.get());
        addRegisteredYubiKeyPublicIDValueArg.addLongIdentifier("operationValue", true);
        addRegisteredYubiKeyPublicIDValueArg.addLongIdentifier("public-id", true);
        addRegisteredYubiKeyPublicIDValueArg.addLongIdentifier("operation-value", true);
        addRegisteredYubiKeyPublicIDParser.addArgument(addRegisteredYubiKeyPublicIDValueArg);
        this.createSubCommand(ManageAccountSubCommandType.ADD_REGISTERED_YUBIKEY_PUBLIC_ID, addRegisteredYubiKeyPublicIDParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.ADD_REGISTERED_YUBIKEY_PUBLIC_ID, ToolMessages.INFO_MANAGE_ACCT_SC_ADD_YUBIKEY_ID_EXAMPLE.get("abcdefghijkl", EXAMPLE_TARGET_USER_DN), "--publicID", "abcdefghijkl"));
        ArgumentParser removeRegisteredYubiKeyPublicIDParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.REMOVE_REGISTERED_YUBIKEY_PUBLIC_ID);
        StringArgument removeRegisteredYubiKeyPublicIDValueArg = new StringArgument(Character.valueOf('O'), "publicID", true, 0, null, ToolMessages.INFO_MANAGE_ACCT_SC_REMOVE_YUBIKEY_ID_ARG_VALUE.get());
        removeRegisteredYubiKeyPublicIDValueArg.addLongIdentifier("operationValue", true);
        removeRegisteredYubiKeyPublicIDValueArg.addLongIdentifier("public-id", true);
        removeRegisteredYubiKeyPublicIDValueArg.addLongIdentifier("operation-value", true);
        removeRegisteredYubiKeyPublicIDParser.addArgument(removeRegisteredYubiKeyPublicIDValueArg);
        this.createSubCommand(ManageAccountSubCommandType.REMOVE_REGISTERED_YUBIKEY_PUBLIC_ID, removeRegisteredYubiKeyPublicIDParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.REMOVE_REGISTERED_YUBIKEY_PUBLIC_ID, ToolMessages.INFO_MANAGE_ACCT_SC_REMOVE_YUBIKEY_ID_EXAMPLE.get("abcdefghijkl", EXAMPLE_TARGET_USER_DN), "--publicID", "abcdefghijkl"));
        ArgumentParser setRegisteredYubiKeyPublicIDParser = ManageAccount.createSubCommandParser(ManageAccountSubCommandType.SET_REGISTERED_YUBIKEY_PUBLIC_IDS);
        StringArgument setRegisteredYubiKeyPublicIDValueArg = new StringArgument(Character.valueOf('O'), "publicID", true, 0, null, ToolMessages.INFO_MANAGE_ACCT_SC_SET_YUBIKEY_IDS_ARG_VALUE.get());
        setRegisteredYubiKeyPublicIDValueArg.addLongIdentifier("operationValue", true);
        setRegisteredYubiKeyPublicIDValueArg.addLongIdentifier("public-id", true);
        setRegisteredYubiKeyPublicIDValueArg.addLongIdentifier("operation-value", true);
        setRegisteredYubiKeyPublicIDParser.addArgument(setRegisteredYubiKeyPublicIDValueArg);
        this.createSubCommand(ManageAccountSubCommandType.SET_REGISTERED_YUBIKEY_PUBLIC_IDS, setRegisteredYubiKeyPublicIDParser, ManageAccount.createSubCommandExample(ManageAccountSubCommandType.SET_REGISTERED_YUBIKEY_PUBLIC_IDS, ToolMessages.INFO_MANAGE_ACCT_SC_SET_YUBIKEY_IDS_EXAMPLE.get(EXAMPLE_TARGET_USER_DN, "abcdefghijkl"), "--publicID", "abcdefghijkl"));
        this.createSubCommand(ManageAccountSubCommandType.CLEAR_REGISTERED_YUBIKEY_PUBLIC_IDS, ToolMessages.INFO_MANAGE_ACCT_SC_CLEAR_YUBIKEY_IDS_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
        this.createSubCommand(ManageAccountSubCommandType.GET_HAS_STATIC_PASSWORD, ToolMessages.INFO_MANAGE_ACCT_SC_GET_HAS_STATIC_PW_EXAMPLE.get(EXAMPLE_TARGET_USER_DN));
    }

    private static ArgumentParser createSubCommandParser(ManageAccountSubCommandType type) throws ArgumentException {
        return new ArgumentParser(type.getPrimaryName(), type.getDescription());
    }

    private static LinkedHashMap<String[], String> createSubCommandExample(ManageAccountSubCommandType t, String description, String ... args) {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(1));
        ManageAccount.createSubCommandExample(examples, t, description, args);
        return examples;
    }

    private static void createSubCommandExample(LinkedHashMap<String[], String> examples, ManageAccountSubCommandType t, String description, String ... args) {
        ArrayList<String> argList = new ArrayList<String>(10 + args.length);
        argList.add(t.getPrimaryName());
        argList.add("--hostname");
        argList.add("server.example.com");
        argList.add("--port");
        argList.add("389");
        argList.add("--bindDN");
        argList.add("uid=admin,dc=example,dc=com");
        argList.add("--promptForBindPassword");
        argList.add("--targetDN");
        argList.add(EXAMPLE_TARGET_USER_DN);
        if (args.length > 0) {
            argList.addAll(Arrays.asList(args));
        }
        String[] argArray = new String[argList.size()];
        argList.toArray(argArray);
        examples.put(argArray, description);
    }

    private void createSubCommand(ManageAccountSubCommandType subcommandType, String exampleDescription) throws ArgumentException {
        ArgumentParser subcommandParser = ManageAccount.createSubCommandParser(subcommandType);
        LinkedHashMap<String[], String> examples = ManageAccount.createSubCommandExample(subcommandType, exampleDescription, new String[0]);
        this.createSubCommand(subcommandType, subcommandParser, examples);
    }

    private void createSubCommand(ManageAccountSubCommandType subcommandType, ArgumentParser subcommandParser, LinkedHashMap<String[], String> examples) throws ArgumentException {
        SubCommand subCommand = new SubCommand(subcommandType.getPrimaryName(), subcommandType.getDescription(), subcommandParser, examples);
        for (String alternateName : subcommandType.getAlternateNames()) {
            subCommand.addName(alternateName, true);
        }
        this.parser.addSubCommand(subCommand);
    }

    @Override
    public LDAPConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCode doToolProcessing() {
        LDAPConnectionPool pool;
        FileArgument generateSampleRateFile = this.parser.getFileArgument(ARG_GENERATE_SAMPLE_RATE_FILE);
        if (generateSampleRateFile.isPresent()) {
            try {
                RateAdjustor.writeSampleVariableRateFile(generateSampleRateFile.getValue());
                return ResultCode.SUCCESS;
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, ToolMessages.ERR_MANAGE_ACCT_CANNOT_GENERATE_SAMPLE_RATE_FILE.get(generateSampleRateFile.getValue().getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
                return ResultCode.LOCAL_ERROR;
            }
        }
        IntegerArgument ratePerSecond = this.parser.getIntegerArgument(ARG_RATE_PER_SECOND);
        FileArgument variableRateData = this.parser.getFileArgument(ARG_VARIABLE_RATE_DATA);
        if (ratePerSecond.isPresent() || variableRateData.isPresent()) {
            this.rateLimiter = ratePerSecond.isPresent() ? new FixedRateBarrier(1000L, ratePerSecond.getValue()) : new FixedRateBarrier(1000L, Integer.MAX_VALUE);
            if (variableRateData.isPresent()) {
                try {
                    this.rateAdjustor = RateAdjustor.newInstance(this.rateLimiter, ratePerSecond.getValue(), variableRateData.getValue());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.wrapErr(0, WRAP_COLUMN, ToolMessages.ERR_MANAGE_ACCT_CANNOT_CREATE_RATE_ADJUSTOR.get(variableRateData.getValue().getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
                    return ResultCode.PARAM_ERROR;
                }
            }
        }
        int numSearchThreads = this.parser.getIntegerArgument(ARG_NUM_SEARCH_THREADS).getValue();
        try {
            int numOperationThreads = this.parser.getIntegerArgument(ARG_NUM_THREADS).getValue();
            pool = this.getConnectionPool(numOperationThreads, numOperationThreads + numSearchThreads);
            pool.setRetryFailedOperationsDueToInvalidConnections(false);
            pool.setMaxConnectionAgeMillis(1800000L);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, ToolMessages.ERR_MANAGE_ACCT_CANNOT_CREATE_CONNECTION_POOL.get(this.getToolName(), le.getMessage()));
            return le.getResultCode();
        }
        try {
            FileArgument userIDInputFile;
            StringArgument targetUserID;
            FileArgument filterInputFile;
            FilterArgument targetFilter;
            FileArgument dnInputFile;
            DNArgument targetDN;
            ManageAccountProcessor processor;
            this.outputWriter = new LDIFWriter(this.getOut());
            FileArgument rejectFile = this.parser.getFileArgument(ARG_REJECT_FILE);
            if (rejectFile.isPresent()) {
                BooleanArgument appendToRejectFile = this.parser.getBooleanArgument(ARG_APPEND_TO_REJECT_FILE);
                try {
                    this.rejectWriter = new LDIFWriter(new FileOutputStream(rejectFile.getValue(), appendToRejectFile.isPresent()));
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.wrapErr(0, WRAP_COLUMN, ToolMessages.ERR_MANAGE_ACCT_CANNOT_CREATE_REJECT_WRITER.get(rejectFile.getValue().getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
                    ResultCode resultCode = ResultCode.LOCAL_ERROR;
                    pool.close();
                    if (this.rejectWriter != null) {
                        try {
                            this.rejectWriter.close();
                        }
                        catch (Exception e2) {
                            Debug.debugException(e2);
                        }
                    }
                    return resultCode;
                }
            }
            try {
                processor = new ManageAccountProcessor(this, pool, this.rateLimiter, this.outputWriter, this.rejectWriter);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.wrapErr(0, WRAP_COLUMN, ToolMessages.ERR_MANAGE_ACCT_CANNOT_CREATE_PROCESSOR.get(StaticUtils.getExceptionMessage(le)));
                ResultCode resultCode = le.getResultCode();
                pool.close();
                if (this.rejectWriter != null) {
                    try {
                        this.rejectWriter.close();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                }
                return resultCode;
            }
            if (this.rateAdjustor != null) {
                this.rateAdjustor.start();
            }
            if ((targetDN = this.parser.getDNArgument(ARG_TARGET_DN)).isPresent()) {
                for (DN dn : targetDN.getValues()) {
                    if (this.cancelRequested()) {
                        ResultCode resultCode = ResultCode.USER_CANCELED;
                        return resultCode;
                    }
                    processor.process(dn.toString());
                }
            }
            if ((dnInputFile = this.parser.getFileArgument(ARG_DN_INPUT_FILE)).isPresent()) {
                block82: for (File f : dnInputFile.getValues()) {
                    DNFileReader reader = null;
                    try {
                        reader = new DNFileReader(f);
                        while (true) {
                            DN dn;
                            if (this.cancelRequested()) {
                                ResultCode resultCode = ResultCode.USER_CANCELED;
                                return resultCode;
                            }
                            try {
                                dn = reader.readDN();
                            }
                            catch (LDAPException le) {
                                Debug.debugException(le);
                                processor.handleMessage(le.getMessage(), true);
                                continue;
                            }
                            if (dn == null) continue block82;
                            processor.process(dn.toString());
                        }
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        processor.handleMessage(ToolMessages.ERR_MANAGE_ACCT_ERROR_READING_DN_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), true);
                    }
                    finally {
                        if (reader == null) continue;
                        try {
                            reader.close();
                        }
                        catch (Exception e2) {
                            Debug.debugException(e2);
                        }
                    }
                }
            }
            if ((targetFilter = this.parser.getFilterArgument(ARG_TARGET_FILTER)).isPresent()) {
                this.searchProcessor = new ManageAccountSearchProcessor(this, processor, pool);
                for (Filter f : targetFilter.getValues()) {
                    this.searchProcessor.processFilter(f);
                }
            }
            if ((filterInputFile = this.parser.getFileArgument(ARG_FILTER_INPUT_FILE)).isPresent()) {
                if (this.searchProcessor == null) {
                    this.searchProcessor = new ManageAccountSearchProcessor(this, processor, pool);
                }
                block85: for (File f : filterInputFile.getValues()) {
                    FilterFileReader reader = null;
                    try {
                        reader = new FilterFileReader(f);
                        while (true) {
                            Filter filter;
                            if (this.cancelRequested()) {
                                ResultCode resultCode = ResultCode.USER_CANCELED;
                                return resultCode;
                            }
                            try {
                                filter = reader.readFilter();
                            }
                            catch (LDAPException le) {
                                Debug.debugException(le);
                                processor.handleMessage(le.getMessage(), true);
                                continue;
                            }
                            if (filter == null) continue block85;
                            this.searchProcessor.processFilter(filter);
                        }
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        processor.handleMessage(ToolMessages.ERR_MANAGE_ACCT_ERROR_READING_FILTER_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), true);
                    }
                    finally {
                        if (reader == null) continue;
                        try {
                            reader.close();
                        }
                        catch (Exception e2) {
                            Debug.debugException(e2);
                        }
                    }
                }
            }
            if ((targetUserID = this.parser.getStringArgument(ARG_TARGET_USER_ID)).isPresent()) {
                if (this.searchProcessor == null) {
                    this.searchProcessor = new ManageAccountSearchProcessor(this, processor, pool);
                }
                for (String userID : targetUserID.getValues()) {
                    this.searchProcessor.processUserID(userID);
                }
            }
            if ((userIDInputFile = this.parser.getFileArgument(ARG_USER_ID_INPUT_FILE)).isPresent()) {
                if (this.searchProcessor == null) {
                    this.searchProcessor = new ManageAccountSearchProcessor(this, processor, pool);
                }
                block88: for (File f : userIDInputFile.getValues()) {
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(new FileReader(f));
                        while (true) {
                            if (this.cancelRequested()) {
                                ResultCode resultCode = ResultCode.USER_CANCELED;
                                return resultCode;
                            }
                            String line = reader.readLine();
                            if (line == null) continue block88;
                            if (line.length() == 0 || line.startsWith("#")) continue;
                            this.searchProcessor.processUserID(line.trim());
                        }
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        processor.handleMessage(ToolMessages.ERR_MANAGE_ACCT_ERROR_READING_USER_ID_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), true);
                    }
                    finally {
                        if (reader == null) continue;
                        try {
                            reader.close();
                        }
                        catch (Exception e2) {
                            Debug.debugException(e2);
                        }
                    }
                }
            }
            this.allFiltersProvided.set(true);
            if (this.searchProcessor != null) {
                this.searchProcessor.waitForCompletion();
            }
            this.allDNsProvided.set(true);
            processor.waitForCompletion();
        }
        finally {
            pool.close();
            if (this.rejectWriter != null) {
                try {
                    this.rejectWriter.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        return ResultCode.SUCCESS;
    }

    ArgumentParser getArgumentParser() {
        return this.parser;
    }

    boolean cancelRequested() {
        return this.cancelRequested.get();
    }

    boolean allDNsProvided() {
        return this.allDNsProvided.get();
    }

    boolean allFiltersProvided() {
        return this.allFiltersProvided.get();
    }

    @Override
    protected boolean registerShutdownHook() {
        return true;
    }

    @Override
    protected void doShutdownHookProcessing(ResultCode resultCode) {
        this.cancelRequested.set(true);
        if (this.rateLimiter != null) {
            this.rateLimiter.shutdownRequested();
        }
        if (this.searchProcessor != null) {
            this.searchProcessor.cancelSearches();
        }
    }

    @Override
    public void handleUnsolicitedNotification(LDAPConnection connection, ExtendedResult notification) {
        String message = ToolMessages.NOTE_MANAGE_ACCT_UNSOLICITED_NOTIFICATION.get(String.valueOf(connection), String.valueOf(notification));
        if (this.outputWriter == null) {
            this.err(new Object[0]);
            this.err("* " + message);
            this.err(new Object[0]);
        } else {
            try {
                this.outputWriter.writeComment(message, true, true);
                this.outputWriter.flush();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(4));
        ManageAccount.createSubCommandExample(examples, ManageAccountSubCommandType.GET_ALL, ToolMessages.INFO_MANAGE_ACCT_SC_GET_ALL_EXAMPLE.get(EXAMPLE_TARGET_USER_DN), new String[0]);
        ManageAccount.createSubCommandExample(examples, ManageAccountSubCommandType.GET_ACCOUNT_USABILITY_ERRORS, ToolMessages.INFO_MANAGE_ACCT_SC_GET_USABILITY_ERRORS_EXAMPLE.get(EXAMPLE_TARGET_USER_DN), new String[0]);
        ManageAccount.createSubCommandExample(examples, ManageAccountSubCommandType.SET_ACCOUNT_IS_DISABLED, ToolMessages.INFO_MANAGE_ACCT_SC_SET_IS_DISABLED_EXAMPLE.get(EXAMPLE_TARGET_USER_DN), "--accountIsDisabled", "true");
        ManageAccount.createSubCommandExample(examples, ManageAccountSubCommandType.CLEAR_AUTHENTICATION_FAILURE_TIMES, ToolMessages.INFO_MANAGE_ACCT_SC_CLEAR_AUTH_FAILURE_TIMES_EXAMPLE.get(EXAMPLE_TARGET_USER_DN), new String[0]);
        return examples;
    }
}

