/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.LDAPBindException;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheckThread;
import com.unboundid.ldap.sdk.LDAPConnectionPoolStatistics;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ParallelPoolCloser;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.SingleServerSet;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPThreadLocalConnectionPool
extends AbstractConnectionPool {
    private static final long DEFAULT_HEALTH_CHECK_INTERVAL = 60000L;
    private final AtomicReference<Set<OperationType>> retryOperationTypes;
    private volatile boolean closed;
    private final BindRequest bindRequest;
    private final ConcurrentHashMap<Thread, LDAPConnection> connections;
    private LDAPConnectionPoolHealthCheck healthCheck;
    private final LDAPConnectionPoolHealthCheckThread healthCheckThread;
    private final LDAPConnectionPoolStatistics poolStatistics;
    private volatile long healthCheckInterval;
    private volatile long lastExpiredDisconnectTime;
    private volatile long maxConnectionAge;
    private volatile long minDisconnectInterval;
    private volatile ObjectPair<Long, Schema> pooledSchema;
    private final PostConnectProcessor postConnectProcessor;
    private final ServerSet serverSet;
    private String connectionPoolName;

    public LDAPThreadLocalConnectionPool(LDAPConnection connection) throws LDAPException {
        this(connection, null);
    }

    public LDAPThreadLocalConnectionPool(LDAPConnection connection, PostConnectProcessor postConnectProcessor) throws LDAPException {
        Validator.ensureNotNull(connection);
        this.postConnectProcessor = null;
        this.healthCheck = new LDAPConnectionPoolHealthCheck();
        this.healthCheckInterval = 60000L;
        this.poolStatistics = new LDAPConnectionPoolStatistics(this);
        this.connectionPoolName = null;
        this.retryOperationTypes = new AtomicReference<Set<OperationType>>(Collections.unmodifiableSet(EnumSet.noneOf(OperationType.class)));
        if (!connection.isConnected()) {
            throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_POOL_CONN_NOT_ESTABLISHED.get());
        }
        this.bindRequest = connection.getLastBindRequest();
        this.serverSet = new SingleServerSet(connection.getConnectedAddress(), connection.getConnectedPort(), connection.getLastUsedSocketFactory(), connection.getConnectionOptions(), this.bindRequest, postConnectProcessor);
        this.connections = new ConcurrentHashMap();
        this.connections.put(Thread.currentThread(), connection);
        this.lastExpiredDisconnectTime = 0L;
        this.maxConnectionAge = 0L;
        this.closed = false;
        this.minDisconnectInterval = 0L;
        this.healthCheckThread = new LDAPConnectionPoolHealthCheckThread(this);
        this.healthCheckThread.start();
        LDAPConnectionOptions opts = connection.getConnectionOptions();
        if (opts.usePooledSchema()) {
            try {
                Schema schema = connection.getSchema();
                if (schema != null) {
                    connection.setCachedSchema(schema);
                    long currentTime = System.currentTimeMillis();
                    long timeout = opts.getPooledSchemaTimeoutMillis();
                    this.pooledSchema = timeout <= 0L || timeout + currentTime <= 0L ? new ObjectPair<Long, Schema>(Long.MAX_VALUE, schema) : new ObjectPair<Long, Schema>(timeout + currentTime, schema);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }

    public LDAPThreadLocalConnectionPool(ServerSet serverSet, BindRequest bindRequest) {
        this(serverSet, bindRequest, null);
    }

    public LDAPThreadLocalConnectionPool(ServerSet serverSet, BindRequest bindRequest, PostConnectProcessor postConnectProcessor) {
        Validator.ensureNotNull(serverSet);
        this.serverSet = serverSet;
        this.bindRequest = bindRequest;
        this.postConnectProcessor = postConnectProcessor;
        if (serverSet.includesAuthentication()) {
            Validator.ensureTrue(bindRequest != null, "LDAPThreadLocalConnectionPool.bindRequest must not be null if serverSet.includesAuthentication returns true");
        }
        if (serverSet.includesPostConnectProcessing()) {
            Validator.ensureTrue(postConnectProcessor == null, "LDAPThreadLocalConnectionPool.postConnectProcessor must be null if serverSet.includesPostConnectProcessing returns true.");
        }
        this.healthCheck = new LDAPConnectionPoolHealthCheck();
        this.healthCheckInterval = 60000L;
        this.poolStatistics = new LDAPConnectionPoolStatistics(this);
        this.connectionPoolName = null;
        this.retryOperationTypes = new AtomicReference<Set<OperationType>>(Collections.unmodifiableSet(EnumSet.noneOf(OperationType.class)));
        this.connections = new ConcurrentHashMap();
        this.lastExpiredDisconnectTime = 0L;
        this.maxConnectionAge = 0L;
        this.minDisconnectInterval = 0L;
        this.closed = false;
        this.healthCheckThread = new LDAPConnectionPoolHealthCheckThread(this);
        this.healthCheckThread.start();
    }

    private LDAPConnection createConnection() throws LDAPException {
        LDAPConnection c;
        block30: {
            try {
                c = this.serverSet.getConnection(this.healthCheck);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.poolStatistics.incrementNumFailedConnectionAttempts();
                throw le;
            }
            c.setConnectionPool(this);
            LDAPConnectionOptions opts = c.getConnectionOptions();
            if (opts.autoReconnect()) {
                opts = opts.duplicate();
                opts.setAutoReconnect(false);
                c.setConnectionOptions(opts);
            }
            if (this.postConnectProcessor != null) {
                try {
                    this.postConnectProcessor.processPreAuthenticatedConnection(c);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    try {
                        this.poolStatistics.incrementNumFailedConnectionAttempts();
                        c.setDisconnectInfo(DisconnectType.POOL_CREATION_FAILURE, null, e);
                        c.setClosed();
                    }
                    catch (Exception e2) {
                        Debug.debugException(e2);
                    }
                    if (e instanceof LDAPException) {
                        throw (LDAPException)e;
                    }
                    throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_POST_CONNECT_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
                }
            }
            if (this.bindRequest != null && !this.serverSet.includesAuthentication()) {
                BindResult bindResult;
                try {
                    bindResult = c.bind(this.bindRequest.duplicate());
                }
                catch (LDAPBindException lbe) {
                    Debug.debugException(lbe);
                    bindResult = lbe.getBindResult();
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    bindResult = new BindResult(le);
                }
                try {
                    this.healthCheck.ensureConnectionValidAfterAuthentication(c, bindResult);
                    if (bindResult.getResultCode() != ResultCode.SUCCESS) {
                        throw new LDAPBindException(bindResult);
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    try {
                        this.poolStatistics.incrementNumFailedConnectionAttempts();
                        c.setDisconnectInfo(DisconnectType.BIND_FAILED, null, le);
                        c.setClosed();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                    throw le;
                }
            }
            if (this.postConnectProcessor != null) {
                try {
                    this.postConnectProcessor.processPostAuthenticatedConnection(c);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    try {
                        this.poolStatistics.incrementNumFailedConnectionAttempts();
                        c.setDisconnectInfo(DisconnectType.POOL_CREATION_FAILURE, null, e);
                        c.setClosed();
                    }
                    catch (Exception e2) {
                        Debug.debugException(e2);
                    }
                    if (e instanceof LDAPException) {
                        throw (LDAPException)e;
                    }
                    throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_POST_CONNECT_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
                }
            }
            if (opts.usePooledSchema()) {
                long currentTime = System.currentTimeMillis();
                if (this.pooledSchema == null || currentTime > this.pooledSchema.getFirst()) {
                    try {
                        Schema schema = c.getSchema();
                        if (schema == null) break block30;
                        c.setCachedSchema(schema);
                        long timeout = opts.getPooledSchemaTimeoutMillis();
                        if (timeout <= 0L || currentTime + timeout <= 0L) {
                            this.pooledSchema = new ObjectPair<Long, Schema>(Long.MAX_VALUE, schema);
                            break block30;
                        }
                        this.pooledSchema = new ObjectPair<Long, Schema>(currentTime + timeout, schema);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        if (this.pooledSchema != null) {
                            c.setCachedSchema(this.pooledSchema.getSecond());
                        }
                        break block30;
                    }
                }
                c.setCachedSchema(this.pooledSchema.getSecond());
            }
        }
        c.setConnectionPoolName(this.connectionPoolName);
        this.poolStatistics.incrementNumSuccessfulConnectionAttempts();
        return c;
    }

    @Override
    public void close() {
        this.close(true, 1);
    }

    @Override
    public void close(boolean unbind, int numThreads) {
        boolean healthCheckThreadAlreadySignaled = this.closed;
        this.closed = true;
        this.healthCheckThread.stopRunning(!healthCheckThreadAlreadySignaled);
        if (numThreads > 1) {
            ArrayList<LDAPConnection> connList = new ArrayList<LDAPConnection>(this.connections.size());
            Iterator<LDAPConnection> iterator = this.connections.values().iterator();
            while (iterator.hasNext()) {
                connList.add(iterator.next());
                iterator.remove();
            }
            if (!connList.isEmpty()) {
                ParallelPoolCloser closer = new ParallelPoolCloser(connList, unbind, numThreads);
                closer.closeConnections();
            }
        } else {
            Iterator<Map.Entry<Thread, LDAPConnection>> iterator = this.connections.entrySet().iterator();
            while (iterator.hasNext()) {
                LDAPConnection conn = iterator.next().getValue();
                iterator.remove();
                this.poolStatistics.incrementNumConnectionsClosedUnneeded();
                conn.setDisconnectInfo(DisconnectType.POOL_CLOSED, null, null);
                if (unbind) {
                    conn.terminate(null);
                    continue;
                }
                conn.setClosed();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public BindResult bindAndRevertAuthentication(String bindDN, String password, Control ... controls) throws LDAPException {
        return this.bindAndRevertAuthentication(new SimpleBindRequest(bindDN, password, controls));
    }

    public BindResult bindAndRevertAuthentication(BindRequest bindRequest) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            BindResult result = conn.bind(bindRequest);
            this.releaseAndReAuthenticateConnection(conn);
            return result;
        }
        catch (Throwable t) {
            LDAPException le;
            Debug.debugException(t);
            if (t instanceof LDAPException) {
                boolean shouldThrow;
                block13: {
                    le = (LDAPException)t;
                    try {
                        this.healthCheck.ensureConnectionValidAfterException(conn, le);
                        this.releaseAndReAuthenticateConnection(conn);
                        shouldThrow = true;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        if (!this.getOperationTypesToRetryDueToInvalidConnections().contains((Object)OperationType.BIND)) {
                            this.releaseDefunctConnection(conn);
                            shouldThrow = true;
                            break block13;
                        }
                        shouldThrow = false;
                    }
                }
                if (shouldThrow) {
                    throw le;
                }
            } else {
                this.releaseDefunctConnection(conn);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_OP_EXCEPTION.get(StaticUtils.getExceptionMessage(t)), t);
            }
            conn = this.replaceDefunctConnection(conn);
            try {
                BindResult result = conn.bind(bindRequest);
                this.releaseAndReAuthenticateConnection(conn);
                return result;
            }
            catch (Throwable t2) {
                Debug.debugException(t2);
                if (t2 instanceof LDAPException) {
                    le = (LDAPException)t2;
                    try {
                        this.healthCheck.ensureConnectionValidAfterException(conn, le);
                        this.releaseAndReAuthenticateConnection(conn);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        this.releaseDefunctConnection(conn);
                    }
                    throw le;
                }
                this.releaseDefunctConnection(conn);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_OP_EXCEPTION.get(StaticUtils.getExceptionMessage(t2)), t2);
            }
        }
    }

    @Override
    public LDAPConnection getConnection() throws LDAPException {
        Thread t = Thread.currentThread();
        LDAPConnection conn = this.connections.get(t);
        if (this.closed) {
            if (conn != null) {
                conn.terminate(null);
                this.connections.remove(t);
            }
            this.poolStatistics.incrementNumFailedCheckouts();
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_CLOSED.get());
        }
        boolean created = false;
        if (conn == null || !conn.isConnected()) {
            conn = this.createConnection();
            this.connections.put(t, conn);
            created = true;
        }
        try {
            this.healthCheck.ensureConnectionValidForCheckout(conn);
            if (created) {
                this.poolStatistics.incrementNumSuccessfulCheckoutsNewConnection();
            } else {
                this.poolStatistics.incrementNumSuccessfulCheckoutsWithoutWaiting();
            }
            return conn;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            conn.setClosed();
            this.connections.remove(t);
            if (created) {
                this.poolStatistics.incrementNumFailedCheckouts();
                throw le;
            }
            try {
                conn = this.createConnection();
                this.healthCheck.ensureConnectionValidForCheckout(conn);
                this.connections.put(t, conn);
                this.poolStatistics.incrementNumSuccessfulCheckoutsNewConnection();
                return conn;
            }
            catch (LDAPException le2) {
                Debug.debugException(le2);
                this.poolStatistics.incrementNumFailedCheckouts();
                if (conn != null) {
                    conn.setClosed();
                }
                throw le2;
            }
        }
    }

    @Override
    public void releaseConnection(LDAPConnection connection) {
        if (connection == null) {
            return;
        }
        connection.setConnectionPoolName(this.connectionPoolName);
        if (this.connectionIsExpired(connection)) {
            try {
                LDAPConnection newConnection = this.createConnection();
                this.connections.put(Thread.currentThread(), newConnection);
                connection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_EXPIRED, null, null);
                connection.terminate(null);
                this.poolStatistics.incrementNumConnectionsClosedExpired();
                this.lastExpiredDisconnectTime = System.currentTimeMillis();
            }
            catch (LDAPException le) {
                Debug.debugException(le);
            }
        }
        try {
            this.healthCheck.ensureConnectionValidForRelease(connection);
        }
        catch (LDAPException le) {
            this.releaseDefunctConnection(connection);
            return;
        }
        this.poolStatistics.incrementNumReleasedValid();
        if (this.closed) {
            this.close();
        }
    }

    public void releaseAndReAuthenticateConnection(LDAPConnection connection) {
        if (connection == null) {
            return;
        }
        try {
            BindResult bindResult;
            try {
                bindResult = this.bindRequest == null ? connection.bind("", "") : connection.bind(this.bindRequest.duplicate());
            }
            catch (LDAPBindException lbe) {
                Debug.debugException(lbe);
                bindResult = lbe.getBindResult();
            }
            try {
                this.healthCheck.ensureConnectionValidAfterAuthentication(connection, bindResult);
                if (bindResult.getResultCode() != ResultCode.SUCCESS) {
                    throw new LDAPBindException(bindResult);
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                try {
                    connection.setDisconnectInfo(DisconnectType.BIND_FAILED, null, le);
                    connection.terminate(null);
                    this.releaseDefunctConnection(connection);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
                throw le;
            }
            this.releaseConnection(connection);
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.releaseDefunctConnection(connection);
        }
    }

    @Override
    public void releaseDefunctConnection(LDAPConnection connection) {
        if (connection == null) {
            return;
        }
        connection.setConnectionPoolName(this.connectionPoolName);
        this.poolStatistics.incrementNumConnectionsClosedDefunct();
        this.handleDefunctConnection(connection);
    }

    private void handleDefunctConnection(LDAPConnection connection) {
        Thread t = Thread.currentThread();
        connection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, null, null);
        connection.setClosed();
        this.connections.remove(t);
        if (this.closed) {
            return;
        }
        try {
            LDAPConnection conn = this.createConnection();
            this.connections.put(t, conn);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
        }
    }

    @Override
    public LDAPConnection replaceDefunctConnection(LDAPConnection connection) throws LDAPException {
        this.poolStatistics.incrementNumConnectionsClosedDefunct();
        connection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, null, null);
        connection.setClosed();
        this.connections.remove(Thread.currentThread(), connection);
        if (this.closed) {
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_CLOSED.get());
        }
        LDAPConnection newConnection = this.createConnection();
        this.connections.put(Thread.currentThread(), newConnection);
        return newConnection;
    }

    @Override
    public Set<OperationType> getOperationTypesToRetryDueToInvalidConnections() {
        return this.retryOperationTypes.get();
    }

    @Override
    public void setRetryFailedOperationsDueToInvalidConnections(Set<OperationType> operationTypes) {
        if (operationTypes == null || operationTypes.isEmpty()) {
            this.retryOperationTypes.set(Collections.unmodifiableSet(EnumSet.noneOf(OperationType.class)));
        } else {
            EnumSet<OperationType> s = EnumSet.noneOf(OperationType.class);
            s.addAll(operationTypes);
            this.retryOperationTypes.set(Collections.unmodifiableSet(s));
        }
    }

    private boolean connectionIsExpired(LDAPConnection connection) {
        if (this.maxConnectionAge <= 0L) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastExpiredDisconnectTime < this.minDisconnectInterval) {
            return false;
        }
        long connectionAge = currentTime - connection.getConnectTime();
        return connectionAge > this.maxConnectionAge;
    }

    @Override
    public String getConnectionPoolName() {
        return this.connectionPoolName;
    }

    @Override
    public void setConnectionPoolName(String connectionPoolName) {
        this.connectionPoolName = connectionPoolName;
    }

    public long getMaxConnectionAgeMillis() {
        return this.maxConnectionAge;
    }

    public void setMaxConnectionAgeMillis(long maxConnectionAge) {
        this.maxConnectionAge = maxConnectionAge > 0L ? maxConnectionAge : 0L;
    }

    public long getMinDisconnectIntervalMillis() {
        return this.minDisconnectInterval;
    }

    public void setMinDisconnectIntervalMillis(long minDisconnectInterval) {
        this.minDisconnectInterval = minDisconnectInterval > 0L ? minDisconnectInterval : 0L;
    }

    @Override
    public LDAPConnectionPoolHealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(LDAPConnectionPoolHealthCheck healthCheck) {
        Validator.ensureNotNull(healthCheck);
        this.healthCheck = healthCheck;
    }

    @Override
    public long getHealthCheckIntervalMillis() {
        return this.healthCheckInterval;
    }

    @Override
    public void setHealthCheckIntervalMillis(long healthCheckInterval) {
        Validator.ensureTrue(healthCheckInterval > 0L, "LDAPConnectionPool.healthCheckInterval must be greater than 0.");
        this.healthCheckInterval = healthCheckInterval;
        this.healthCheckThread.wakeUp();
    }

    @Override
    protected void doHealthCheck() {
        Iterator<Map.Entry<Thread, LDAPConnection>> iterator = this.connections.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Thread, LDAPConnection> e = iterator.next();
            Thread t = e.getKey();
            LDAPConnection c = e.getValue();
            if (t.isAlive()) continue;
            c.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
            c.terminate(null);
            iterator.remove();
        }
    }

    @Override
    public int getCurrentAvailableConnections() {
        return -1;
    }

    @Override
    public int getMaximumAvailableConnections() {
        return -1;
    }

    @Override
    public LDAPConnectionPoolStatistics getConnectionPoolStatistics() {
        return this.poolStatistics;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDAPThreadLocalConnectionPool(");
        String name = this.connectionPoolName;
        if (name != null) {
            buffer.append("name='");
            buffer.append(name);
            buffer.append("', ");
        }
        buffer.append("serverSet=");
        this.serverSet.toString(buffer);
        buffer.append(')');
    }
}

