/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.InternalASN1Helper;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionInternals;
import com.unboundid.ldap.sdk.LDAPConnectionLogger;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.UnsolicitedNotificationHandler;
import com.unboundid.ldap.sdk.extensions.NoticeOfDisconnectionExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.extensions.InteractiveTransactionAbortedExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.WakeableSleeper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.sasl.SaslClient;

@InternalUseOnly
final class LDAPConnectionReader
extends Thread {
    private static final int DEFAULT_INPUT_BUFFER_SIZE = 4096;
    @NotNull
    private volatile ASN1StreamReader asn1StreamReader;
    private volatile boolean closeRequested;
    @NotNull
    private final ConcurrentHashMap<Integer, ResponseAcceptor> acceptorMap;
    @Nullable
    private volatile Exception startTLSException;
    @Nullable
    private volatile InputStream inputStream;
    @Nullable
    private volatile OutputStream startTLSOutputStream;
    @NotNull
    private final LDAPConnection connection;
    @NotNull
    private volatile Socket socket;
    @Nullable
    private volatile SSLSocketFactory sslSocketFactory;
    @Nullable
    private volatile Thread thread;
    @NotNull
    private final WakeableSleeper startTLSSleeper;

    LDAPConnectionReader(@NotNull LDAPConnection connection, @NotNull LDAPConnectionInternals connectionInternals) throws IOException {
        this.connection = connection;
        this.setName(this.constructThreadName(connectionInternals));
        this.setDaemon(true);
        this.socket = connectionInternals.getSocket();
        this.inputStream = new BufferedInputStream(this.socket.getInputStream(), 4096);
        this.asn1StreamReader = new ASN1StreamReader(this.inputStream, connection.getConnectionOptions().getMaxMessageSize());
        this.acceptorMap = new ConcurrentHashMap(StaticUtils.computeMapCapacity(10));
        this.closeRequested = false;
        this.sslSocketFactory = null;
        this.startTLSException = null;
        this.startTLSOutputStream = null;
        this.startTLSSleeper = new WakeableSleeper();
    }

    void registerResponseAcceptor(int messageID, @NotNull ResponseAcceptor acceptor) throws LDAPException {
        ResponseAcceptor existingAcceptor = this.acceptorMap.putIfAbsent(messageID, acceptor);
        if (existingAcceptor != null) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONNREADER_MSGID_IN_USE.get(String.valueOf(acceptor), messageID, String.valueOf(this.connection), String.valueOf(existingAcceptor)));
        }
    }

    void deregisterResponseAcceptor(int messageID) {
        this.acceptorMap.remove(messageID);
    }

    int getActiveOperationCount() {
        return this.acceptorMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean reconnect = false;
        this.thread = Thread.currentThread();
        while (!this.closeRequested) {
            try {
                ResponseAcceptor responseAcceptor;
                LDAPResponse response;
                try {
                    response = LDAPMessage.readLDAPResponseFrom(this.asn1StreamReader, true, this.connection.getCachedSchema());
                }
                catch (LDAPException le) {
                    String message;
                    Throwable t = le.getCause();
                    if (t != null && t instanceof SocketTimeoutException) {
                        SocketTimeoutException ste = (SocketTimeoutException)t;
                        Debug.debugException(Level.FINEST, ste);
                        if (this.sslSocketFactory == null) continue;
                        LDAPConnectionOptions connectionOptions = this.connection.getConnectionOptions();
                        try {
                            SSLSocket sslSocket;
                            int responseTimeoutMillis = (int)connectionOptions.getResponseTimeoutMillis();
                            if (responseTimeoutMillis > 0) {
                                InternalSDKHelper.setSoTimeout(this.connection, responseTimeoutMillis);
                            } else {
                                InternalSDKHelper.setSoTimeout(this.connection, 0);
                            }
                            SSLSocketFactory sSLSocketFactory = this.sslSocketFactory;
                            synchronized (sSLSocketFactory) {
                                sslSocket = (SSLSocket)this.sslSocketFactory.createSocket(this.socket, this.connection.getConnectedAddress(), this.socket.getPort(), true);
                                sslSocket.startHandshake();
                            }
                            connectionOptions.getSSLSocketVerifier().verifySSLSocket(this.connection.getConnectedAddress(), this.socket.getPort(), sslSocket);
                            this.inputStream = new BufferedInputStream(sslSocket.getInputStream(), 4096);
                            this.asn1StreamReader = new ASN1StreamReader(this.inputStream, connectionOptions.getMaxMessageSize());
                            this.startTLSOutputStream = sslSocket.getOutputStream();
                            this.socket = sslSocket;
                            this.connection.getConnectionInternals(true).setSocket(sslSocket);
                            this.startTLSSleeper.wakeup();
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            this.connection.setDisconnectInfo(DisconnectType.SECURITY_PROBLEM, StaticUtils.getExceptionMessage(e), e);
                            this.startTLSException = e;
                            this.closeRequested = true;
                            if (this.thread != null) {
                                this.thread.setName(this.thread.getName() + " (closed)");
                                this.thread = null;
                            }
                            this.closeInternal(true, StaticUtils.getExceptionMessage(e));
                            this.startTLSSleeper.wakeup();
                            return;
                        }
                        this.sslSocketFactory = null;
                        continue;
                    }
                    if (this.closeRequested || this.connection.closeRequested() || this.connection.getDisconnectType() != null) {
                        this.closeRequested = true;
                        Debug.debugException(Level.FINEST, le);
                    } else {
                        Debug.debugException(le);
                    }
                    Level debugLevel = Level.SEVERE;
                    if (t == null) {
                        this.connection.setDisconnectInfo(DisconnectType.DECODE_ERROR, le.getMessage(), t);
                        message = le.getMessage();
                        debugLevel = Level.WARNING;
                    } else if (t instanceof InterruptedIOException && this.socket.isClosed()) {
                        this.connection.setDisconnectInfo(DisconnectType.SERVER_CLOSED_WITHOUT_NOTICE, le.getMessage(), t);
                        message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_INTERRUPTED_IO.get(this.connection.getHostPort());
                        debugLevel = Level.WARNING;
                    } else if (t instanceof IOException) {
                        this.connection.setDisconnectInfo(DisconnectType.IO_ERROR, le.getMessage(), t);
                        message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_IO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(t));
                        debugLevel = Level.WARNING;
                    } else if (t instanceof ASN1Exception) {
                        this.connection.setDisconnectInfo(DisconnectType.DECODE_ERROR, le.getMessage(), t);
                        message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_ASN1_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(t));
                    } else {
                        this.connection.setDisconnectInfo(DisconnectType.LOCAL_ERROR, le.getMessage(), t);
                        message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(t));
                    }
                    Debug.debug(debugLevel, DebugType.LDAP, message, t);
                    boolean autoReconnect = this.connection.getConnectionOptions().autoReconnect();
                    if (!this.closeRequested && autoReconnect) {
                        reconnect = true;
                        break;
                    }
                    this.closeRequested = true;
                    if (this.thread != null) {
                        this.thread.setName(this.thread.getName() + " (closed)");
                        this.thread = null;
                    }
                    this.closeInternal(true, message);
                    return;
                }
                if (response == null) {
                    this.connection.setDisconnectInfo(DisconnectType.SERVER_CLOSED_WITHOUT_NOTICE, null, null);
                    boolean autoReconnect = this.connection.getConnectionOptions().autoReconnect();
                    if (!this.closeRequested && !this.connection.unbindRequestSent() && autoReconnect) {
                        reconnect = true;
                        break;
                    }
                    this.closeRequested = true;
                    if (this.thread != null) {
                        this.thread.setName(this.thread.getName() + " (closed)");
                        this.thread = null;
                    }
                    this.closeInternal(true, null);
                    return;
                }
                this.connection.setLastCommunicationTime();
                Debug.debugLDAPResult(response, this.connection);
                this.logResponse(response);
                if (response instanceof SearchResultEntry || response instanceof SearchResultReference) {
                    responseAcceptor = this.acceptorMap.get(response.getMessageID());
                } else {
                    if (response instanceof IntermediateResponse) {
                        IntermediateResponse ir = (IntermediateResponse)response;
                        responseAcceptor = this.acceptorMap.get(response.getMessageID());
                        IntermediateResponseListener l = null;
                        if (responseAcceptor instanceof LDAPRequest) {
                            LDAPRequest r = (LDAPRequest)((Object)responseAcceptor);
                            l = r.getIntermediateResponseListener();
                        } else if (responseAcceptor instanceof IntermediateResponseListener) {
                            l = (IntermediateResponseListener)((Object)responseAcceptor);
                        }
                        if (l == null) {
                            Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_INTERMEDIATE_RESPONSE_WITH_NO_LISTENER.get(String.valueOf(ir)));
                            continue;
                        }
                        try {
                            l.intermediateResponseReturned(ir);
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                        continue;
                    }
                    responseAcceptor = this.acceptorMap.remove(response.getMessageID());
                }
                if (responseAcceptor == null) {
                    if (response instanceof ExtendedResult && response.getMessageID() == 0) {
                        ExtendedResult extendedResult = (ExtendedResult)response;
                        String oid = extendedResult.getOID();
                        if ("1.3.6.1.4.1.1466.20036".equals(oid)) {
                            extendedResult = new NoticeOfDisconnectionExtendedResult(extendedResult);
                            this.connection.setDisconnectInfo(DisconnectType.SERVER_CLOSED_WITH_NOTICE, extendedResult.getDiagnosticMessage(), null);
                        } else if ("1.3.6.1.4.1.30221.2.6.5".equals(oid)) {
                            extendedResult = new InteractiveTransactionAbortedExtendedResult(extendedResult);
                        }
                        UnsolicitedNotificationHandler handler = this.connection.getConnectionOptions().getUnsolicitedNotificationHandler();
                        if (handler == null) {
                            if (!Debug.debugEnabled(DebugType.LDAP)) continue;
                            Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_READER_UNHANDLED_UNSOLICITED_NOTIFICATION.get(response));
                            continue;
                        }
                        handler.handleUnsolicitedNotification(this.connection, extendedResult);
                        continue;
                    }
                    if (!Debug.debugEnabled(DebugType.LDAP)) continue;
                    Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_READER_NO_ACCEPTOR.get(response));
                    continue;
                }
                try {
                    responseAcceptor.responseReceived(response);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.ERR_READER_ACCEPTOR_ERROR.get(String.valueOf(response), this.connection.getHostPort(), StaticUtils.getExceptionMessage(le)), le);
                }
            }
            catch (Exception e) {
                String message;
                Debug.debugException(e);
                Level debugLevel = Level.SEVERE;
                if (e instanceof IOException) {
                    this.connection.setDisconnectInfo(DisconnectType.IO_ERROR, null, e);
                    message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_IO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(e));
                    debugLevel = Level.WARNING;
                } else if (e instanceof ASN1Exception) {
                    this.connection.setDisconnectInfo(DisconnectType.DECODE_ERROR, null, e);
                    message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_ASN1_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(e));
                } else {
                    this.connection.setDisconnectInfo(DisconnectType.LOCAL_ERROR, null, e);
                    message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(e));
                }
                Debug.debug(debugLevel, DebugType.LDAP, message, e);
                boolean autoReconnect = this.connection.getConnectionOptions().autoReconnect();
                if (autoReconnect) {
                    reconnect = true;
                    break;
                }
                this.closeRequested = true;
                if (this.thread != null) {
                    this.thread.setName(this.thread.getName() + " (closed)");
                    this.thread = null;
                }
                this.closeInternal(true, message);
                return;
            }
        }
        if (this.thread != null) {
            this.thread.setName(this.constructThreadName(null));
            this.thread = null;
        }
        if (reconnect && !this.connection.closeRequested()) {
            try {
                this.connection.setNeedsReconnect();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        } else {
            this.closeInternal(true, null);
        }
    }

    @NotNull
    LDAPResponse readResponse(int messageID) throws LDAPException {
        try {
            while (true) {
                LDAPResponse response;
                if ((response = LDAPMessage.readLDAPResponseFrom(this.asn1StreamReader, false, this.connection.getCachedSchema())) == null) {
                    return new ConnectionClosedResponse(ResultCode.SERVER_DOWN, null);
                }
                this.connection.setLastCommunicationTime();
                if (response.getMessageID() == messageID) {
                    return response;
                }
                if (response instanceof ExtendedResult && response.getMessageID() == 0) {
                    ExtendedResult extendedResult = (ExtendedResult)response;
                    String oid = extendedResult.getOID();
                    if ("1.3.6.1.4.1.1466.20036".equals(oid)) {
                        extendedResult = new NoticeOfDisconnectionExtendedResult(extendedResult);
                        this.connection.setDisconnectInfo(DisconnectType.SERVER_CLOSED_WITH_NOTICE, extendedResult.getDiagnosticMessage(), null);
                    } else if ("1.3.6.1.4.1.30221.2.6.5".equals(oid)) {
                        extendedResult = new InteractiveTransactionAbortedExtendedResult(extendedResult);
                    }
                    UnsolicitedNotificationHandler handler = this.connection.getConnectionOptions().getUnsolicitedNotificationHandler();
                    if (handler == null) {
                        if (!Debug.debugEnabled(DebugType.LDAP)) continue;
                        Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_READER_UNHANDLED_UNSOLICITED_NOTIFICATION.get(response));
                        continue;
                    }
                    handler.handleUnsolicitedNotification(this.connection, extendedResult);
                    continue;
                }
                if (!Debug.debugEnabled(DebugType.LDAP)) continue;
                Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_READER_DISCARDING_UNEXPECTED_RESPONSE.get(response, messageID));
            }
        }
        catch (LDAPException le) {
            String message;
            Throwable t = le.getCause();
            if (t != null && t instanceof SocketTimeoutException) {
                Debug.debugException(Level.FINEST, le);
                throw new LDAPException(ResultCode.TIMEOUT, le.getMessage(), le);
            }
            Debug.debugException(le);
            Level debugLevel = Level.SEVERE;
            if (t == null) {
                this.connection.setDisconnectInfo(DisconnectType.DECODE_ERROR, le.getMessage(), t);
                message = le.getMessage();
                debugLevel = Level.WARNING;
            } else if (t instanceof IOException) {
                this.connection.setDisconnectInfo(DisconnectType.IO_ERROR, le.getMessage(), t);
                message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_IO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(t));
                debugLevel = Level.WARNING;
            } else if (t instanceof ASN1Exception) {
                this.connection.setDisconnectInfo(DisconnectType.DECODE_ERROR, le.getMessage(), t);
                message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_ASN1_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(t));
            } else {
                this.connection.setDisconnectInfo(DisconnectType.LOCAL_ERROR, le.getMessage(), t);
                message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(t));
            }
            Debug.debug(debugLevel, DebugType.LDAP, message, t);
            boolean autoReconnect = this.connection.getConnectionOptions().autoReconnect();
            if (!autoReconnect) {
                this.closeRequested = true;
            }
            this.closeInternal(true, message);
            throw le;
        }
        catch (Exception e) {
            String message;
            Debug.debugException(e);
            Level debugLevel = Level.SEVERE;
            if (e instanceof IOException) {
                this.connection.setDisconnectInfo(DisconnectType.IO_ERROR, null, e);
                message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_IO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(e));
                debugLevel = Level.WARNING;
            } else if (e instanceof ASN1Exception) {
                this.connection.setDisconnectInfo(DisconnectType.DECODE_ERROR, null, e);
                message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_ASN1_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(e));
            } else {
                this.connection.setDisconnectInfo(DisconnectType.LOCAL_ERROR, null, e);
                message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(e));
            }
            Debug.debug(debugLevel, DebugType.LDAP, message, e);
            boolean autoReconnect = this.connection.getConnectionOptions().autoReconnect();
            if (!autoReconnect) {
                this.closeRequested = true;
            }
            this.closeInternal(true, message);
            throw new LDAPException(ResultCode.SERVER_DOWN, message, e);
        }
    }

    void logResponse(@NotNull LDAPResponse response) {
        LDAPConnectionLogger logger = this.connection.getConnectionOptions().getConnectionLogger();
        if (logger == null) {
            return;
        }
        int messageID = response.getMessageID();
        if (response instanceof BindResult) {
            logger.logBindResult(this.connection, messageID, (BindResult)response);
        } else if (response instanceof ExtendedResult) {
            logger.logExtendedResult(this.connection, messageID, (ExtendedResult)response);
        } else if (response instanceof SearchResult) {
            logger.logSearchResult(this.connection, messageID, (SearchResult)response);
        } else if (response instanceof LDAPResult) {
            LDAPResult ldapResult = (LDAPResult)response;
            OperationType operationType = ldapResult.getOperationType();
            if (operationType != null) {
                switch (operationType) {
                    case ADD: {
                        logger.logAddResult(this.connection, messageID, ldapResult);
                        break;
                    }
                    case COMPARE: {
                        logger.logCompareResult(this.connection, messageID, ldapResult);
                        break;
                    }
                    case DELETE: {
                        logger.logDeleteResult(this.connection, messageID, ldapResult);
                        break;
                    }
                    case MODIFY: {
                        logger.logModifyResult(this.connection, messageID, ldapResult);
                        break;
                    }
                    case MODIFY_DN: {
                        logger.logModifyDNResult(this.connection, messageID, ldapResult);
                    }
                }
            }
        } else if (response instanceof SearchResultEntry) {
            logger.logSearchEntry(this.connection, messageID, (SearchResultEntry)response);
        } else if (response instanceof SearchResultReference) {
            logger.logSearchReference(this.connection, messageID, (SearchResultReference)response);
        } else if (response instanceof IntermediateResponse) {
            logger.logIntermediateResponse(this.connection, messageID, (IntermediateResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    OutputStream doStartTLS(@NotNull SSLSocketFactory sslSocketFactory) throws LDAPException {
        LDAPConnectionOptions connectionOptions = this.connection.getConnectionOptions();
        if (this.connection.synchronousMode()) {
            try {
                SSLSocket sslSocket;
                int connectTimeout = connectionOptions.getConnectTimeoutMillis();
                if (connectTimeout > 0) {
                    InternalSDKHelper.setSoTimeout(this.connection, connectTimeout);
                } else {
                    InternalSDKHelper.setSoTimeout(this.connection, 0);
                }
                SSLSocketFactory sSLSocketFactory = sslSocketFactory;
                synchronized (sSLSocketFactory) {
                    sslSocket = (SSLSocket)sslSocketFactory.createSocket(this.socket, this.connection.getConnectedAddress(), this.socket.getPort(), true);
                    sslSocket.startHandshake();
                }
                connectionOptions.getSSLSocketVerifier().verifySSLSocket(this.connection.getConnectedAddress(), this.socket.getPort(), sslSocket);
                this.inputStream = new BufferedInputStream(sslSocket.getInputStream(), 4096);
                this.asn1StreamReader = new ASN1StreamReader(this.inputStream, connectionOptions.getMaxMessageSize());
                this.startTLSOutputStream = sslSocket.getOutputStream();
                this.socket = sslSocket;
                this.connection.getConnectionInternals(true).setSocket(sslSocket);
                OutputStream outputStream = this.startTLSOutputStream;
                this.startTLSOutputStream = null;
                return outputStream;
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.connection.setDisconnectInfo(DisconnectType.SECURITY_PROBLEM, StaticUtils.getExceptionMessage(e), e);
                this.startTLSException = e;
                this.closeRequested = true;
                this.closeInternal(true, StaticUtils.getExceptionMessage(e));
                throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONNREADER_STARTTLS_FAILED.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        this.sslSocketFactory = sslSocketFactory;
        int originalSOTimeout = InternalSDKHelper.getSoTimeout(this.connection);
        boolean revertSOTimeout = false;
        try {
            InternalSDKHelper.setSoTimeout(this.connection, 50);
            revertSOTimeout = true;
            while (true) {
                if (this.startTLSOutputStream != null) {
                    OutputStream outputStream = this.startTLSOutputStream;
                    this.startTLSOutputStream = null;
                    OutputStream outputStream2 = outputStream;
                    return outputStream2;
                }
                if (this.thread == null) {
                    if (this.startTLSException == null) {
                        revertSOTimeout = false;
                        throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONNREADER_STARTTLS_FAILED_NO_EXCEPTION.get());
                    }
                    Exception e = this.startTLSException;
                    this.startTLSException = null;
                    revertSOTimeout = false;
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONNREADER_STARTTLS_FAILED.get(StaticUtils.getExceptionMessage(e)), e);
                }
                this.startTLSSleeper.sleep(1L);
            }
        }
        finally {
            if (revertSOTimeout) {
                InternalSDKHelper.setSoTimeout(this.connection, originalSOTimeout);
            }
        }
    }

    void applySASLQoP(@NotNull SaslClient saslClient) {
        InternalASN1Helper.setSASLClient(this.asn1StreamReader, saslClient);
    }

    void close(boolean notifyConnection) {
        this.closeRequested = true;
        for (int i = 0; i < 5; ++i) {
            try {
                Thread t = this.thread;
                if (t == null || t == Thread.currentThread() || !t.isAlive()) break;
                t.interrupt();
                t.join(100L);
                continue;
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (!(e instanceof InterruptedException)) continue;
                Thread.currentThread().interrupt();
                break;
            }
        }
        this.closeInternal(notifyConnection, null);
    }

    private void closeInternal(boolean notifyConnection, @Nullable String message) {
        InputStream is = this.inputStream;
        this.inputStream = null;
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        if (notifyConnection) {
            this.connection.setClosed();
        }
        Iterator iterator = this.acceptorMap.keySet().iterator();
        while (iterator.hasNext()) {
            int messageID = (Integer)iterator.next();
            ResponseAcceptor acceptor = this.acceptorMap.get(messageID);
            try {
                if (message == null) {
                    DisconnectType disconnectType = this.connection.getDisconnectType();
                    if (disconnectType == null) {
                        acceptor.responseReceived(new ConnectionClosedResponse(ResultCode.SERVER_DOWN, null));
                    } else {
                        acceptor.responseReceived(new ConnectionClosedResponse(disconnectType.getResultCode(), this.connection.getDisconnectMessage()));
                    }
                } else {
                    acceptor.responseReceived(new ConnectionClosedResponse(ResultCode.SERVER_DOWN, message));
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            iterator.remove();
        }
    }

    @Nullable
    Thread getReaderThread() {
        return this.thread;
    }

    void updateThreadName() {
        Thread t = this.thread;
        if (t != null) {
            try {
                t.setName(this.constructThreadName(this.connection.getConnectionInternals(true)));
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }

    @NotNull
    private String constructThreadName(@Nullable LDAPConnectionInternals connectionInternals) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Connection reader for connection ");
        buffer.append(this.connection.getConnectionID());
        buffer.append(' ');
        String name = this.connection.getConnectionName();
        if (name != null) {
            buffer.append('\'');
            buffer.append(name);
            buffer.append("' ");
        }
        if ((name = this.connection.getConnectionPoolName()) != null) {
            buffer.append("in pool '");
            buffer.append(name);
            buffer.append("' ");
        }
        if (connectionInternals == null) {
            buffer.append("(not connected)");
        } else {
            buffer.append("to ");
            buffer.append(connectionInternals.getHost());
            buffer.append(':');
            buffer.append(connectionInternals.getPort());
        }
        return buffer.toString();
    }
}

