/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.PooledReferralConnectorBackgroundThread;
import com.unboundid.ldap.sdk.PooledReferralConnectorLDAPURLSecurityType;
import com.unboundid.ldap.sdk.PooledReferralConnectorProperties;
import com.unboundid.ldap.sdk.ReferralConnectionPool;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ReusableReferralConnector;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSocketFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PooledReferralConnector
implements ReusableReferralConnector,
Closeable {
    @NotNull
    private final AtomicBoolean closeRequested;
    @Nullable
    private final BindRequest bindRequest;
    private final boolean retryFailedOperationsDueToInvalidConnections;
    private final int initialConnectionsPerPool;
    private final int maximumConnectionsPerPool;
    @Nullable
    private final LDAPConnectionOptions connectionOptions;
    @Nullable
    private final LDAPConnectionPoolHealthCheck healthCheck;
    private final long backgroundThreadCheckIntervalMillis;
    private final long healthCheckIntervalMillis;
    private final long maximumConnectionAgeMillis;
    private final long maximumPoolAgeMillis;
    private final long maximumPoolIdleDurationMillis;
    @NotNull
    private final Map<String, List<ReferralConnectionPool>> poolsByHostPort;
    @Nullable
    private final PooledReferralConnectorBackgroundThread backgroundThread;
    @NotNull
    private final PooledReferralConnectorLDAPURLSecurityType ldapURLSecurityType;
    @Nullable
    private final SSLSocketFactory sslSocketFactory;

    public PooledReferralConnector() {
        this(new PooledReferralConnectorProperties());
    }

    public PooledReferralConnector(@NotNull PooledReferralConnectorProperties properties) {
        this.bindRequest = properties.getBindRequest();
        this.retryFailedOperationsDueToInvalidConnections = properties.retryFailedOperationsDueToInvalidConnections();
        this.initialConnectionsPerPool = properties.getInitialConnectionsPerPool();
        this.maximumConnectionsPerPool = properties.getMaximumConnectionsPerPool();
        this.connectionOptions = properties.getConnectionOptions();
        this.healthCheck = properties.getHealthCheck();
        this.backgroundThreadCheckIntervalMillis = properties.getBackgroundThreadCheckIntervalMillis();
        this.healthCheckIntervalMillis = properties.getHealthCheckIntervalMillis();
        this.maximumConnectionAgeMillis = properties.getMaximumConnectionAgeMillis();
        this.maximumPoolAgeMillis = properties.getMaximumPoolAgeMillis();
        this.maximumPoolIdleDurationMillis = properties.getMaximumPoolIdleDurationMillis();
        this.ldapURLSecurityType = properties.getLDAPURLSecurityType();
        this.sslSocketFactory = properties.getSSLSocketFactory();
        this.closeRequested = new AtomicBoolean(false);
        this.poolsByHostPort = new ConcurrentHashMap<String, List<ReferralConnectionPool>>();
        if (this.maximumPoolAgeMillis > 0L || this.maximumPoolIdleDurationMillis > 0L) {
            this.backgroundThread = new PooledReferralConnectorBackgroundThread(this);
            this.backgroundThread.start();
        } else {
            this.backgroundThread = null;
        }
    }

    public int getInitialConnectionsPerPool() {
        return this.initialConnectionsPerPool;
    }

    public int getMaximumConnectionsPerPool() {
        return this.maximumConnectionsPerPool;
    }

    public boolean retryFailedOperationsDueToInvalidConnections() {
        return this.retryFailedOperationsDueToInvalidConnections;
    }

    public long getMaximumConnectionAgeMillis() {
        return this.maximumConnectionAgeMillis;
    }

    public long getMaximumPoolAgeMillis() {
        return this.maximumPoolAgeMillis;
    }

    public long getMaximumPoolIdleDurationMillis() {
        return this.maximumPoolIdleDurationMillis;
    }

    @Nullable
    public LDAPConnectionPoolHealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public long getHealthCheckIntervalMillis() {
        return this.healthCheckIntervalMillis;
    }

    @Nullable
    public BindRequest getBindRequest() {
        return this.bindRequest;
    }

    @Nullable
    public LDAPConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @NotNull
    public PooledReferralConnectorLDAPURLSecurityType getLDAPURLSecurityType() {
        return this.ldapURLSecurityType;
    }

    @Nullable
    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    long getBackgroundThreadCheckIntervalMillis() {
        return this.backgroundThreadCheckIntervalMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.backgroundThread != null) {
            this.backgroundThread.shutDown();
        }
        Map<String, List<ReferralConnectionPool>> map = this.poolsByHostPort;
        synchronized (map) {
            this.closeRequested.set(true);
            Iterator<Map.Entry<String, List<ReferralConnectionPool>>> iterator = this.poolsByHostPort.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, List<ReferralConnectionPool>> e = iterator.next();
                iterator.remove();
                for (ReferralConnectionPool pool : e.getValue()) {
                    pool.close();
                }
            }
        }
    }

    @NotNull
    Map<String, List<ReferralConnectionPool>> getPoolsByHostPort() {
        return this.poolsByHostPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public LDAPConnectionPool getReferralInterface(@NotNull LDAPURL referralURL, @NotNull LDAPConnection connection) throws LDAPException {
        String hostPort = StaticUtils.toLowerCase(referralURL.getHost()) + ":" + referralURL.getPort();
        Map<String, List<ReferralConnectionPool>> map = this.poolsByHostPort;
        synchronized (map) {
            if (this.closeRequested.get()) {
                throw new LDAPException(ResultCode.UNAVAILABLE, LDAPMessages.ERR_POOLED_REFERRAL_CONNECTOR_CLOSED.get(String.valueOf(referralURL)));
            }
            List<ReferralConnectionPool> pools = this.poolsByHostPort.get(hostPort);
            if (pools == null) {
                pools = new ArrayList<ReferralConnectionPool>();
                this.poolsByHostPort.put(hostPort, pools);
            }
            for (ReferralConnectionPool pool : pools) {
                if (!pool.isApplicableToReferral(referralURL, connection)) continue;
                return pool.getConnectionPool();
            }
            ReferralConnectionPool newPool = new ReferralConnectionPool(referralURL, connection, this);
            pools.add(newPool);
            return newPool.getConnectionPool();
        }
    }

    @Override
    @NotNull
    public LDAPConnection getReferralConnection(@NotNull LDAPURL referralURL, @NotNull LDAPConnection connection) throws LDAPException {
        LDAPConnectionPool connectionPool = this.getReferralInterface(referralURL, connection);
        return connectionPool.getConnection();
    }
}

