/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.examples;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.unboundidds.examples.GenericFilter;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.AbandonRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.AccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.AccessLogReader;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.AddResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.BindResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.CompareResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.ConnectAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.DeleteResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.DisconnectAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.ExtendedRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.ExtendedResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.ModifyDNResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.ModifyResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.OperationRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.OperationResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.SearchRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.SearchResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.SecurityNegotiationAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.UnbindRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONAccessLogReader;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogReader;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolUtils;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.OIDRegistry;
import com.unboundid.util.OIDRegistryItem;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.ReverseComparator;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DurationArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import javax.crypto.BadPaddingException;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class SummarizeAccessLog
extends CommandLineTool
implements Serializable {
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    private static final long serialVersionUID = 7189168366509887130L;
    @Nullable
    private ArgumentParser argumentParser = null;
    @Nullable
    private BooleanArgument doNotAnonymize = null;
    @Nullable
    private BooleanArgument isCompressed = null;
    @Nullable
    private BooleanArgument json = null;
    @Nullable
    private FileArgument encryptionPassphraseFile = null;
    @Nullable
    private IntegerArgument reportCount = null;
    @NotNull
    private final DecimalFormat decimalFormat = new DecimalFormat("0.000");
    private long logDurationMillis = 0L;
    private double addProcessingDuration = 0.0;
    private double bindProcessingDuration = 0.0;
    private double compareProcessingDuration = 0.0;
    private double deleteProcessingDuration = 0.0;
    private double extendedProcessingDuration = 0.0;
    private double modifyProcessingDuration = 0.0;
    private double modifyDNProcessingDuration = 0.0;
    private double searchProcessingDuration = 0.0;
    private long totalWorkQueueWaitTime = 0L;
    private long numAbandons = 0L;
    private long numAdds = 0L;
    private long numBinds = 0L;
    private long numCompares = 0L;
    private long numConnects = 0L;
    private long numDeletes = 0L;
    private long numDisconnects = 0L;
    private long numExtended = 0L;
    private long numModifies = 0L;
    private long numModifyDNs = 0L;
    private long numSearches = 0L;
    private long numUnbinds = 0L;
    private long numUncachedAdds = 0L;
    private long numUncachedBinds = 0L;
    private long numUncachedCompares = 0L;
    private long numUncachedDeletes = 0L;
    private long numUncachedExtended = 0L;
    private long numUncachedModifies = 0L;
    private long numUncachedModifyDNs = 0L;
    private long numUncachedSearches = 0L;
    private long numUnindexedAttempts = 0L;
    private long numUnindexedFailed = 0L;
    private long numUnindexedSuccessful = 0L;
    private long numRequestControls = 0L;
    private long numResponseControls = 0L;
    @NotNull
    private final HashMap<Long, AtomicLong> searchEntryCounts = new HashMap(StaticUtils.computeMapCapacity(10));
    @NotNull
    private final HashMap<Long, String> ipAddressesByConnectionID = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<ResultCode, AtomicLong> addResultCodes = new HashMap(StaticUtils.computeMapCapacity(10));
    @NotNull
    private final HashMap<ResultCode, AtomicLong> bindResultCodes = new HashMap(StaticUtils.computeMapCapacity(10));
    @NotNull
    private final HashMap<ResultCode, AtomicLong> compareResultCodes = new HashMap(StaticUtils.computeMapCapacity(10));
    @NotNull
    private final HashMap<ResultCode, AtomicLong> deleteResultCodes = new HashMap(StaticUtils.computeMapCapacity(10));
    @NotNull
    private final HashMap<ResultCode, AtomicLong> extendedResultCodes = new HashMap(StaticUtils.computeMapCapacity(10));
    @NotNull
    private final HashMap<ResultCode, AtomicLong> modifyResultCodes = new HashMap(StaticUtils.computeMapCapacity(10));
    @NotNull
    private final HashMap<ResultCode, AtomicLong> modifyDNResultCodes = new HashMap(StaticUtils.computeMapCapacity(10));
    @NotNull
    private final HashMap<ResultCode, AtomicLong> searchResultCodes = new HashMap(StaticUtils.computeMapCapacity(10));
    @NotNull
    private final HashMap<SearchScope, AtomicLong> searchScopes = new HashMap(StaticUtils.computeMapCapacity(4));
    @NotNull
    private final HashMap<String, AtomicLong> authenticationTypes = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> authzDNs = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> bindFailuresByDN = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> bindFailuresByIPAddress = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> consecutiveFailedBindsByDN;
    @NotNull
    private final HashMap<String, AtomicLong> outstandingFailedBindDNs = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> successfulBindDNs = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> clientAddresses = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> clientConnectionPolicies = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> disconnectReasons = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> extendedOperations = new HashMap(StaticUtils.computeMapCapacity(10));
    @NotNull
    private final HashMap<String, AtomicLong> filterComponentCounts = new HashMap(StaticUtils.computeMapCapacity(10));
    @NotNull
    private final HashMap<String, AtomicLong> filterTypes = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> mostExpensiveFilters = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> multiEntryFilters = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> noEntryFilters = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> oneEntryFilters = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> preAuthzPrivilegesUsed = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> privilegesMissing = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> privilegesUsed = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> requestControlOIDs = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> responseControlOIDs = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> searchBaseDNs = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> tlsCipherSuites = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> tlsProtocols = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, AtomicLong> unindexedFilters = new HashMap(StaticUtils.computeMapCapacity(100));
    @NotNull
    private final HashMap<String, String> extendedOperationOIDsToNames;
    @NotNull
    private final HashSet<String> processedRequests;
    @NotNull
    private final LinkedHashMap<Long, AtomicLong> addProcessingTimes;
    @NotNull
    private final LinkedHashMap<Long, AtomicLong> bindProcessingTimes;
    @NotNull
    private final LinkedHashMap<Long, AtomicLong> compareProcessingTimes;
    @NotNull
    private final LinkedHashMap<Long, AtomicLong> deleteProcessingTimes;
    @NotNull
    private final LinkedHashMap<Long, AtomicLong> extendedProcessingTimes;
    @NotNull
    private final LinkedHashMap<Long, AtomicLong> modifyProcessingTimes;
    @NotNull
    private final LinkedHashMap<Long, AtomicLong> modifyDNProcessingTimes;
    @NotNull
    private final LinkedHashMap<Long, AtomicLong> searchProcessingTimes;
    @NotNull
    private final LinkedHashMap<Long, AtomicLong> workQueueWaitTimes;
    @NotNull
    private final LinkedHashSet<Filter> filtersRepresentingPotentialInjectionAttempt;

    public static void main(@NotNull String[] args) {
        ResultCode resultCode = SummarizeAccessLog.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@NotNull String[] args, @Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        SummarizeAccessLog summarizer = new SummarizeAccessLog(outStream, errStream);
        return summarizer.runTool(args);
    }

    public SummarizeAccessLog(@Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        super(outStream, errStream);
        this.consecutiveFailedBindsByDN = new HashMap(StaticUtils.computeMapCapacity(100));
        this.extendedOperationOIDsToNames = new HashMap(StaticUtils.computeMapCapacity(100));
        this.processedRequests = new HashSet(StaticUtils.computeMapCapacity(100));
        this.addProcessingTimes = new LinkedHashMap(StaticUtils.computeMapCapacity(11));
        this.bindProcessingTimes = new LinkedHashMap(StaticUtils.computeMapCapacity(11));
        this.compareProcessingTimes = new LinkedHashMap(StaticUtils.computeMapCapacity(11));
        this.deleteProcessingTimes = new LinkedHashMap(StaticUtils.computeMapCapacity(11));
        this.extendedProcessingTimes = new LinkedHashMap(StaticUtils.computeMapCapacity(11));
        this.modifyProcessingTimes = new LinkedHashMap(StaticUtils.computeMapCapacity(11));
        this.modifyDNProcessingTimes = new LinkedHashMap(StaticUtils.computeMapCapacity(11));
        this.searchProcessingTimes = new LinkedHashMap(StaticUtils.computeMapCapacity(11));
        this.workQueueWaitTimes = new LinkedHashMap(StaticUtils.computeMapCapacity(11));
        this.filtersRepresentingPotentialInjectionAttempt = new LinkedHashSet(StaticUtils.computeMapCapacity(10));
        SummarizeAccessLog.populateProcessingTimeMap(this.addProcessingTimes);
        SummarizeAccessLog.populateProcessingTimeMap(this.bindProcessingTimes);
        SummarizeAccessLog.populateProcessingTimeMap(this.compareProcessingTimes);
        SummarizeAccessLog.populateProcessingTimeMap(this.deleteProcessingTimes);
        SummarizeAccessLog.populateProcessingTimeMap(this.extendedProcessingTimes);
        SummarizeAccessLog.populateProcessingTimeMap(this.modifyProcessingTimes);
        SummarizeAccessLog.populateProcessingTimeMap(this.modifyDNProcessingTimes);
        SummarizeAccessLog.populateProcessingTimeMap(this.searchProcessingTimes);
        SummarizeAccessLog.populateProcessingTimeMap(this.workQueueWaitTimes);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "summarize-access-log";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return "Examine one or more access log files from Ping Identity, UnboundID, or Nokia/Alcatel-Lucent 8661 server products to display a number of metrics about operations processed within the server.";
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "7.0.2";
    }

    @Override
    public int getMinTrailingArguments() {
        return 1;
    }

    @Override
    public int getMaxTrailingArguments() {
        return -1;
    }

    @Override
    @NotNull
    public String getTrailingArgumentsPlaceholder() {
        return "{path}";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean supportsDebugLogging() {
        return true;
    }

    @Override
    public void addToolArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.argumentParser = parser;
        String description = "Indicates that the log file contains JSON-formatted log messages rather than text-formatted messages.";
        this.json = new BooleanArgument(null, "json", description);
        parser.addArgument(this.json);
        description = "Indicates that the log file is compressed.";
        this.isCompressed = new BooleanArgument(Character.valueOf('c'), "isCompressed", description);
        this.isCompressed.addLongIdentifier("is-compressed", true);
        this.isCompressed.addLongIdentifier("compressed", true);
        this.isCompressed.setHidden(true);
        parser.addArgument(this.isCompressed);
        description = "Indicates that the log file is encrypted and that the encryption passphrase is contained in the specified file.  If the log data is encrypted and this argument is not provided, then the tool will interactively prompt for the encryption passphrase.";
        this.encryptionPassphraseFile = new FileArgument(null, "encryptionPassphraseFile", false, 1, null, description, true, true, true, false);
        this.encryptionPassphraseFile.addLongIdentifier("encryption-passphrase-file", true);
        this.encryptionPassphraseFile.addLongIdentifier("encryptionPasswordFile", true);
        this.encryptionPassphraseFile.addLongIdentifier("encryption-password-file", true);
        parser.addArgument(this.encryptionPassphraseFile);
        description = "The number of values to display for each item being summarized.  A value of zero indicates that all items should be displayed.  If this is not provided, a default value of 20 will be used.";
        this.reportCount = new IntegerArgument(null, "reportCount", false, 0, null, description, 0, Integer.MAX_VALUE, 20);
        this.reportCount.addLongIdentifier("report-count", true);
        this.reportCount.addLongIdentifier("maximumCount", true);
        this.reportCount.addLongIdentifier("maximum-count", true);
        this.reportCount.addLongIdentifier("maxCount", true);
        this.reportCount.addLongIdentifier("max-count", true);
        this.reportCount.addLongIdentifier("count", true);
        parser.addArgument(this.reportCount);
        description = "Do not anonymize the output, but include actual attribute values in filters and DNs.  This will also have the effect of de-generifying those values, so output including the most common filters and DNs in some category will be specific instances of those filters and DNs instead of generic patterns.";
        this.doNotAnonymize = new BooleanArgument(null, "doNotAnonymize", 1, description);
        this.doNotAnonymize.addLongIdentifier("do-not-anonymize", true);
        this.doNotAnonymize.addLongIdentifier("deAnonymize", true);
        this.doNotAnonymize.addLongIdentifier("de-anonymize", true);
        parser.addArgument(this.doNotAnonymize);
    }

    @Override
    public void doExtendedArgumentValidation() throws ArgumentException {
        List<String> trailingArguments = this.argumentParser.getTrailingArguments();
        if (trailingArguments == null || trailingArguments.isEmpty()) {
            throw new ArgumentException("No access log file paths were provided.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        long totalUncached;
        int displayCount = this.reportCount.getValue();
        if (displayCount <= 0) {
            displayCount = Integer.MAX_VALUE;
        }
        String encryptionPassphrase = null;
        if (this.encryptionPassphraseFile.isPresent()) {
            try {
                encryptionPassphrase = ToolUtils.readEncryptionPassphraseFromFile(this.encryptionPassphraseFile.getValue());
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                this.err(e.getMessage());
                return e.getResultCode();
            }
        }
        long logLines = 0L;
        for (String path : this.argumentParser.getTrailingArguments()) {
            File f = new File(path);
            this.out("Examining access log ", f.getAbsolutePath());
            AccessLogReader reader = null;
            InputStream inputStream = null;
            try {
                inputStream = new FileInputStream(f);
                ObjectPair<InputStream, String> p = ToolUtils.getPossiblyPassphraseEncryptedInputStream(inputStream, encryptionPassphrase, !this.encryptionPassphraseFile.isPresent(), (CharSequence)("Log file '" + path + "' is encrypted.  Please enter the encryption passphrase:"), (CharSequence)"ERROR:  The provided passphrase was incorrect.", this.getOut(), this.getErr());
                inputStream = p.getFirst();
                if (p.getSecond() != null && encryptionPassphrase == null) {
                    encryptionPassphrase = p.getSecond();
                }
                inputStream = this.isCompressed.isPresent() ? new GZIPInputStream(inputStream) : ToolUtils.getPossiblyGZIPCompressedInputStream(inputStream);
                reader = this.json.isPresent() ? new JSONAccessLogReader(inputStream) : new TextFormattedAccessLogReader(inputStream);
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.err("Unable to open access log file ", f.getAbsolutePath(), ":  ", StaticUtils.getExceptionMessage(e));
                ResultCode resultCode = ResultCode.LOCAL_ERROR;
                return resultCode;
            }
            finally {
                if (reader == null && inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                }
            }
            long startTime = 0L;
            long stopTime = 0L;
            while (true) {
                AccessLogMessage msg;
                try {
                    msg = reader.readMessage();
                }
                catch (IOException ioe) {
                    Debug.debugException(ioe);
                    this.err("Error reading from access log file ", f.getAbsolutePath(), ":  ", StaticUtils.getExceptionMessage(ioe));
                    if (ioe.getCause() != null && ioe.getCause() instanceof BadPaddingException) {
                        this.err("This error is likely because the log is encrypted and the server still has the log file open.  It is recommended that you only try to examine encrypted logs after they have been rotated.  You can use the rotate-log tool to force a rotation at any time.  Attempting to proceed with just the data that was successfully read.");
                        break;
                    }
                    return ResultCode.LOCAL_ERROR;
                }
                catch (LogException le) {
                    Debug.debugException(le);
                    this.err("Encountered an error while attempting to parse a line inaccess log file ", f.getAbsolutePath(), ":  ", StaticUtils.getExceptionMessage(le));
                    continue;
                }
                if (msg == null) break;
                ++logLines;
                stopTime = msg.getTimestamp().getTime();
                if (startTime == 0L) {
                    startTime = stopTime;
                }
                block8 : switch (msg.getMessageType()) {
                    case CONNECT: {
                        this.processConnect((ConnectAccessLogMessage)msg);
                        break;
                    }
                    case SECURITY_NEGOTIATION: {
                        this.processSecurityNegotiation((SecurityNegotiationAccessLogMessage)msg);
                        break;
                    }
                    case DISCONNECT: {
                        this.processDisconnect((DisconnectAccessLogMessage)msg);
                        break;
                    }
                    case REQUEST: {
                        switch (((OperationRequestAccessLogMessage)msg).getOperationType()) {
                            case ABANDON: {
                                this.processAbandonRequest((AbandonRequestAccessLogMessage)msg);
                                break block8;
                            }
                            case EXTENDED: {
                                this.processExtendedRequest((ExtendedRequestAccessLogMessage)msg);
                                break block8;
                            }
                            case SEARCH: {
                                this.processSearchRequest((SearchRequestAccessLogMessage)msg);
                                break block8;
                            }
                            case UNBIND: {
                                this.processUnbindRequest((UnbindRequestAccessLogMessage)msg);
                            }
                        }
                        break;
                    }
                    case RESULT: {
                        switch (((OperationRequestAccessLogMessage)msg).getOperationType()) {
                            case ADD: {
                                this.processAddResult((AddResultAccessLogMessage)msg);
                                break block8;
                            }
                            case BIND: {
                                this.processBindResult((BindResultAccessLogMessage)msg);
                                break block8;
                            }
                            case COMPARE: {
                                this.processCompareResult((CompareResultAccessLogMessage)msg);
                                break block8;
                            }
                            case DELETE: {
                                this.processDeleteResult((DeleteResultAccessLogMessage)msg);
                                break block8;
                            }
                            case EXTENDED: {
                                this.processExtendedResult((ExtendedResultAccessLogMessage)msg);
                                break block8;
                            }
                            case MODIFY: {
                                this.processModifyResult((ModifyResultAccessLogMessage)msg);
                                break block8;
                            }
                            case MODDN: {
                                this.processModifyDNResult((ModifyDNResultAccessLogMessage)msg);
                                break block8;
                            }
                            case SEARCH: {
                                this.processSearchResult((SearchResultAccessLogMessage)msg);
                            }
                        }
                        break;
                    }
                }
            }
            try {
                reader.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            this.logDurationMillis += stopTime - startTime;
            for (Map.Entry<String, AtomicLong> e : this.outstandingFailedBindDNs.entrySet()) {
                String dn = e.getKey();
                AtomicLong outstandingFailureCount = e.getValue();
                AtomicLong consecutiveFailures = this.consecutiveFailedBindsByDN.get(dn);
                if (consecutiveFailures != null && outstandingFailureCount.get() <= consecutiveFailures.get()) continue;
                this.consecutiveFailedBindsByDN.put(dn, outstandingFailureCount);
            }
            this.outstandingFailedBindDNs.clear();
        }
        int numFiles = this.argumentParser.getTrailingArguments().size();
        this.out(new Object[0]);
        this.out("Examined ", logLines, " lines in ", numFiles, numFiles == 1 ? " file" : " files", " covering a total duration of ", StaticUtils.millisToHumanReadableDuration(this.logDurationMillis));
        if (logLines == 0L) {
            return ResultCode.SUCCESS;
        }
        this.out(new Object[0]);
        double logDurationSeconds = (double)this.logDurationMillis / 1000.0;
        double connectsPerSecond = (double)this.numConnects / logDurationSeconds;
        double disconnectsPerSecond = (double)this.numDisconnects / logDurationSeconds;
        this.out("Total connections established:  ", this.numConnects, " (", this.decimalFormat.format(connectsPerSecond), "/second)");
        this.out("Total disconnects:  ", this.numDisconnects, " (", this.decimalFormat.format(disconnectsPerSecond), "/second)");
        this.printCounts(this.clientAddresses, "Most common client addresses:", "address", "addresses");
        this.printCounts(this.clientConnectionPolicies, "Most common client connection policies:", "policy", "policies");
        this.printCounts(this.tlsProtocols, "Most common TLS protocol versions:", "version", "versions");
        this.printCounts(this.tlsCipherSuites, "Most common TLS cipher suites:", "cipher suite", "cipher suites");
        this.printCounts(this.disconnectReasons, "Most common disconnect reasons:", "reason", "reasons");
        long totalOps = this.numAbandons + this.numAdds + this.numBinds + this.numCompares + this.numDeletes + this.numExtended + this.numModifies + this.numModifyDNs + this.numSearches + this.numUnbinds;
        long totalResults = totalOps - this.numAbandons - this.numUnbinds;
        if (totalOps > 0L) {
            OIDRegistryItem item;
            String oid;
            double percent;
            long count;
            Object skippedWithLowerCount;
            AtomicLong skippedWithSameCount;
            ArrayList controlCounts;
            double percentAbandon = 100.0 * (double)this.numAbandons / (double)totalOps;
            double percentAdd = 100.0 * (double)this.numAdds / (double)totalOps;
            double percentBind = 100.0 * (double)this.numBinds / (double)totalOps;
            double percentCompare = 100.0 * (double)this.numCompares / (double)totalOps;
            double percentDelete = 100.0 * (double)this.numDeletes / (double)totalOps;
            double percentExtended = 100.0 * (double)this.numExtended / (double)totalOps;
            double percentModify = 100.0 * (double)this.numModifies / (double)totalOps;
            double percentModifyDN = 100.0 * (double)this.numModifyDNs / (double)totalOps;
            double percentSearch = 100.0 * (double)this.numSearches / (double)totalOps;
            double percentUnbind = 100.0 * (double)this.numUnbinds / (double)totalOps;
            double abandonsPerSecond = (double)this.numAbandons / logDurationSeconds;
            double addsPerSecond = (double)this.numAdds / logDurationSeconds;
            double bindsPerSecond = (double)this.numBinds / logDurationSeconds;
            double comparesPerSecond = (double)this.numCompares / logDurationSeconds;
            double deletesPerSecond = (double)this.numDeletes / logDurationSeconds;
            double extendedPerSecond = (double)this.numExtended / logDurationSeconds;
            double modifiesPerSecond = (double)this.numModifies / logDurationSeconds;
            double modifyDNsPerSecond = (double)this.numModifyDNs / logDurationSeconds;
            double searchesPerSecond = (double)this.numSearches / logDurationSeconds;
            double unbindsPerSecond = (double)this.numUnbinds / logDurationSeconds;
            this.out(new Object[0]);
            this.out("Total operations examined:  ", totalOps);
            this.out("Abandon operations examined:  ", this.numAbandons, " (", this.decimalFormat.format(percentAbandon), "%, ", this.decimalFormat.format(abandonsPerSecond), "/second)");
            this.out("Add operations examined:  ", this.numAdds, " (", this.decimalFormat.format(percentAdd), "%, ", this.decimalFormat.format(addsPerSecond), "/second)");
            this.out("Bind operations examined:  ", this.numBinds, " (", this.decimalFormat.format(percentBind), "%, ", this.decimalFormat.format(bindsPerSecond), "/second)");
            this.out("Compare operations examined:  ", this.numCompares, " (", this.decimalFormat.format(percentCompare), "%, ", this.decimalFormat.format(comparesPerSecond), "/second)");
            this.out("Delete operations examined:  ", this.numDeletes, " (", this.decimalFormat.format(percentDelete), "%, ", this.decimalFormat.format(deletesPerSecond), "/second)");
            this.out("Extended operations examined:  ", this.numExtended, " (", this.decimalFormat.format(percentExtended), "%, ", this.decimalFormat.format(extendedPerSecond), "/second)");
            this.out("Modify operations examined:  ", this.numModifies, " (", this.decimalFormat.format(percentModify), "%, ", this.decimalFormat.format(modifiesPerSecond), "/second)");
            this.out("Modify DN operations examined:  ", this.numModifyDNs, " (", this.decimalFormat.format(percentModifyDN), "%, ", this.decimalFormat.format(modifyDNsPerSecond), "/second)");
            this.out("Search operations examined:  ", this.numSearches, " (", this.decimalFormat.format(percentSearch), "%, ", this.decimalFormat.format(searchesPerSecond), "/second)");
            this.out("Unbind operations examined:  ", this.numUnbinds, " (", this.decimalFormat.format(percentUnbind), "%, ", this.decimalFormat.format(unbindsPerSecond), "/second)");
            double totalProcessingDuration = this.addProcessingDuration + this.bindProcessingDuration + this.compareProcessingDuration + this.deleteProcessingDuration + this.extendedProcessingDuration + this.modifyProcessingDuration + this.modifyDNProcessingDuration + this.searchProcessingDuration;
            this.out(new Object[0]);
            this.out("Average operation processing duration:  ", this.decimalFormat.format(totalProcessingDuration / (double)totalOps), "ms");
            if (this.numAdds > 0L) {
                this.out("Average add operation processing duration:  ", this.decimalFormat.format(this.addProcessingDuration / (double)this.numAdds), "ms");
            }
            if (this.numBinds > 0L) {
                this.out("Average bind operation processing duration:  ", this.decimalFormat.format(this.bindProcessingDuration / (double)this.numBinds), "ms");
            }
            if (this.numCompares > 0L) {
                this.out("Average compare operation processing duration:  ", this.decimalFormat.format(this.compareProcessingDuration / (double)this.numCompares), "ms");
            }
            if (this.numDeletes > 0L) {
                this.out("Average delete operation processing duration:  ", this.decimalFormat.format(this.deleteProcessingDuration / (double)this.numDeletes), "ms");
            }
            if (this.numExtended > 0L) {
                this.out("Average extended operation processing duration:  ", this.decimalFormat.format(this.extendedProcessingDuration / (double)this.numExtended), "ms");
            }
            if (this.numModifies > 0L) {
                this.out("Average modify operation processing duration:  ", this.decimalFormat.format(this.modifyProcessingDuration / (double)this.numModifies), "ms");
            }
            if (this.numModifyDNs > 0L) {
                this.out("Average modify DN operation processing duration:  ", this.decimalFormat.format(this.modifyDNProcessingDuration / (double)this.numModifyDNs), "ms");
            }
            if (this.numSearches > 0L) {
                this.out("Average search operation processing duration:  ", this.decimalFormat.format(this.searchProcessingDuration / (double)this.numSearches), "ms");
            }
            this.printProcessingTimeHistogram("add", this.numAdds, this.addProcessingTimes);
            this.printProcessingTimeHistogram("bind", this.numBinds, this.bindProcessingTimes);
            this.printProcessingTimeHistogram("compare", this.numCompares, this.compareProcessingTimes);
            this.printProcessingTimeHistogram("delete", this.numDeletes, this.deleteProcessingTimes);
            this.printProcessingTimeHistogram("extended", this.numExtended, this.extendedProcessingTimes);
            this.printProcessingTimeHistogram("modify", this.numModifies, this.modifyProcessingTimes);
            this.printProcessingTimeHistogram("modify DN", this.numModifyDNs, this.modifyDNProcessingTimes);
            this.printProcessingTimeHistogram("search", this.numSearches, this.searchProcessingTimes);
            if (this.totalWorkQueueWaitTime > 0L) {
                this.out(new Object[0]);
                this.out("Average work queue wait time:  ", this.decimalFormat.format(this.totalWorkQueueWaitTime / totalResults), "ms");
                this.printHistogram("Count of operations by work queue wait time:", totalResults, this.workQueueWaitTimes);
            }
            this.printResultCodeCounts(this.addResultCodes, "add");
            this.printResultCodeCounts(this.bindResultCodes, "bind");
            this.printResultCodeCounts(this.compareResultCodes, "compare");
            this.printResultCodeCounts(this.deleteResultCodes, "delete");
            this.printResultCodeCounts(this.extendedResultCodes, "extended");
            this.printResultCodeCounts(this.modifyResultCodes, "modify");
            this.printResultCodeCounts(this.modifyDNResultCodes, "modify DN");
            this.printResultCodeCounts(this.searchResultCodes, "search");
            this.printCounts(this.preAuthzPrivilegesUsed, "Most common pre-authorization privileges used:", "privilege", "privileges");
            this.printCounts(this.privilegesUsed, "Most common privileges used:", "privilege", "privileges");
            this.printCounts(this.privilegesMissing, "Most common missing privileges:", "privilege", "privileges");
            this.printCounts(this.successfulBindDNs, "Most common bind DNs used in successful authentication attempts:", "DN", "DNs");
            this.printCounts(this.bindFailuresByDN, "Most common bind DNs used in failed authentication attempts:", "DN", "DNs");
            this.printCounts(this.bindFailuresByIPAddress, "Most common IP addresses used in failed authentication attempts:", "IP", "IPs");
            if (this.doNotAnonymize.isPresent()) {
                this.printCounts(this.consecutiveFailedBindsByDN, "Bind DNs with the most consecutive authentication failures:", "DN", "DNs");
            }
            this.printCounts(this.authenticationTypes, "Most common authentication types:", "authentication type", "authentication types");
            long numResultsWithAuthzID = 0L;
            for (AtomicLong l : this.authzDNs.values()) {
                numResultsWithAuthzID += l.get();
            }
            this.out(new Object[0]);
            double percentWithAuthzID = 100.0 * (double)numResultsWithAuthzID / (double)totalOps;
            this.out("Number of operations with an alternate authorization identity:  ", numResultsWithAuthzID, " (", this.decimalFormat.format(percentWithAuthzID), "%)");
            this.printCounts(this.authzDNs, "Most common alternate authorization identity DNs:", "DN", "DNs");
            if (!this.requestControlOIDs.isEmpty()) {
                controlCounts = new ArrayList();
                skippedWithSameCount = new AtomicLong(0L);
                skippedWithLowerCount = new AtomicLong(0L);
                SummarizeAccessLog.getMostCommonElements(this.requestControlOIDs, controlCounts, displayCount, skippedWithSameCount, (AtomicLong)skippedWithLowerCount);
                this.out(new Object[0]);
                this.out("Most common request control types:");
                count = -1L;
                for (ObjectPair objectPair : controlCounts) {
                    count = (Long)objectPair.getSecond();
                    percent = 100.0 * (double)count / (double)this.numRequestControls;
                    oid = (String)objectPair.getFirst();
                    item = OIDRegistry.getDefault().get(oid);
                    if (item == null) {
                        this.out(objectPair.getFirst(), ":  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                        continue;
                    }
                    this.out(objectPair.getFirst(), " (", item.getName(), "):  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                }
                if (skippedWithSameCount.get() > 0L) {
                    this.out("{ Skipped " + skippedWithSameCount.get() + " additional " + this.getSingularOrPlural(skippedWithSameCount.get(), "control", "controls") + " with a count of " + count + " }");
                }
                if (((AtomicLong)skippedWithLowerCount).get() > 0L) {
                    this.out("{ Skipped " + ((AtomicLong)skippedWithLowerCount).get() + " additional " + this.getSingularOrPlural(((AtomicLong)skippedWithLowerCount).get(), "control", "controls") + " with a count that is less than " + count + " }");
                }
            }
            if (!this.responseControlOIDs.isEmpty()) {
                controlCounts = new ArrayList();
                skippedWithSameCount = new AtomicLong(0L);
                skippedWithLowerCount = new AtomicLong(0L);
                SummarizeAccessLog.getMostCommonElements(this.responseControlOIDs, controlCounts, displayCount, skippedWithSameCount, (AtomicLong)skippedWithLowerCount);
                this.out(new Object[0]);
                this.out("Most common response control types:");
                count = -1L;
                for (ObjectPair objectPair : controlCounts) {
                    count = (Long)objectPair.getSecond();
                    percent = 100.0 * (double)count / (double)this.numResponseControls;
                    oid = (String)objectPair.getFirst();
                    item = OIDRegistry.getDefault().get(oid);
                    if (item == null) {
                        this.out(objectPair.getFirst(), ":  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                        continue;
                    }
                    this.out(objectPair.getFirst(), " (", item.getName(), "):  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                }
                if (skippedWithSameCount.get() > 0L) {
                    this.out("{ Skipped " + skippedWithSameCount.get() + " additional " + this.getSingularOrPlural(skippedWithSameCount.get(), "control", "controls") + " with a count of " + count + " }");
                }
                if (((AtomicLong)skippedWithLowerCount).get() > 0L) {
                    this.out("{ Skipped " + ((AtomicLong)skippedWithLowerCount).get() + " additional " + this.getSingularOrPlural(((AtomicLong)skippedWithLowerCount).get(), "control", "controls") + " with a count that is less than " + count + " }");
                }
            }
            if (!this.extendedOperations.isEmpty()) {
                ArrayList extOpCounts = new ArrayList();
                skippedWithSameCount = new AtomicLong(0L);
                skippedWithLowerCount = new AtomicLong(0L);
                SummarizeAccessLog.getMostCommonElements(this.extendedOperations, extOpCounts, displayCount, skippedWithSameCount, (AtomicLong)skippedWithLowerCount);
                this.out(new Object[0]);
                this.out("Most common extended operation types:");
                count = -1L;
                for (ObjectPair objectPair : extOpCounts) {
                    count = (Long)objectPair.getSecond();
                    percent = 100.0 * (double)count / (double)this.numExtended;
                    oid = (String)objectPair.getFirst();
                    String name = this.extendedOperationOIDsToNames.get(oid);
                    if (name == null) {
                        this.out(objectPair.getFirst(), ":  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                        continue;
                    }
                    this.out(objectPair.getFirst(), " (", name, "):  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                }
                if (skippedWithSameCount.get() > 0L) {
                    this.out("{ Skipped " + skippedWithSameCount.get() + " additional extended " + this.getSingularOrPlural(skippedWithSameCount.get(), "operation", "operations") + " with a count of " + count + " }");
                }
                if (((AtomicLong)skippedWithLowerCount).get() > 0L) {
                    this.out("{ Skipped " + ((AtomicLong)skippedWithLowerCount).get() + " additional extended " + this.getSingularOrPlural(((AtomicLong)skippedWithLowerCount).get(), "operation", "operations") + " with a count that is less than " + count + " }");
                }
            }
            this.out(new Object[0]);
            this.out("Number of unindexed search attempts:  ", this.numUnindexedAttempts);
            this.out("Number of successfully-completed unindexed searches:  ", this.numUnindexedSuccessful);
            this.out("Number of failed unindexed searches:  ", this.numUnindexedFailed);
            this.printCounts(this.unindexedFilters, "Most common unindexed search filters:", "filter", "filters");
            if (!this.searchScopes.isEmpty()) {
                ArrayList scopeCounts = new ArrayList();
                skippedWithSameCount = new AtomicLong(0L);
                skippedWithLowerCount = new AtomicLong(0L);
                SummarizeAccessLog.getMostCommonElements(this.searchScopes, scopeCounts, displayCount, skippedWithSameCount, (AtomicLong)skippedWithLowerCount);
                this.out(new Object[0]);
                this.out("Most common search scopes:");
                count = -1L;
                for (ObjectPair objectPair : scopeCounts) {
                    count = (Long)objectPair.getSecond();
                    percent = 100.0 * (double)count / (double)this.numSearches;
                    this.out(((SearchScope)objectPair.getFirst()).getName().toLowerCase(), " (", ((SearchScope)objectPair.getFirst()).intValue(), "):  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                }
                if (skippedWithSameCount.get() > 0L) {
                    this.out("{ Skipped " + skippedWithSameCount.get() + " additional " + this.getSingularOrPlural(skippedWithSameCount.get(), "scope", "scopes") + " with a count of " + count + " }");
                }
                if (((AtomicLong)skippedWithLowerCount).get() > 0L) {
                    this.out("{ Skipped " + ((AtomicLong)skippedWithLowerCount).get() + " additional " + this.getSingularOrPlural(((AtomicLong)skippedWithLowerCount).get(), "scope", "scopes") + " with a count that is less than " + count + " }");
                }
            }
            if (!this.searchEntryCounts.isEmpty()) {
                ArrayList entryCounts = new ArrayList();
                skippedWithSameCount = new AtomicLong(0L);
                skippedWithLowerCount = new AtomicLong(0L);
                SummarizeAccessLog.getMostCommonElements(this.searchEntryCounts, entryCounts, displayCount, skippedWithSameCount, (AtomicLong)skippedWithLowerCount);
                this.out(new Object[0]);
                this.out("Most common search entry counts:");
                count = -1L;
                Iterator iterator = entryCounts.iterator();
                while (iterator.hasNext()) {
                    ObjectPair objectPair = (ObjectPair)iterator.next();
                    count = (Long)objectPair.getSecond();
                    percent = 100.0 * (double)count / (double)this.numSearches;
                    this.out(objectPair.getFirst(), " matching ", this.getSingularOrPlural((Long)objectPair.getFirst(), "entry", "entries"), ":  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                }
                if (skippedWithSameCount.get() > 0L) {
                    this.out("{ Skipped " + skippedWithSameCount.get() + " additional entry " + this.getSingularOrPlural(skippedWithSameCount.get(), "count", "counts") + " with a count of " + count + " }");
                }
                if (((AtomicLong)skippedWithLowerCount).get() > 0L) {
                    this.out("{ Skipped " + ((AtomicLong)skippedWithLowerCount).get() + " additional entry " + this.getSingularOrPlural(((AtomicLong)skippedWithLowerCount).get(), "count", "counts") + " with a count that is less than " + count + " }");
                }
            }
            this.printCounts(this.searchBaseDNs, "Most common base DNs for searches with a non-base scope:", "base DN", "base DNs");
            this.printCounts(this.filterTypes, "Most common filters for searches with a non-base scope:", "filter", "filters");
            this.printCounts(this.filterComponentCounts, "Most common search filter component counts:", "filter", "filters");
            if (this.doNotAnonymize.isPresent() && !this.filtersRepresentingPotentialInjectionAttempt.isEmpty()) {
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, "Search filters that may indicate an unsuccessful injection attempt.  These include filters with an assertion value that contains one or more of the following:  parentheses, ampersands, pipes, single quotes, double quotes, or the words 'select' and 'from':");
                for (Filter f : this.filtersRepresentingPotentialInjectionAttempt) {
                    this.out("* " + f.toString());
                }
            }
            if (this.numSearches > 0L) {
                long numSearchesMatchingNoEntries = 0L;
                for (AtomicLong l : this.noEntryFilters.values()) {
                    numSearchesMatchingNoEntries += l.get();
                }
                this.out(new Object[0]);
                double noEntryPercent = 100.0 * (double)numSearchesMatchingNoEntries / (double)this.numSearches;
                this.out("Number of searches matching no entries:  ", numSearchesMatchingNoEntries, " (", this.decimalFormat.format(noEntryPercent), "%)");
                this.printCounts(this.noEntryFilters, "Most common filters for searches matching no entries:", "filter", "filters");
                long numSearchesMatchingOneEntry = 0L;
                for (AtomicLong l : this.oneEntryFilters.values()) {
                    numSearchesMatchingOneEntry += l.get();
                }
                this.out(new Object[0]);
                double d = 100.0 * (double)numSearchesMatchingOneEntry / (double)this.numSearches;
                this.out("Number of searches matching one entry:  ", numSearchesMatchingOneEntry, " (", this.decimalFormat.format(d), "%)");
                this.printCounts(this.oneEntryFilters, "Most common filters for searches matching one entry:", "filter", "filters");
                long numSearchesMatchingMultipleEntries = 0L;
                for (AtomicLong l : this.multiEntryFilters.values()) {
                    numSearchesMatchingMultipleEntries += l.get();
                }
                this.out(new Object[0]);
                double multiEntryPercent = 100.0 * (double)numSearchesMatchingMultipleEntries / (double)this.numSearches;
                this.out("Number of searches matching multiple entries:  ", numSearchesMatchingMultipleEntries, " (", this.decimalFormat.format(multiEntryPercent), "%)");
                this.printCounts(this.multiEntryFilters, "Most common filters for searches matching multiple entries:", "filter", "filters");
            }
        }
        if (!this.mostExpensiveFilters.isEmpty()) {
            ArrayList filterDurations = new ArrayList();
            AtomicLong skippedWithSameCount = new AtomicLong(0L);
            AtomicLong skippedWithLowerCount = new AtomicLong(0L);
            SummarizeAccessLog.getMostCommonElements(this.mostExpensiveFilters, filterDurations, displayCount, skippedWithSameCount, skippedWithLowerCount);
            this.out(new Object[0]);
            this.out("Filters for searches with the longest processing times:");
            String durationStr = "";
            for (ObjectPair objectPair : filterDurations) {
                long durationMicros = (Long)objectPair.getSecond();
                double durationMillis = (double)durationMicros / 1000.0;
                durationStr = this.decimalFormat.format(durationMillis) + " ms";
                this.out(objectPair.getFirst(), ":  ", durationStr);
            }
            if (skippedWithSameCount.get() > 0L) {
                this.out("{ Skipped " + skippedWithSameCount.get() + " additional " + this.getSingularOrPlural(skippedWithSameCount.get(), "filter", "filters") + " with a duration of " + durationStr + " }");
            }
            if (skippedWithLowerCount.get() > 0L) {
                this.out("{ Skipped " + skippedWithLowerCount.get() + " additional " + this.getSingularOrPlural(skippedWithLowerCount.get(), "filter", "filters") + " with a duration that is less than " + durationStr + " }");
            }
        }
        if ((totalUncached = this.numUncachedAdds + this.numUncachedBinds + this.numUncachedCompares + this.numUncachedDeletes + this.numUncachedExtended + this.numUncachedModifies + this.numUncachedModifyDNs + this.numUncachedSearches) > 0L) {
            this.out(new Object[0]);
            this.out("Operations accessing uncached data:");
            this.printUncached("Add", this.numUncachedAdds, this.numAdds);
            this.printUncached("Bind", this.numUncachedBinds, this.numBinds);
            this.printUncached("Compare", this.numUncachedCompares, this.numCompares);
            this.printUncached("Delete", this.numUncachedDeletes, this.numDeletes);
            this.printUncached("Extended", this.numUncachedExtended, this.numExtended);
            this.printUncached("Modify", this.numUncachedModifies, this.numModifies);
            this.printUncached("Modify DN", this.numUncachedModifyDNs, this.numModifyDNs);
            this.printUncached("Search", this.numUncachedSearches, this.numSearches);
        }
        return ResultCode.SUCCESS;
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(1));
        String[] args = new String[]{"/ds/logs/access"};
        String description = "Analyze the contents of the /ds/logs/access access log file.";
        examples.put(args, "Analyze the contents of the /ds/logs/access access log file.");
        return examples;
    }

    private static void populateProcessingTimeMap(@NotNull HashMap<Long, AtomicLong> m) {
        m.put(1L, new AtomicLong(0L));
        m.put(2L, new AtomicLong(0L));
        m.put(3L, new AtomicLong(0L));
        m.put(5L, new AtomicLong(0L));
        m.put(10L, new AtomicLong(0L));
        m.put(20L, new AtomicLong(0L));
        m.put(30L, new AtomicLong(0L));
        m.put(50L, new AtomicLong(0L));
        m.put(100L, new AtomicLong(0L));
        m.put(1000L, new AtomicLong(0L));
        m.put(2000L, new AtomicLong(0L));
        m.put(3000L, new AtomicLong(0L));
        m.put(5000L, new AtomicLong(0L));
        m.put(10000L, new AtomicLong(0L));
        m.put(20000L, new AtomicLong(0L));
        m.put(30000L, new AtomicLong(0L));
        m.put(60000L, new AtomicLong(0L));
        m.put(Long.MAX_VALUE, new AtomicLong(0L));
    }

    private void processConnect(@NotNull ConnectAccessLogMessage m) {
        String ccp;
        ++this.numConnects;
        String clientAddr = m.getSourceAddress();
        if (clientAddr != null) {
            AtomicLong count;
            Long connectionID = m.getConnectionID();
            if (connectionID != null) {
                this.ipAddressesByConnectionID.put(connectionID, clientAddr);
            }
            if ((count = this.clientAddresses.get(clientAddr)) == null) {
                count = new AtomicLong(0L);
                this.clientAddresses.put(clientAddr, count);
            }
            count.incrementAndGet();
        }
        if ((ccp = m.getClientConnectionPolicy()) != null) {
            AtomicLong l = this.clientConnectionPolicies.get(ccp);
            if (l == null) {
                l = new AtomicLong(0L);
                this.clientConnectionPolicies.put(ccp, l);
            }
            l.incrementAndGet();
        }
    }

    private void processSecurityNegotiation(@NotNull SecurityNegotiationAccessLogMessage m) {
        String cipherSuite;
        String protocol = m.getProtocol();
        if (protocol != null) {
            AtomicLong l = this.tlsProtocols.get(protocol);
            if (l == null) {
                l = new AtomicLong(0L);
                this.tlsProtocols.put(protocol, l);
            }
            l.incrementAndGet();
        }
        if ((cipherSuite = m.getCipher()) != null) {
            AtomicLong l = this.tlsCipherSuites.get(cipherSuite);
            if (l == null) {
                l = new AtomicLong(0L);
                this.tlsCipherSuites.put(cipherSuite, l);
            }
            l.incrementAndGet();
        }
    }

    private void processDisconnect(@NotNull DisconnectAccessLogMessage m) {
        String reason;
        ++this.numDisconnects;
        Long connectionID = m.getConnectionID();
        if (connectionID != null) {
            this.ipAddressesByConnectionID.remove(connectionID);
        }
        if ((reason = m.getDisconnectReason()) != null) {
            AtomicLong l = this.disconnectReasons.get(reason);
            if (l == null) {
                l = new AtomicLong(0L);
                this.disconnectReasons.put(reason, l);
            }
            l.incrementAndGet();
        }
    }

    private void processAbandonRequest(@NotNull AbandonRequestAccessLogMessage m) {
        ++this.numAbandons;
    }

    private void processExtendedRequest(@NotNull ExtendedRequestAccessLogMessage m) {
        this.processedRequests.add(m.getConnectionID() + "-" + m.getOperationID());
        this.processExtendedRequestInternal(m);
    }

    private void processExtendedRequestInternal(@NotNull ExtendedRequestAccessLogMessage m) {
        String oid = m.getRequestOID();
        if (oid != null) {
            AtomicLong l = this.extendedOperations.get(oid);
            if (l == null) {
                l = new AtomicLong(0L);
                this.extendedOperations.put(oid, l);
            }
            l.incrementAndGet();
            String requestType = m.getRequestType();
            if (requestType != null && !this.extendedOperationOIDsToNames.containsKey(oid)) {
                this.extendedOperationOIDsToNames.put(oid, requestType);
            }
        }
    }

    private void processSearchRequest(@NotNull SearchRequestAccessLogMessage m) {
        this.processedRequests.add(m.getConnectionID() + "-" + m.getOperationID());
        this.processSearchRequestInternal(m);
    }

    private void processSearchRequestInternal(@NotNull SearchRequestAccessLogMessage m) {
        String filterString;
        SearchScope scope = m.getScope();
        if (scope != null) {
            String filterString2;
            AtomicLong scopeCount = this.searchScopes.get(scope);
            if (scopeCount == null) {
                scopeCount = new AtomicLong(0L);
                this.searchScopes.put(scope, scopeCount);
            }
            scopeCount.incrementAndGet();
            if (!scope.equals(SearchScope.BASE) && (filterString2 = this.prepareFilter(m.getFilter())) != null) {
                AtomicLong filterCount = this.filterTypes.get(filterString2);
                if (filterCount == null) {
                    filterCount = new AtomicLong(0L);
                    this.filterTypes.put(filterString2, filterCount);
                }
                filterCount.incrementAndGet();
                String baseDN = this.getDNString(m.getBaseDN());
                if (baseDN != null) {
                    AtomicLong baseDNCount = this.searchBaseDNs.get(baseDN);
                    if (baseDNCount == null) {
                        baseDNCount = new AtomicLong(0L);
                        this.searchBaseDNs.put(baseDN, baseDNCount);
                    }
                    baseDNCount.incrementAndGet();
                }
            }
        }
        if ((filterString = m.getFilter()) != null) {
            try {
                int numComponents;
                String label;
                AtomicLong count;
                Filter filter = Filter.create(filterString);
                if (SummarizeAccessLog.mayRepresentInjectionAttempt(filter)) {
                    this.filtersRepresentingPotentialInjectionAttempt.add(filter);
                }
                if ((count = this.filterComponentCounts.get(label = (numComponents = SummarizeAccessLog.countComponents(filter)) == 1 ? "1 component" : numComponents + " components")) == null) {
                    count = new AtomicLong(0L);
                    this.filterComponentCounts.put(label, count);
                }
                count.incrementAndGet();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }

    static boolean mayRepresentInjectionAttempt(@NotNull Filter filter) {
        switch (filter.getFilterType()) {
            case -96: 
            case -95: {
                for (Filter f : filter.getComponents()) {
                    if (!SummarizeAccessLog.mayRepresentInjectionAttempt(f)) continue;
                    return true;
                }
                return false;
            }
            case -94: {
                return SummarizeAccessLog.mayRepresentInjectionAttempt(filter.getNOTComponent());
            }
            case -93: 
            case -91: 
            case -90: 
            case -88: 
            case -87: {
                return SummarizeAccessLog.mayRepresentInjectionAttempt(filter.getAssertionValue());
            }
            case -92: {
                String[] subAnyStrings = filter.getSubAnyStrings();
                if (subAnyStrings != null) {
                    for (String subAnyString : subAnyStrings) {
                        if (!SummarizeAccessLog.mayRepresentInjectionAttempt(subAnyString)) continue;
                        return true;
                    }
                }
                return SummarizeAccessLog.mayRepresentInjectionAttempt(filter.getSubInitialString()) || SummarizeAccessLog.mayRepresentInjectionAttempt(filter.getSubFinalString());
            }
        }
        return false;
    }

    private static boolean mayRepresentInjectionAttempt(@Nullable String value) {
        if (value == null) {
            return false;
        }
        String lowerValue = StaticUtils.toLowerCase(value);
        return lowerValue.contains("(") || lowerValue.contains(")") || lowerValue.contains("&") || lowerValue.contains("|") || lowerValue.contains("\"") || lowerValue.contains("'") || lowerValue.contains("select") && lowerValue.contains("from");
    }

    static int countComponents(@NotNull Filter filter) {
        switch (filter.getFilterType()) {
            case -96: 
            case -95: {
                int count = 1;
                for (Filter f : filter.getComponents()) {
                    count += SummarizeAccessLog.countComponents(f);
                }
                return count;
            }
            case -94: {
                return 1 + SummarizeAccessLog.countComponents(filter.getNOTComponent());
            }
        }
        return 1;
    }

    private void processUnbindRequest(@NotNull UnbindRequestAccessLogMessage m) {
        ++this.numUnbinds;
    }

    private void processAddResult(@NotNull AddResultAccessLogMessage m) {
        ++this.numAdds;
        this.updateCommonResult(m);
        SummarizeAccessLog.updateResultCodeCount(m.getResultCode(), this.addResultCodes);
        this.addProcessingDuration += SummarizeAccessLog.doubleValue(m.getProcessingTimeMillis(), this.addProcessingTimes);
        Boolean uncachedDataAccessed = m.getUncachedDataAccessed();
        if (uncachedDataAccessed != null && uncachedDataAccessed.booleanValue()) {
            ++this.numUncachedAdds;
        }
        this.updateAuthzCount(m.getAlternateAuthorizationDN());
    }

    private void processBindResult(@NotNull BindResultAccessLogMessage m) {
        AtomicLong l;
        ++this.numBinds;
        this.updateCommonResult(m);
        if (m.getAuthenticationType() != null) {
            String authType;
            switch (m.getAuthenticationType()) {
                case SIMPLE: {
                    authType = "Simple";
                    break;
                }
                case SASL: {
                    String saslMechanism = m.getSASLMechanismName();
                    if (saslMechanism == null) {
                        authType = "SASL {unknown mechanism}";
                        break;
                    }
                    authType = "SASL " + saslMechanism;
                    break;
                }
                case INTERNAL: {
                    authType = "Internal";
                    break;
                }
                default: {
                    authType = m.getAuthenticationType().name();
                }
            }
            l = this.authenticationTypes.get(authType);
            if (l == null) {
                l = new AtomicLong(0L);
                this.authenticationTypes.put(authType, l);
            }
            l.incrementAndGet();
        }
        SummarizeAccessLog.updateResultCodeCount(m.getResultCode(), this.bindResultCodes);
        this.bindProcessingDuration += SummarizeAccessLog.doubleValue(m.getProcessingTimeMillis(), this.bindProcessingTimes);
        String authenticationDN = this.getDNString(m.getAuthenticationDN());
        if (m.getResultCode() == ResultCode.SUCCESS) {
            String ccp;
            if (authenticationDN != null) {
                AtomicLong consecutiveFailures;
                l = this.successfulBindDNs.get(authenticationDN);
                if (l == null) {
                    l = new AtomicLong(0L);
                    this.successfulBindDNs.put(authenticationDN, l);
                }
                l.incrementAndGet();
                AtomicLong outstandingFailures = this.outstandingFailedBindDNs.remove(authenticationDN);
                if (outstandingFailures != null && ((consecutiveFailures = this.consecutiveFailedBindsByDN.get(authenticationDN)) == null || outstandingFailures.get() > consecutiveFailures.get())) {
                    this.consecutiveFailedBindsByDN.put(authenticationDN, new AtomicLong(outstandingFailures.get()));
                }
            }
            if ((ccp = m.getClientConnectionPolicy()) != null) {
                AtomicLong l2 = this.clientConnectionPolicies.get(ccp);
                if (l2 == null) {
                    l2 = new AtomicLong(0L);
                    this.clientConnectionPolicies.put(ccp, l2);
                }
                l2.incrementAndGet();
            }
        } else if (m.getResultCode() != ResultCode.SASL_BIND_IN_PROGRESS && m.getResultCode() != ResultCode.REFERRAL) {
            Long connectionID;
            String ipAddress;
            if (authenticationDN == null) {
                authenticationDN = this.getDNString(m.getDN());
            }
            if (authenticationDN != null) {
                l = this.bindFailuresByDN.get(authenticationDN);
                if (l == null) {
                    l = new AtomicLong(0L);
                    this.bindFailuresByDN.put(authenticationDN, l);
                }
                l.incrementAndGet();
                l = this.outstandingFailedBindDNs.get(authenticationDN);
                if (l == null) {
                    l = new AtomicLong(0L);
                    this.outstandingFailedBindDNs.put(authenticationDN, l);
                }
                l.incrementAndGet();
            }
            if ((ipAddress = m.getRequesterIPAddress()) == null && (connectionID = m.getConnectionID()) != null) {
                ipAddress = this.ipAddressesByConnectionID.get(connectionID);
            }
            if (ipAddress != null) {
                AtomicLong l3 = this.bindFailuresByIPAddress.get(ipAddress);
                if (l3 == null) {
                    l3 = new AtomicLong(0L);
                    this.bindFailuresByIPAddress.put(ipAddress, l3);
                }
                l3.incrementAndGet();
            }
        }
        Boolean uncachedDataAccessed = m.getUncachedDataAccessed();
        if (uncachedDataAccessed != null && uncachedDataAccessed.booleanValue()) {
            ++this.numUncachedBinds;
        }
        this.updateAuthzCount(m.getAuthorizationDN());
    }

    private void processCompareResult(@NotNull CompareResultAccessLogMessage m) {
        ++this.numCompares;
        this.updateCommonResult(m);
        SummarizeAccessLog.updateResultCodeCount(m.getResultCode(), this.compareResultCodes);
        this.compareProcessingDuration += SummarizeAccessLog.doubleValue(m.getProcessingTimeMillis(), this.compareProcessingTimes);
        Boolean uncachedDataAccessed = m.getUncachedDataAccessed();
        if (uncachedDataAccessed != null && uncachedDataAccessed.booleanValue()) {
            ++this.numUncachedCompares;
        }
        this.updateAuthzCount(m.getAlternateAuthorizationDN());
    }

    private void processDeleteResult(@NotNull DeleteResultAccessLogMessage m) {
        ++this.numDeletes;
        this.updateCommonResult(m);
        SummarizeAccessLog.updateResultCodeCount(m.getResultCode(), this.deleteResultCodes);
        this.deleteProcessingDuration += SummarizeAccessLog.doubleValue(m.getProcessingTimeMillis(), this.deleteProcessingTimes);
        Boolean uncachedDataAccessed = m.getUncachedDataAccessed();
        if (uncachedDataAccessed != null && uncachedDataAccessed.booleanValue()) {
            ++this.numUncachedDeletes;
        }
        this.updateAuthzCount(m.getAlternateAuthorizationDN());
    }

    private void processExtendedResult(@NotNull ExtendedResultAccessLogMessage m) {
        Boolean uncachedDataAccessed;
        ++this.numExtended;
        this.updateCommonResult(m);
        String id = m.getConnectionID() + "-" + m.getOperationID();
        if (!this.processedRequests.remove(id)) {
            this.processExtendedRequestInternal(m);
        }
        SummarizeAccessLog.updateResultCodeCount(m.getResultCode(), this.extendedResultCodes);
        this.extendedProcessingDuration += SummarizeAccessLog.doubleValue(m.getProcessingTimeMillis(), this.extendedProcessingTimes);
        String ccp = m.getClientConnectionPolicy();
        if (ccp != null) {
            AtomicLong l = this.clientConnectionPolicies.get(ccp);
            if (l == null) {
                l = new AtomicLong(0L);
                this.clientConnectionPolicies.put(ccp, l);
            }
            l.incrementAndGet();
        }
        if ((uncachedDataAccessed = m.getUncachedDataAccessed()) != null && uncachedDataAccessed.booleanValue()) {
            ++this.numUncachedExtended;
        }
    }

    private void processModifyResult(@NotNull ModifyResultAccessLogMessage m) {
        ++this.numModifies;
        this.updateCommonResult(m);
        SummarizeAccessLog.updateResultCodeCount(m.getResultCode(), this.modifyResultCodes);
        this.modifyProcessingDuration += SummarizeAccessLog.doubleValue(m.getProcessingTimeMillis(), this.modifyProcessingTimes);
        Boolean uncachedDataAccessed = m.getUncachedDataAccessed();
        if (uncachedDataAccessed != null && uncachedDataAccessed.booleanValue()) {
            ++this.numUncachedModifies;
        }
        this.updateAuthzCount(m.getAlternateAuthorizationDN());
    }

    private void processModifyDNResult(@NotNull ModifyDNResultAccessLogMessage m) {
        ++this.numModifyDNs;
        this.updateCommonResult(m);
        SummarizeAccessLog.updateResultCodeCount(m.getResultCode(), this.modifyDNResultCodes);
        this.modifyDNProcessingDuration += SummarizeAccessLog.doubleValue(m.getProcessingTimeMillis(), this.modifyDNProcessingTimes);
        Boolean uncachedDataAccessed = m.getUncachedDataAccessed();
        if (uncachedDataAccessed != null && uncachedDataAccessed.booleanValue()) {
            ++this.numUncachedModifyDNs;
        }
        this.updateAuthzCount(m.getAlternateAuthorizationDN());
    }

    private void processSearchResult(@NotNull SearchResultAccessLogMessage m) {
        Boolean uncachedDataAccessed;
        Boolean isUnindexed;
        ++this.numSearches;
        this.updateCommonResult(m);
        String id = m.getConnectionID() + "-" + m.getOperationID();
        if (!this.processedRequests.remove(id)) {
            this.processSearchRequestInternal(m);
        }
        ResultCode resultCode = m.getResultCode();
        SummarizeAccessLog.updateResultCodeCount(resultCode, this.searchResultCodes);
        this.searchProcessingDuration += SummarizeAccessLog.doubleValue(m.getProcessingTimeMillis(), this.searchProcessingTimes);
        String filterString = this.prepareFilter(m.getFilter());
        Long entryCount = m.getEntriesReturned();
        if (entryCount != null) {
            HashMap<String, AtomicLong> filterCountMap;
            AtomicLong l = this.searchEntryCounts.get(entryCount);
            if (l == null) {
                l = new AtomicLong(0L);
                this.searchEntryCounts.put(entryCount, l);
            }
            l.incrementAndGet();
            switch (entryCount.intValue()) {
                case 0: {
                    filterCountMap = this.noEntryFilters;
                    break;
                }
                case 1: {
                    filterCountMap = this.oneEntryFilters;
                    break;
                }
                default: {
                    filterCountMap = this.multiEntryFilters;
                }
            }
            if (filterString != null) {
                AtomicLong filterCount = (AtomicLong)filterCountMap.get(filterString);
                if (filterCount == null) {
                    filterCount = new AtomicLong(0L);
                    filterCountMap.put(filterString, filterCount);
                }
                filterCount.incrementAndGet();
            }
        }
        if ((isUnindexed = m.getUnindexed()) != null && isUnindexed.booleanValue()) {
            ++this.numUnindexedAttempts;
            if (resultCode == ResultCode.SUCCESS) {
                ++this.numUnindexedSuccessful;
            } else {
                ++this.numUnindexedFailed;
            }
            if (filterString != null) {
                AtomicLong l = this.unindexedFilters.get(filterString);
                if (l == null) {
                    l = new AtomicLong(0L);
                    this.unindexedFilters.put(filterString, l);
                }
                l.incrementAndGet();
            }
        }
        if ((uncachedDataAccessed = m.getUncachedDataAccessed()) != null && uncachedDataAccessed.booleanValue()) {
            ++this.numUncachedSearches;
        }
        this.updateAuthzCount(m.getAlternateAuthorizationDN());
        Double processingTimeMillis = m.getProcessingTimeMillis();
        if (processingTimeMillis != null && filterString != null) {
            long processingTimeMicros = Math.round(processingTimeMillis * 1000.0);
            AtomicLong l = this.mostExpensiveFilters.get(filterString);
            if (l == null) {
                l = new AtomicLong(processingTimeMicros);
                this.mostExpensiveFilters.put(filterString, l);
            } else {
                long previousProcessingTimeMicros = l.get();
                if (processingTimeMicros > previousProcessingTimeMicros) {
                    l.set(processingTimeMicros);
                }
            }
        }
    }

    private void updateCommonResult(@NotNull OperationResultAccessLogMessage m) {
        this.totalWorkQueueWaitTime = (long)((double)this.totalWorkQueueWaitTime + SummarizeAccessLog.doubleValue(m.getWorkQueueWaitTimeMillis(), this.workQueueWaitTimes));
        for (String oid : m.getRequestControlOIDs()) {
            ++this.numRequestControls;
            SummarizeAccessLog.updateCount(this.requestControlOIDs, oid);
        }
        for (String oid : m.getResponseControlOIDs()) {
            ++this.numResponseControls;
            SummarizeAccessLog.updateCount(this.responseControlOIDs, oid);
        }
        for (String privilegeName : m.getPreAuthorizationUsedPrivileges()) {
            SummarizeAccessLog.updateCount(this.preAuthzPrivilegesUsed, privilegeName);
        }
        for (String privilegeName : m.getUsedPrivileges()) {
            SummarizeAccessLog.updateCount(this.privilegesUsed, privilegeName);
        }
        for (String privilegeName : m.getMissingPrivileges()) {
            SummarizeAccessLog.updateCount(this.privilegesMissing, privilegeName);
        }
    }

    private static void updateCount(@NotNull Map<String, AtomicLong> m, @NotNull String key) {
        AtomicLong count = m.get(key);
        if (count == null) {
            count = new AtomicLong(0L);
            m.put(key, count);
        }
        count.incrementAndGet();
    }

    private static void updateResultCodeCount(@Nullable ResultCode rc, @NotNull HashMap<ResultCode, AtomicLong> m) {
        if (rc == null) {
            return;
        }
        AtomicLong l = m.get(rc);
        if (l == null) {
            l = new AtomicLong(0L);
            m.put(rc, l);
        }
        l.incrementAndGet();
    }

    private static double doubleValue(@Nullable Double d, @NotNull HashMap<Long, AtomicLong> m) {
        if (d == null) {
            return 0.0;
        }
        for (Map.Entry<Long, AtomicLong> e : m.entrySet()) {
            if (!(d <= (double)e.getKey().longValue())) continue;
            e.getValue().incrementAndGet();
            break;
        }
        return d;
    }

    @NotNull
    private static <K> List<ObjectPair<K, Long>> getMostCommonElements(@NotNull Map<K, AtomicLong> countMap, @NotNull List<ObjectPair<K, Long>> mostCommonElementList, int maxListSize, @NotNull AtomicLong skippedWithSameCount, @NotNull AtomicLong skippedWithLowerCount) {
        TreeMap reverseMap = new TreeMap(new ReverseComparator());
        for (Map.Entry<K, AtomicLong> entry : countMap.entrySet()) {
            Long count = entry.getValue().get();
            ArrayList<K> list = (ArrayList<K>)reverseMap.get(count);
            if (list == null) {
                list = new ArrayList<K>();
                reverseMap.put(count, list);
            }
            list.add(entry.getKey());
        }
        for (Map.Entry<Object, AtomicLong> entry : reverseMap.entrySet()) {
            Long l = (Long)entry.getKey();
            int numNotSkipped = 0;
            for (Object k : (List)((Object)entry.getValue())) {
                if (mostCommonElementList.size() >= maxListSize) {
                    if (numNotSkipped > 0) {
                        skippedWithSameCount.incrementAndGet();
                        continue;
                    }
                    skippedWithLowerCount.incrementAndGet();
                    continue;
                }
                ++numNotSkipped;
                mostCommonElementList.add(new ObjectPair(k, l));
            }
        }
        return mostCommonElementList;
    }

    private void updateAuthzCount(@Nullable String authzDN) {
        if (authzDN == null) {
            return;
        }
        String dnString = this.getDNString(authzDN);
        AtomicLong l = this.authzDNs.get(dnString);
        if (l == null) {
            l = new AtomicLong(0L);
            this.authzDNs.put(dnString, l);
        }
    }

    @Nullable
    private String getDNString(@Nullable String dn) {
        DN parsedDN;
        if (dn == null) {
            return null;
        }
        try {
            parsedDN = new DN(dn);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return dn.toLowerCase();
        }
        if (parsedDN.isNullDN()) {
            return "{Null DN}";
        }
        if (this.doNotAnonymize.isPresent()) {
            return parsedDN.toNormalizedString();
        }
        StringBuilder buffer = new StringBuilder();
        RDN[] rdns = parsedDN.getRDNs();
        for (int i = 0; i < rdns.length; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            RDN rdn = rdns[i];
            String[] attributeNames = rdn.getAttributeNames();
            for (int j = 0; j < attributeNames.length; ++j) {
                if (j > 0) {
                    buffer.append('+');
                }
                buffer.append(attributeNames[j].toLowerCase());
                buffer.append("=?");
            }
        }
        return buffer.toString();
    }

    @Nullable
    private String prepareFilter(@Nullable String filterString) {
        if (filterString == null) {
            return null;
        }
        if (this.doNotAnonymize.isPresent()) {
            return filterString.toLowerCase();
        }
        try {
            return new GenericFilter(Filter.create(filterString)).toString().toLowerCase();
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    private void printProcessingTimeHistogram(@NotNull String t, long n, @NotNull LinkedHashMap<Long, AtomicLong> m) {
        this.printHistogram("Count of " + t + " operations by processing time:", n, m);
    }

    private void printHistogram(@NotNull String h, long n, @NotNull LinkedHashMap<Long, AtomicLong> m) {
        if (n <= 0L) {
            return;
        }
        this.out(new Object[0]);
        this.out(h);
        long lowerBound = 0L;
        long accumulatedCount = 0L;
        Iterator<Map.Entry<Long, AtomicLong>> i = m.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Long, AtomicLong> e = i.next();
            long upperBound = e.getKey();
            long count = e.getValue().get();
            double categoryPercent = 100.0 * (double)count / (double)n;
            double accumulatedPercent = 100.0 * (double)(accumulatedCount += count) / (double)n;
            if (i.hasNext()) {
                String lowerBoundString;
                if (lowerBound == 0L) {
                    lowerBoundString = "0 milliseconds";
                } else {
                    long lowerBoundNanos = lowerBound * 1000000L;
                    lowerBoundString = DurationArgument.nanosToDuration(lowerBoundNanos);
                }
                long upperBoundNanos = upperBound * 1000000L;
                String upperBoundString = DurationArgument.nanosToDuration(upperBoundNanos);
                this.out("Between ", lowerBoundString, " and ", upperBoundString, ":  ", count, " (", this.decimalFormat.format(categoryPercent), "%, ", this.decimalFormat.format(accumulatedPercent), "% accumulated)");
                lowerBound = upperBound;
                continue;
            }
            long lowerBoundNanos = lowerBound * 1000000L;
            String lowerBoundString = DurationArgument.nanosToDuration(lowerBoundNanos);
            this.out("Greater than ", lowerBoundString, ":  ", count, " (", this.decimalFormat.format(categoryPercent), "%, ", this.decimalFormat.format(accumulatedPercent), "% accumulated)");
        }
    }

    private void printUncached(@NotNull String operationType, long numUncached, long numTotal) {
        if (numUncached == 0L) {
            return;
        }
        this.out(operationType, ":  ", numUncached, " (", this.decimalFormat.format(100.0 * (double)numUncached / (double)numTotal), "%)");
    }

    private void printCounts(@Nullable Map<String, AtomicLong> countMap, @NotNull String heading, @NotNull String singularItem, @NotNull String pluralItem) {
        if (countMap == null || countMap.isEmpty()) {
            return;
        }
        long totalCount = 0L;
        for (AtomicLong l : countMap.values()) {
            totalCount += l.get();
        }
        this.out(new Object[0]);
        this.out(heading);
        int displayCount = this.reportCount.getValue();
        if ((long)displayCount <= 0L) {
            displayCount = Integer.MAX_VALUE;
        }
        ArrayList countList = new ArrayList();
        AtomicLong skippedWithSameCount = new AtomicLong(0L);
        AtomicLong skippedWithLowerCount = new AtomicLong(0L);
        SummarizeAccessLog.getMostCommonElements(countMap, countList, displayCount, skippedWithSameCount, skippedWithLowerCount);
        long count = -1L;
        for (ObjectPair objectPair : countList) {
            count = (Long)objectPair.getSecond();
            if (totalCount > 0L) {
                double percent = 100.0 * (double)count / (double)totalCount;
                this.out(objectPair.getFirst(), ":  ", count, " (", this.decimalFormat.format(percent), ")");
                continue;
            }
            this.out(objectPair.getFirst(), ":  ", count);
        }
        if (skippedWithSameCount.get() > 0L) {
            this.out("{ Skipped " + skippedWithSameCount.get() + " additional " + this.getSingularOrPlural(skippedWithSameCount.get(), singularItem, pluralItem) + " with a count of " + count + " }");
        }
        if (skippedWithLowerCount.get() > 0L) {
            this.out("{ Skipped " + skippedWithLowerCount.get() + " additional " + this.getSingularOrPlural(skippedWithLowerCount.get(), singularItem, pluralItem) + " with a count that is less than " + count + " }");
        }
    }

    private void printResultCodeCounts(@Nullable Map<ResultCode, AtomicLong> countMap, @NotNull String operationType) {
        if (countMap == null || countMap.isEmpty()) {
            return;
        }
        long totalCount = 0L;
        for (AtomicLong l : countMap.values()) {
            totalCount += l.get();
        }
        this.out(new Object[0]);
        this.out("Most common " + operationType + " operation result codes:");
        int displayCount = this.reportCount.getValue();
        if ((long)displayCount <= 0L) {
            displayCount = Integer.MAX_VALUE;
        }
        ArrayList resultCodeList = new ArrayList();
        AtomicLong skippedWithSameCount = new AtomicLong(0L);
        AtomicLong skippedWithLowerCount = new AtomicLong(0L);
        SummarizeAccessLog.getMostCommonElements(countMap, resultCodeList, displayCount, skippedWithSameCount, skippedWithLowerCount);
        long count = -1L;
        for (ObjectPair objectPair : resultCodeList) {
            count = (Long)objectPair.getSecond();
            if (totalCount > 0L) {
                double percent = 100.0 * (double)count / (double)totalCount;
                this.out(((ResultCode)objectPair.getFirst()).getName(), " (", ((ResultCode)objectPair.getFirst()).intValue(), "):  ", count, " (", this.decimalFormat.format(percent), ")");
                continue;
            }
            this.out(objectPair.getFirst(), ":  ", count);
        }
        if (skippedWithSameCount.get() > 0L) {
            this.out("{ Skipped " + skippedWithSameCount.get() + " additional result " + this.getSingularOrPlural(skippedWithSameCount.get(), "code", "codes") + " with a count of " + count + " }");
        }
        if (skippedWithLowerCount.get() > 0L) {
            this.out("{ Skipped " + skippedWithLowerCount.get() + " additional result " + this.getSingularOrPlural(skippedWithLowerCount.get(), "code", "codes") + " with a count that is less than " + count + " }");
        }
    }

    @NotNull
    private String getSingularOrPlural(long count, @NotNull String singular, @NotNull String plural) {
        if (count == 1L) {
            return singular;
        }
        return plural;
    }
}

